/*
 * Decompiled with CFR 0.152.
 */
package jn.willfrydev.xchat.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import jn.willfrydev.xchat.XChat;
import jn.willfrydev.xchat.manager.IgnoreManager;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.util.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IgnoreCommand
implements CommandExecutor,
TabCompleter {
    private final XChat plugin;
    private final IgnoreManager ignoreManager;
    private static final List<String> SUB_COMMANDS = Arrays.asList("add", "remove", "list", "help");

    public IgnoreCommand(XChat plugin) {
        this.plugin = plugin;
        this.ignoreManager = plugin.getIgnoreManager();
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        String subCommand;
        if (!(sender instanceof Player)) {
            sender.sendMessage("Este comando solo puede ser usado por jugadores.");
            return true;
        }
        Player player = (Player)sender;
        if (args.length == 0 || args[0].equalsIgnoreCase("help")) {
            this.sendConfigList((CommandSender)player, "help-message.ignore");
            return true;
        }
        switch (subCommand = args[0].toLowerCase()) {
            case "add": {
                this.handleIgnore(player, args, true);
                break;
            }
            case "remove": {
                this.handleIgnore(player, args, false);
                break;
            }
            case "list": {
                this.handleList(player);
                break;
            }
            default: {
                this.sendMessage(player, "ignore.messages.yml.usage", null);
            }
        }
        return true;
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, @NotNull String[] args) {
        if (args.length == 1) {
            return (List)StringUtil.copyPartialMatches((String)args[0], SUB_COMMANDS, new ArrayList());
        }
        if (args.length == 2 && (args[0].equalsIgnoreCase("add") || args[0].equalsIgnoreCase("remove"))) {
            List playerNames = Bukkit.getOnlinePlayers().stream().map(Player::getName).collect(Collectors.toList());
            return (List)StringUtil.copyPartialMatches((String)args[1], playerNames, new ArrayList());
        }
        return Collections.emptyList();
    }

    private void handleIgnore(Player player, String[] args, boolean add) {
        if (args.length < 2) {
            this.sendMessage(player, "ignore.messages.yml.usage", null);
            return;
        }
        OfflinePlayer target = Bukkit.getOfflinePlayer((String)args[1]);
        if (!target.hasPlayedBefore() && !target.isOnline()) {
            this.sendMessage(player, "ignore.messages.yml.not_found", null);
            return;
        }
        if (player.getUniqueId().equals(target.getUniqueId())) {
            this.sendMessage(player, "ignore.messages.yml.cannot_ignore_self", null);
            return;
        }
        if (add) {
            this.ignoreManager.addIgnore(player.getUniqueId(), target.getUniqueId());
            this.sendMessage(player, "ignore.messages.yml.added", target.getName());
        } else {
            this.ignoreManager.removeIgnore(player.getUniqueId(), target.getUniqueId());
            this.sendMessage(player, "ignore.messages.yml.removed", target.getName());
        }
    }

    private void handleList(Player player) {
        Set<UUID> ignored = this.ignoreManager.getIgnoredPlayers(player.getUniqueId());
        if (ignored.isEmpty()) {
            this.sendMessage(player, "ignore.messages.yml.list_empty", null);
            return;
        }
        this.sendMessage(player, "ignore.messages.yml.list_header", null);
        String format = this.plugin.getConfig().getString("ignore.messages.yml.list_format", "&7- &f%target%");
        for (UUID ignoredUUID : ignored) {
            OfflinePlayer target = Bukkit.getOfflinePlayer((UUID)ignoredUUID);
            player.sendMessage((Component)this.plugin.getLegacySerializer().deserialize(format.replace("%target%", target.getName())));
        }
    }

    private void sendMessage(Player player, String path, String targetName) {
        String message = this.plugin.getConfig().getString(path, "&cMensaje no encontrado: " + path);
        if (targetName != null) {
            message = message.replace("%target%", targetName);
        }
        player.sendMessage((Component)this.plugin.getLegacySerializer().deserialize(message));
    }

    private void sendConfigList(CommandSender sender, String path) {
        for (String line : this.plugin.getConfig().getStringList(path)) {
            sender.sendMessage((Component)this.plugin.getLegacySerializer().deserialize(line));
        }
    }
}

