/*
 * Decompiled with CFR 0.152.
 */
package jn.willfrydev.xchat.commands;

import java.util.Arrays;
import java.util.UUID;
import jn.willfrydev.xchat.XChat;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.Sound;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class MessageCommand
implements CommandExecutor {
    private final XChat plugin;

    public MessageCommand(XChat plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (!(sender instanceof Player)) {
            this.plugin.sendMessage(sender, this.plugin.getMessages().getString("console-not-supported"));
            return true;
        }
        if (args.length < 2) {
            this.plugin.sendMessage(sender, this.plugin.getMessages().getString("pm.usage").replace("{label}", label));
            return true;
        }
        Player target = Bukkit.getPlayer((String)args[0]);
        if (target == null) {
            this.plugin.sendMessage(sender, this.plugin.getMessages().getString("player-not-found"));
            return true;
        }
        Player player = (Player)sender;
        if (player.equals(target)) {
            this.plugin.sendMessage(sender, this.plugin.getMessages().getString("pm.cannot-message-self"));
            return true;
        }
        String message = String.join((CharSequence)" ", Arrays.copyOfRange(args, 1, args.length));
        String filteredMessage = this.plugin.getFilterManager().filterMessage(player, message);
        if (filteredMessage == null) {
            return true;
        }
        String senderFormat = this.plugin.getMessages().getString("pm.format.sender", "&7[&bYo &f-> &b%receiver_name%&7] &f%message%").replace("%receiver_name%", target.getName()).replace("%message%", filteredMessage);
        String receiverFormat = this.plugin.getMessages().getString("pm.format.receiver", "&7[&b%sender_name% &f-> &bYo&7] &f%message%").replace("%sender_name%", player.getName()).replace("%message%", filteredMessage);
        player.sendMessage((Component)this.plugin.getLegacySerializer().deserialize(senderFormat));
        target.sendMessage((Component)this.plugin.getLegacySerializer().deserialize(receiverFormat));
        try {
            Sound messageSound = Sound.valueOf((String)this.plugin.getConfig().getString("pm.sound", "ENTITY_EXPERIENCE_ORB_PICKUP"));
            target.playSound(target.getLocation(), messageSound, 1.0f, 1.0f);
        }
        catch (IllegalArgumentException e) {
            this.plugin.getLogger().warning("El sonido en config.yml 'pm.sound' no es v\u00e1lido.");
        }
        this.plugin.getLastMessageSender().put(target.getUniqueId(), player.getUniqueId());
        this.plugin.getLastMessageSender().put(player.getUniqueId(), target.getUniqueId());
        String spyFormat = this.plugin.getMessages().getString("pm.social-spy-format", "&8[&cSPY&8] &7%sender_name% &8\u25b8 &7%receiver_name% &8\u25b8 &f").replace("%sender_name%", player.getName()).replace("%receiver_name%", target.getName()).replace("%message%", filteredMessage);
        for (UUID spyUUID : this.plugin.getSocialSpyUsers()) {
            Player spy = Bukkit.getPlayer((UUID)spyUUID);
            if (spy == null || spy.equals(player) || spy.equals(target)) continue;
            spy.sendMessage((Component)this.plugin.getLegacySerializer().deserialize(spyFormat));
        }
        return true;
    }
}

