/*
 * Decompiled with CFR 0.152.
 */
package jn.willfrydev.xchat.commands;

import java.util.UUID;
import jn.willfrydev.xchat.XChat;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class ReplyCommand
implements CommandExecutor {
    private final XChat plugin;

    public ReplyCommand(XChat plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (!(sender instanceof Player)) {
            this.plugin.sendMessage(sender, this.plugin.getMessages().getString("console-not-supported"));
            return true;
        }
        Player player = (Player)sender;
        UUID lastSenderUUID = this.plugin.getLastMessageSender().get(player.getUniqueId());
        if (lastSenderUUID == null) {
            this.plugin.sendMessage((CommandSender)player, this.plugin.getMessages().getString("pm.no-reply-target"));
            return true;
        }
        Player target = Bukkit.getPlayer((UUID)lastSenderUUID);
        if (target == null) {
            this.plugin.sendMessage((CommandSender)player, this.plugin.getMessages().getString("player-not-found"));
            return true;
        }
        if (args.length == 0) {
            this.plugin.sendMessage((CommandSender)player, this.plugin.getMessages().getString("pm.reply_usage").replace("{label}", label));
            return true;
        }
        String message = String.join((CharSequence)" ", args);
        String filteredMessage = this.plugin.getFilterManager().filterMessage(player, message);
        if (filteredMessage == null) {
            return true;
        }
        player.performCommand("msg " + target.getName() + " " + filteredMessage);
        return true;
    }
}

