/*
 * Decompiled with CFR 0.152.
 */
package jn.willfrydev.xchat.listeners;

import io.papermc.paper.event.player.AsyncChatEvent;
import jn.willfrydev.xchat.XChat;
import me.clip.placeholderapi.PlaceholderAPI;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.event.ClickEvent;
import net.kyori.adventure.text.event.HoverEvent;
import net.kyori.adventure.text.event.HoverEventSource;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import net.milkbowl.vault.chat.Chat;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;

public class ChatListener
implements Listener {
    private final XChat plugin;

    public ChatListener(XChat plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.NORMAL, ignoreCancelled=true)
    public void onPlayerChat(AsyncChatEvent event) {
        if (!this.plugin.getConfig().getBoolean("modules.chat-formatting")) {
            return;
        }
        Player sender = event.getPlayer();
        String plainMessage = ((TextComponent)event.message()).content();
        String filteredMessage = this.plugin.getFilterManager().filterMessage(sender, plainMessage);
        if (filteredMessage == null) {
            event.setCancelled(true);
            return;
        }
        Chat vaultChat = this.plugin.getVaultChat();
        String playerGroup = vaultChat != null ? vaultChat.getPrimaryGroup(sender) : null;
        String groupFormatPath = "groups." + playerGroup;
        String baseFormat = playerGroup != null && this.plugin.getConfig().isSet(groupFormatPath) ? this.plugin.getConfig().getString(groupFormatPath) : this.plugin.getConfig().getString("chat-format", "%player_name%&7: &f%message%");
        String nameFormatPart = baseFormat.contains("%message%") ? baseFormat.substring(0, baseFormat.indexOf("%message%")) : baseFormat;
        Component finalMessage = this.buildFinalMessage(sender, nameFormatPart, filteredMessage);
        event.renderer((source, sourceDisplayName, message, viewer) -> {
            if (viewer instanceof Player && this.plugin.getIgnoreManager().isIgnoring(((Player)viewer).getUniqueId(), source.getUniqueId())) {
                return Component.empty();
            }
            return finalMessage;
        });
    }

    private Component buildFinalMessage(Player sender, String nameFormat, String message) {
        LegacyComponentSerializer serializer = this.plugin.getLegacySerializer();
        ConfigurationSection hoverConfig = this.plugin.getConfig().getConfigurationSection("hover-format.default");
        String hoverDescription = hoverConfig.getString("description", "");
        String clickAction = hoverConfig.getString("click", "");
        String hoverText = String.join((CharSequence)"\n", hoverConfig.getStringList("lines"));
        nameFormat = this.applyPlaceholders(sender, nameFormat);
        hoverDescription = this.applyPlaceholders(sender, hoverDescription);
        clickAction = this.applyPlaceholders(sender, clickAction);
        hoverText = this.applyPlaceholders(sender, hoverText);
        TextComponent nameComponent = serializer.deserialize(nameFormat);
        TextComponent hoverComponent = serializer.deserialize(hoverDescription + "\n" + hoverText);
        nameComponent = nameComponent.hoverEvent((HoverEventSource)HoverEvent.showText((Component)hoverComponent)).clickEvent(ClickEvent.suggestCommand((String)clickAction));
        TextComponent messageComponent = Component.text((String)message);
        if (sender.hasPermission("xchat.colors")) {
            messageComponent = serializer.deserialize(message);
        }
        return nameComponent.append((Component)messageComponent);
    }

    private String applyPlaceholders(Player player, String text) {
        if (this.plugin.isPlaceholderApiEnabled()) {
            return PlaceholderAPI.setPlaceholders((Player)player, (String)text);
        }
        return text;
    }
}

