/*
 * Decompiled with CFR 0.152.
 */
package jn.willfrydev.xchat.manager;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import jn.willfrydev.xchat.XChat;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;

public class FilterManager {
    private final XChat plugin;
    private final Map<UUID, Long> chatCooldowns = new HashMap<UUID, Long>();
    private final Map<UUID, String> lastMessages = new HashMap<UUID, String>();
    private List<String> blockedWords;
    private List<String> blockedPatterns;
    private Pattern ipPattern;

    public FilterManager(XChat plugin) {
        this.plugin = plugin;
        this.loadConfig();
        this.ipPattern = Pattern.compile("([0-9]{1,3}\\.){3}[0-9]{1,3}|([a-zA-Z0-9\\-]+\\.)+[a-zA-Z]{2,}");
    }

    public void loadConfig() {
        FileConfiguration config = this.plugin.getConfig();
        this.blockedWords = config.getStringList("modules.anti-swear.blocked-words");
        this.blockedPatterns = config.getStringList("modules.anti-advertising.blocked-patterns");
    }

    public String filterMessage(Player player, String message) {
        int maxSpaces;
        FileConfiguration config = this.plugin.getConfig();
        if (config.getBoolean("modules.anti-spam-delay.enabled") && !player.hasPermission("xchat.bypass.antispam")) {
            long lastTime;
            long delay = config.getLong("modules.anti-spam-delay.delay-seconds");
            long currentTime = System.currentTimeMillis();
            if (currentTime - (lastTime = this.chatCooldowns.getOrDefault(player.getUniqueId(), 0L).longValue()) < TimeUnit.SECONDS.toMillis(delay)) {
                long timeLeft = TimeUnit.MILLISECONDS.toSeconds(TimeUnit.SECONDS.toMillis(delay) - (currentTime - lastTime)) + 1L;
                this.plugin.sendMessage((CommandSender)player, this.plugin.getMessages().getString("anti-spam.delay").replace("%time%", String.valueOf(timeLeft)));
                return null;
            }
            this.chatCooldowns.put(player.getUniqueId(), currentTime);
        }
        if (config.getBoolean("modules.anti-message-repeat.enabled") && !player.hasPermission("xchat.bypass.antirepeat")) {
            if (message.equalsIgnoreCase(this.lastMessages.get(player.getUniqueId()))) {
                this.plugin.sendMessage((CommandSender)player, this.plugin.getMessages().getString("anti-spam.repeat"));
                return null;
            }
            this.lastMessages.put(player.getUniqueId(), message);
        }
        if (config.getBoolean("modules.anti-space-spam.enabled") && !player.hasPermission("xchat.bypass.spacespam") && message.matches(".*\\s{" + (maxSpaces = config.getInt("modules.anti-space-spam.max-consecutive-spaces", 5)) + ",}.*")) {
            this.plugin.sendMessage((CommandSender)player, this.plugin.getMessages().getString("anti-spam.space-spam"));
            return null;
        }
        if (config.getBoolean("modules.anti-color-code.enabled") && !player.hasPermission("xchat.colors") && message.matches(".*[&\u00a7#].*")) {
            this.plugin.sendMessage((CommandSender)player, this.plugin.getMessages().getString("anti-spam.color-code"));
            return null;
        }
        if (config.getBoolean("modules.anti-swear.enabled") && !player.hasPermission("xchat.bypass.antiswear")) {
            for (String word : this.blockedWords) {
                if (!message.toLowerCase().contains(word.toLowerCase())) continue;
                this.plugin.sendMessage((CommandSender)player, this.plugin.getMessages().getString("anti-spam.swear"));
                return null;
            }
        }
        if (config.getBoolean("modules.anti-advertising.enabled") && !player.hasPermission("xchat.bypass.antiad")) {
            String lowerCaseMessage = message.toLowerCase();
            for (String pattern : this.blockedPatterns) {
                if (!lowerCaseMessage.contains(pattern.toLowerCase())) continue;
                this.plugin.sendMessage((CommandSender)player, this.plugin.getMessages().getString("anti-spam.advertising"));
                return null;
            }
            if (this.ipPattern.matcher(lowerCaseMessage).find()) {
                this.plugin.sendMessage((CommandSender)player, this.plugin.getMessages().getString("anti-spam.advertising"));
                return null;
            }
        }
        return message;
    }
}

