/*
 * Decompiled with CFR 0.152.
 */
package jn.willfrydev.xchat.utils;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import jn.willfrydev.xchat.XChat;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;

public class UpdateChecker {
    private final XChat plugin;
    private final String projectId;

    public UpdateChecker(XChat plugin, String projectId) {
        this.plugin = plugin;
        this.projectId = projectId;
    }

    public void check() {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, () -> {
            try {
                URL url = new URL("https://api.modrinth.com/v2/project/" + this.projectId + "/version");
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("GET");
                connection.setRequestProperty("User-Agent", "WillfryDev/xChat-UpdateChecker");
                if (connection.getResponseCode() == 200) {
                    InputStreamReader reader = new InputStreamReader(connection.getInputStream());
                    JsonArray versions = JsonParser.parseReader((Reader)reader).getAsJsonArray();
                    if (versions.size() > 0) {
                        JsonObject latestVersion = versions.get(0).getAsJsonObject();
                        String latestVersionNumber = latestVersion.get("version_number").getAsString();
                        String currentVersion = this.plugin.getDescription().getVersion();
                        if (!currentVersion.equalsIgnoreCase(latestVersionNumber)) {
                            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                                this.plugin.getLogger().info("-------------------------------------------");
                                this.plugin.getLogger().info("\u00a1Hay una nueva versi\u00f3n de xChat disponible!");
                                this.plugin.getLogger().info("  > Tu versi\u00f3n: " + currentVersion);
                                this.plugin.getLogger().info("  > Nueva versi\u00f3n: " + latestVersionNumber);
                                this.plugin.getLogger().info("  > Desc\u00e1rgala desde: https://modrinth.com/project/" + this.projectId);
                                this.plugin.getLogger().info("-------------------------------------------");
                            });
                        }
                    }
                    reader.close();
                }
                connection.disconnect();
            }
            catch (Exception e) {
                this.plugin.getLogger().warning("No se pudo verificar si hay nuevas actualizaciones.");
            }
        });
    }
}

