/*
 * Decompiled with CFR 0.152.
 */
package com.erix.creatorsword.client;

import com.erix.creatorsword.client.KeyBindings;
import com.erix.creatorsword.client.KeyInputHandler;
import com.erix.creatorsword.data.ModDataComponents;
import com.erix.creatorsword.item.cogwheel_shield.CogwheelShieldItem;
import com.erix.creatorsword.network.ShieldStatePayload;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientPlayerNetworkEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.RenderGuiEvent;
import net.neoforged.neoforge.network.PacketDistributor;

@EventBusSubscriber(modid="creatorsword", value={Dist.CLIENT}, bus=EventBusSubscriber.Bus.GAME)
public class CreatorSwordClientEvents {
    private static final float THROW_SPEED_THRESHOLD = 64.0f;
    private static boolean wasVPressed = false;

    @SubscribeEvent
    public static void onRenderGui(RenderGuiEvent.Post event) {
        KeyInputHandler.clientTick();
    }

    @SubscribeEvent
    public static void onKeyInput(InputEvent.Key event) {
        float speed;
        ItemStack stack;
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null) {
            return;
        }
        boolean isVPressed = KeyBindings.ROTATE_COGWHEEL.isDown();
        if (!isVPressed && wasVPressed && (stack = mc.player.getItemInHand(InteractionHand.OFF_HAND)).getItem() instanceof CogwheelShieldItem && (speed = ((Float)stack.getOrDefault((DataComponentType)ModDataComponents.GEAR_SHIELD_SPEED.get(), (Object)Float.valueOf(0.0f))).floatValue()) >= 64.0f) {
            KeyInputHandler.triggerThrowShield(stack, speed);
        }
        wasVPressed = isVPressed;
    }

    private static void syncShieldState(ItemStack stack, boolean isOffhand) {
        if (!(stack.getItem() instanceof CogwheelShieldItem)) {
            return;
        }
        float speed = ((Float)stack.getOrDefault((DataComponentType)ModDataComponents.GEAR_SHIELD_SPEED.get(), (Object)Float.valueOf(0.0f))).floatValue();
        boolean charging = (Boolean)stack.getOrDefault((DataComponentType)ModDataComponents.GEAR_SHIELD_CHARGING.get(), (Object)false);
        if (speed > 0.0f && !charging) {
            stack.set((DataComponentType)ModDataComponents.GEAR_SHIELD_DECAYING.get(), (Object)true);
            PacketDistributor.sendToServer((CustomPacketPayload)new ShieldStatePayload(stack, isOffhand), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    @SubscribeEvent
    public static void onPlayerLogin(ClientPlayerNetworkEvent.LoggingIn event) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null || mc.level == null) {
            return;
        }
        CreatorSwordClientEvents.syncShieldState(mc.player.getOffhandItem(), true);
        CreatorSwordClientEvents.syncShieldState(mc.player.getMainHandItem(), false);
    }

    private static void resetAndSyncShield(ItemStack stack, boolean isOffhand) {
        if (!(stack.getItem() instanceof CogwheelShieldItem)) {
            return;
        }
        CogwheelShieldItem.resetNBT(stack);
        PacketDistributor.sendToServer((CustomPacketPayload)new ShieldStatePayload(stack, isOffhand), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    @SubscribeEvent
    public static void onPlayerLogout(ClientPlayerNetworkEvent.LoggingOut event) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null) {
            return;
        }
        CreatorSwordClientEvents.resetAndSyncShield(mc.player.getOffhandItem(), true);
        CreatorSwordClientEvents.resetAndSyncShield(mc.player.getMainHandItem(), false);
    }

    @SubscribeEvent
    public static void onRenderHUD(RenderGuiEvent.Post event) {
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (player == null) {
            return;
        }
        ItemStack offhand = player.getOffhandItem();
        if (!(offhand.getItem() instanceof CogwheelShieldItem)) {
            return;
        }
        if (!player.isUsingItem() || player.getUseItem() != offhand) {
            return;
        }
        float speed = ((Float)offhand.getOrDefault((DataComponentType)ModDataComponents.GEAR_SHIELD_SPEED.get(), (Object)Float.valueOf(0.0f))).floatValue();
        if (speed < 0.01f) {
            return;
        }
        GuiGraphics guiGraphics = event.getGuiGraphics();
        PoseStack poseStack = guiGraphics.pose();
        String text = String.format("%.1f RPM", Float.valueOf(speed));
        int screenWidth = mc.getWindow().getGuiScaledWidth();
        int screenHeight = mc.getWindow().getGuiScaledHeight();
        int x = screenWidth - mc.font.width(text) - 7;
        int y = screenHeight - 10;
        int color = CreatorSwordClientEvents.getColorFromSpeed(speed);
        poseStack.pushPose();
        if (speed >= 512.0f) {
            long time = System.currentTimeMillis();
            int charX = x;
            for (int i = 0; i < text.length(); ++i) {
                float hue = (float)(((double)((float)i * 0.13f) + (double)(time % 2000L) / 2000.0) % 1.0);
                int rgb = Color.HSBtoRGB(hue, 1.0f, 1.0f);
                String c = String.valueOf(text.charAt(i));
                guiGraphics.drawString(mc.font, c, charX, y, rgb, true);
                charX += mc.font.width(c);
            }
        } else {
            guiGraphics.drawString(mc.font, text, x, y, color, true);
        }
        poseStack.popPose();
    }

    private static int getColorFromSpeed(float speed) {
        if (speed < 64.0f) {
            return 0xFFFFFF;
        }
        if (speed < 128.0f) {
            return 0x22FF22;
        }
        if (speed < 256.0f) {
            return 34047;
        }
        if (speed < 512.0f) {
            return 0xFF55FF;
        }
        return 0xFFFFFF;
    }
}

