/*
 * Decompiled with CFR 0.152.
 */
package com.erix.creatorsword.client;

import com.erix.creatorsword.client.KeyBindings;
import com.erix.creatorsword.data.ModDataComponents;
import com.erix.creatorsword.item.cogwheel_shield.CogwheelShieldItem;
import com.erix.creatorsword.network.ShieldThrowPayload;
import net.minecraft.client.Minecraft;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;

public class KeyInputHandler {
    private static boolean wasDown = false;

    public static void clientTick() {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null) {
            return;
        }
        boolean isDown = KeyBindings.ROTATE_COGWHEEL.isDown();
        ItemStack off = mc.player.getOffhandItem();
        ItemStack main = mc.player.getMainHandItem();
        Item item = off.getItem();
        if (item instanceof CogwheelShieldItem) {
            CogwheelShieldItem shieldOff = (CogwheelShieldItem)item;
            shieldOff.tickClient(off, (Player)mc.player, isDown);
        }
        if ((item = main.getItem()) instanceof CogwheelShieldItem) {
            CogwheelShieldItem shieldMain = (CogwheelShieldItem)item;
            shieldMain.tickClient(main, (Player)mc.player, isDown);
        }
        KeyInputHandler.updateRotation(off, true);
        KeyInputHandler.updateRotation(main, false);
        if (!isDown && wasDown) {
            float speed;
            ItemStack stack = ItemStack.EMPTY;
            if (off.getItem() instanceof CogwheelShieldItem) {
                stack = off;
            }
            if (!stack.isEmpty() && (speed = ((Float)stack.getOrDefault((DataComponentType)ModDataComponents.GEAR_SHIELD_SPEED.get(), (Object)Float.valueOf(0.0f))).floatValue()) >= 64.0f) {
                KeyInputHandler.triggerThrowShield(stack, speed);
                if (off == stack) {
                    mc.player.getInventory().offhand.set(0, (Object)ItemStack.EMPTY);
                }
            }
        }
        wasDown = isDown;
    }

    private static void updateRotation(ItemStack stack, boolean offhand) {
        float angle = ((Float)stack.getOrDefault((DataComponentType)ModDataComponents.GEAR_SHIELD_ANGLE.get(), (Object)Float.valueOf(0.0f))).floatValue();
        float speed = ((Float)stack.getOrDefault((DataComponentType)ModDataComponents.GEAR_SHIELD_SPEED.get(), (Object)Float.valueOf(0.0f))).floatValue();
        angle += (float)(offhand ? 1 : -1) * (speed / 20.0f);
        angle = (angle + 360.0f) % 360.0f;
        stack.set((DataComponentType)ModDataComponents.GEAR_SHIELD_ANGLE.get(), (Object)Float.valueOf(angle));
    }

    public static void triggerThrowShield(ItemStack stack, float speed) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null || mc.level == null) {
            return;
        }
        stack.set((DataComponentType)ModDataComponents.GEAR_SHIELD_DECAYING.get(), (Object)true);
        PacketDistributor.sendToServer((CustomPacketPayload)new ShieldThrowPayload(speed, stack), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

