/*
 * Decompiled with CFR 0.152.
 */
package com.erix.creatorsword.datagen.enchantments;

import com.erix.creatorsword.ResourceLocationUtil;
import com.erix.creatorsword.datagen.tags.ModTag;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;

public class EnchantmentKeys {
    public static final ResourceKey<Enchantment> PNEUMATIC_BOOST = EnchantmentKeys.registerKey("pneumatic_boost");
    public static final ResourceKey<Enchantment> OVERDRIVE = EnchantmentKeys.registerKey("overdrive");

    private static ResourceKey<Enchantment> registerKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.ENCHANTMENT, (ResourceLocation)ResourceLocationUtil.getResourceLocation(name));
    }

    public static void bootstrap(BootstrapContext<Enchantment> context) {
        HolderGetter damageTypes = context.lookup(Registries.DAMAGE_TYPE);
        HolderGetter enchantments = context.lookup(Registries.ENCHANTMENT);
        HolderGetter items = context.lookup(Registries.ITEM);
        HolderGetter blocks = context.lookup(Registries.BLOCK);
        EnchantmentKeys.register(context, PNEUMATIC_BOOST, new Enchantment.Builder(Enchantment.definition((HolderSet)items.getOrThrow(ModTag.ENCHANTABLE_PNEUMATIC_BOOST), (int)7, (int)4, (Enchantment.Cost)Enchantment.dynamicCost((int)8, (int)8), (Enchantment.Cost)Enchantment.dynamicCost((int)30, (int)15), (int)1, (EquipmentSlotGroup[])new EquipmentSlotGroup[]{EquipmentSlotGroup.HAND})));
        EnchantmentKeys.register(context, OVERDRIVE, new Enchantment.Builder(Enchantment.definition((HolderSet)items.getOrThrow(ModTag.ENCHANTABLE_OVERDRIVE), (int)7, (int)1, (Enchantment.Cost)Enchantment.dynamicCost((int)8, (int)8), (Enchantment.Cost)Enchantment.dynamicCost((int)30, (int)15), (int)1, (EquipmentSlotGroup[])new EquipmentSlotGroup[]{EquipmentSlotGroup.HAND})));
    }

    private static void register(BootstrapContext<Enchantment> context, ResourceKey<Enchantment> key, Enchantment.Builder builder) {
        context.register(key, (Object)builder.build(key.location()));
    }

    public static int getEnchantmentLevel(RegistryAccess access, ResourceKey<Enchantment> enchantmentResourceKey, ItemStack handItem) {
        return EnchantmentHelper.getTagEnchantmentLevel(EnchantmentKeys.getEnchantmentHolder(access, enchantmentResourceKey), (ItemStack)handItem);
    }

    public static Holder<Enchantment> getEnchantmentHolder(RegistryAccess access, ResourceKey<Enchantment> enchantmentResourceKey) {
        return access.registryOrThrow(Registries.ENCHANTMENT).getHolderOrThrow(enchantmentResourceKey);
    }
}

