/*
 * Decompiled with CFR 0.152.
 */
package com.erix.creatorsword.item.creator_sword;

import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.AllTags;
import com.simibubi.create.Create;
import com.simibubi.create.content.equipment.armor.BacktankUtil;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.foundation.item.render.CustomRenderedItemModelRenderer;
import com.simibubi.create.foundation.item.render.SimpleCustomRenderer;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.event.entity.player.AttackEntityEvent;

public abstract class BaseCreatorSwordItem
extends SwordItem {
    public BaseCreatorSwordItem(Tiers tier, Item.Properties attributes) {
        super((Tier)tier, attributes);
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        stack.hurtAndBreak(1, attacker, EquipmentSlot.MAINHAND);
        if (!attacker.level().isClientSide() && attacker instanceof Player) {
            Player player = (Player)attacker;
            this.handleBacktankLogic(player);
        }
        return true;
    }

    private void handleBacktankLogic(Player player) {
        List backtanks = BacktankUtil.getAllWithAir((LivingEntity)player);
        if (!backtanks.isEmpty()) {
            int airCost = -100;
            BacktankUtil.consumeAir((LivingEntity)player, (ItemStack)((ItemStack)backtanks.get(0)), (int)airCost);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept((IClientItemExtensions)SimpleCustomRenderer.create((Item)this, (CustomRenderedItemModelRenderer)this.getRenderer()));
    }

    @OnlyIn(value=Dist.CLIENT)
    protected abstract CustomRenderedItemModelRenderer getRenderer();

    @Nonnull
    public InteractionResult useOn(UseOnContext context) {
        Player player = context.getPlayer();
        if (player != null && player.mayBuild()) {
            BlockState state = context.getLevel().getBlockState(context.getClickedPos());
            Block block = state.getBlock();
            if (block instanceof IWrenchable) {
                IWrenchable actor = (IWrenchable)block;
                return player.isShiftKeyDown() ? actor.onSneakWrenched(state, context) : actor.onWrenched(state, context);
            }
            if (player.isShiftKeyDown() && this.canWrenchPickup(state)) {
                return this.onItemUseOnOther(context);
            }
        }
        return super.useOn(context);
    }

    private boolean canWrenchPickup(BlockState state) {
        return AllTags.AllBlockTags.WRENCH_PICKUP.matches(state);
    }

    private InteractionResult onItemUseOnOther(UseOnContext context) {
        Player player = context.getPlayer();
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos();
        BlockState state = world.getBlockState(pos);
        if (!(world instanceof ServerLevel)) {
            return InteractionResult.SUCCESS;
        }
        ServerLevel serverLevel = (ServerLevel)world;
        if (player != null && !player.isCreative()) {
            Block.getDrops((BlockState)state, (ServerLevel)serverLevel, (BlockPos)pos, (BlockEntity)world.getBlockEntity(pos), (Entity)player, (ItemStack)context.getItemInHand()).forEach(stack -> player.getInventory().placeItemBackInInventory(stack));
        }
        state.spawnAfterBreak(serverLevel, pos, ItemStack.EMPTY, true);
        world.destroyBlock(pos, false);
        AllSoundEvents.WRENCH_REMOVE.playOnServer(world, (Vec3i)pos, 1.0f, Create.RANDOM.nextFloat() * 0.5f + 0.5f);
        return InteractionResult.SUCCESS;
    }

    public static void wrenchInstaKillsMinecarts(AttackEntityEvent event) {
        Entity target = event.getTarget();
        if (target instanceof AbstractMinecart) {
            AbstractMinecart minecart = (AbstractMinecart)target;
            Player player = event.getEntity();
            ItemStack heldItem = player.getMainHandItem();
            if (heldItem.is(Tags.Items.TOOLS_WRENCH) && !player.isCreative()) {
                minecart.hurt(minecart.damageSources().playerAttack(player), 100.0f);
            }
        }
    }

    public static void playRotateSound(Level level, BlockPos pos) {
        AllSoundEvents.WRENCH_ROTATE.playOnServer(level, (Vec3i)pos, 1.0f, Create.RANDOM.nextFloat() + 0.5f);
    }

    public static void playRemoveSound(Level level, BlockPos pos) {
        AllSoundEvents.WRENCH_REMOVE.playOnServer(level, (Vec3i)pos, 1.0f, Create.RANDOM.nextFloat() * 0.5f + 0.5f);
    }
}

