/*
 * Decompiled with CFR 0.152.
 */
package com.erix.creatorsword.network;

import com.erix.creatorsword.advancement.CreatorSwordCriteriaTriggers;
import com.erix.creatorsword.advancement.FullSpeedTrigger;
import com.erix.creatorsword.data.ModDataComponents;
import com.erix.creatorsword.entity.ThrownCogwheelShield;
import com.erix.creatorsword.item.cogwheel_shield.CogwheelShieldItem;
import com.erix.creatorsword.network.ShieldFullSpeedPayload;
import com.erix.creatorsword.network.ShieldStatePayload;
import com.erix.creatorsword.network.ShieldThrowPayload;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;

public class NetworkHandler {
    @SubscribeEvent
    public static void registerPayloads(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("1");
        registrar.playToServer(ShieldFullSpeedPayload.TYPE, ShieldFullSpeedPayload.STREAM_CODEC, (payload, context) -> {
            ServerPlayer player = (ServerPlayer)context.player();
            if (player != null) {
                ((FullSpeedTrigger)((Object)((Object)CreatorSwordCriteriaTriggers.FULL_SPEED.get()))).trigger(player);
            }
        });
        registrar.playToServer(ShieldThrowPayload.TYPE, ShieldThrowPayload.STREAM_CODEC, (payload, context) -> {
            ItemStack stack;
            ServerPlayer player = (ServerPlayer)context.player();
            if (player != null && (stack = player.getItemInHand(InteractionHand.OFF_HAND)).getItem() instanceof CogwheelShieldItem && stack.is(payload.stack().getItem()) && player.level().getEntitiesOfClass(ThrownCogwheelShield.class, player.getBoundingBox().inflate(5.0), e -> e.getOwner() == player).isEmpty()) {
                ThrownCogwheelShield projectile = new ThrownCogwheelShield(player.level(), (LivingEntity)player, payload.speed(), stack.copy());
                projectile.shootFromRotation((Entity)player, player.getXRot(), player.getYRot(), 0.0f, 1.5f, 1.0f);
                player.level().addFreshEntity((Entity)projectile);
                player.setItemInHand(InteractionHand.OFF_HAND, ItemStack.EMPTY);
            }
        });
        registrar.playToServer(ShieldStatePayload.TYPE, ShieldStatePayload.STREAM_CODEC, (payload, context) -> {
            ServerPlayer player = (ServerPlayer)context.player();
            if (player == null) {
                return;
            }
            InteractionHand hand = payload.offhand() ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND;
            ItemStack serverStack = player.getItemInHand(hand);
            if (!(serverStack.getItem() instanceof CogwheelShieldItem)) {
                return;
            }
            ItemStack clientStack = payload.stack();
            float clientSpeed = ((Float)clientStack.getOrDefault((DataComponentType)ModDataComponents.GEAR_SHIELD_SPEED.get(), (Object)Float.valueOf(0.0f))).floatValue();
            boolean clientCharging = (Boolean)clientStack.getOrDefault((DataComponentType)ModDataComponents.GEAR_SHIELD_CHARGING.get(), (Object)false);
            boolean clientDecaying = (Boolean)clientStack.getOrDefault((DataComponentType)ModDataComponents.GEAR_SHIELD_DECAYING.get(), (Object)true);
            if (Math.abs(((Float)serverStack.getOrDefault((DataComponentType)ModDataComponents.GEAR_SHIELD_SPEED.get(), (Object)Float.valueOf(0.0f))).floatValue() - clientSpeed) > 0.01f) {
                serverStack.set((DataComponentType)ModDataComponents.GEAR_SHIELD_SPEED.get(), (Object)Float.valueOf(clientSpeed));
            }
            if ((Boolean)serverStack.getOrDefault((DataComponentType)ModDataComponents.GEAR_SHIELD_CHARGING.get(), (Object)false) != clientCharging) {
                serverStack.set((DataComponentType)ModDataComponents.GEAR_SHIELD_CHARGING.get(), (Object)clientCharging);
            }
            if ((Boolean)serverStack.getOrDefault((DataComponentType)ModDataComponents.GEAR_SHIELD_DECAYING.get(), (Object)false) != clientDecaying) {
                serverStack.set((DataComponentType)ModDataComponents.GEAR_SHIELD_DECAYING.get(), (Object)clientDecaying);
            }
        });
    }
}

