/*
 * Decompiled with CFR 0.152.
 */
package com.erix.creatorsword.client;

import com.erix.creatorsword.client.KeyBindings;
import com.erix.creatorsword.data.ModDataComponents;
import com.erix.creatorsword.enchantment.ModEnchantmentComponents;
import com.erix.creatorsword.enchantment.PneumaticBoostEffect;
import com.erix.creatorsword.item.cogwheel_shield.CogwheelShieldItem;
import com.erix.creatorsword.network.ShieldFullSpeedPayload;
import com.erix.creatorsword.network.ShieldThrowPayload;
import com.simibubi.create.content.equipment.armor.BacktankUtil;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.client.Minecraft;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.neoforged.neoforge.network.PacketDistributor;

public class KeyInputHandler {
    private static boolean wasDown = false;
    private static final float MAX_SPEED = 256.0f;
    private static final float MIN_SPEED = 8.0f;
    private static final long DECAY_INTERVAL_MS = 750L;
    private static long lastAirConsumeTime = 0L;
    private static final long AIR_CONSUME_INTERVAL = 1000L;
    static float basicFactor = 1.0f;

    public static void clientTick() {
        boolean offFull;
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null) {
            return;
        }
        ItemStack off = mc.player.getOffhandItem();
        ItemStack main = mc.player.getMainHandItem();
        if (off.getItem() instanceof CogwheelShieldItem) {
            KeyInputHandler.handleShield(off, true);
            KeyInputHandler.updateRotationAngle(off, true);
        }
        if (main.getItem() instanceof CogwheelShieldItem) {
            KeyInputHandler.handleShield(main, false);
            KeyInputHandler.updateRotationAngle(main, false);
        }
        if (mc.screen != null) {
            wasDown = true;
            if (main.getItem() instanceof CogwheelShieldItem) {
                main.set((DataComponentType)ModDataComponents.GEAR_SHIELD_CHARGING.get(), (Object)false);
            }
            if (off.getItem() instanceof CogwheelShieldItem) {
                off.set((DataComponentType)ModDataComponents.GEAR_SHIELD_CHARGING.get(), (Object)false);
            }
        }
        float mainSpeed = ((Float)main.getOrDefault((DataComponentType)ModDataComponents.GEAR_SHIELD_SPEED.get(), (Object)Float.valueOf(0.0f))).floatValue();
        float offSpeed = ((Float)off.getOrDefault((DataComponentType)ModDataComponents.GEAR_SHIELD_SPEED.get(), (Object)Float.valueOf(0.0f))).floatValue();
        boolean mainFull = main.getItem() instanceof CogwheelShieldItem && mainSpeed >= 256.0f;
        boolean bl = offFull = off.getItem() instanceof CogwheelShieldItem && offSpeed >= 256.0f;
        if (mainFull && offFull) {
            PacketDistributor.sendToServer((CustomPacketPayload)new ShieldFullSpeedPayload(), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
        wasDown = KeyBindings.ROTATE_COGWHEEL.isDown();
    }

    private static void handleShield(ItemStack stack, boolean isOffhand) {
        long now;
        Minecraft mc = Minecraft.getInstance();
        if (!(stack.getItem() instanceof CogwheelShieldItem)) {
            KeyInputHandler.resetNBT(stack);
            return;
        }
        AtomicReference<Float> boostFactor = new AtomicReference<Float>(Float.valueOf(1.0f));
        EnchantmentHelper.runIterationOnItem((ItemStack)stack, (enchantHolder, level) -> {
            PneumaticBoostEffect effect = (PneumaticBoostEffect)((Enchantment)enchantHolder.value()).effects().get((DataComponentType)ModEnchantmentComponents.PNEUMATIC_BOOST.get());
            if (effect != null) {
                boostFactor.set(effect.applyBoost(((Float)boostFactor.get()).floatValue(), level));
            }
        });
        float pneumaticBoost = boostFactor.get().floatValue();
        float accelerationFactor = pneumaticBoost * basicFactor;
        boolean isDown = KeyBindings.ROTATE_COGWHEEL.isDown();
        boolean oldCharging = (Boolean)stack.getOrDefault((DataComponentType)ModDataComponents.GEAR_SHIELD_CHARGING.get(), (Object)false);
        boolean oldDecaying = (Boolean)stack.getOrDefault((DataComponentType)ModDataComponents.GEAR_SHIELD_DECAYING.get(), (Object)false);
        float oldSpeed = ((Float)stack.getOrDefault((DataComponentType)ModDataComponents.GEAR_SHIELD_SPEED.get(), (Object)Float.valueOf(0.0f))).floatValue();
        long oldChargeStartMs = (Long)stack.getOrDefault((DataComponentType)ModDataComponents.GEAR_SHIELD_CHARGE_START.get(), (Object)0L);
        long oldLastDecayMs = (Long)stack.getOrDefault((DataComponentType)ModDataComponents.GEAR_SHIELD_LAST_DECAY.get(), (Object)0L);
        boolean isCharging = oldCharging;
        boolean isDecaying = oldDecaying;
        float speed = oldSpeed;
        long chargeStartMs = oldChargeStartMs;
        long lastDecayMs = oldLastDecayMs;
        if (speed > 0.0f && !isCharging && !isDecaying) {
            isDecaying = true;
            lastDecayMs = System.currentTimeMillis();
        }
        if (isDown && !wasDown) {
            isCharging = true;
            isDecaying = false;
            if (speed > 0.0f) {
                float equivalentSeconds = (float)(Math.log(Math.max(speed / 8.0f, 1.0f)) / Math.log(2.0)) + 1.0f;
                chargeStartMs = System.currentTimeMillis() - (long)(equivalentSeconds * 1000.0f);
            } else {
                chargeStartMs = System.currentTimeMillis();
            }
        }
        if (isDown && isCharging) {
            List backtanks;
            long now2 = System.currentTimeMillis();
            long elapsed = now2 - chargeStartMs;
            float seconds = (float)elapsed / 1000.0f;
            if (mc.player != null && !(backtanks = BacktankUtil.getAllWithAir((LivingEntity)mc.player)).isEmpty()) {
                int airCost = (int)((double)accelerationFactor / 0.25);
                float currentAir = BacktankUtil.getAir((ItemStack)((ItemStack)backtanks.get(0)));
                if (currentAir >= (float)airCost) {
                    if (now2 - lastAirConsumeTime >= 1000L) {
                        basicFactor = 1.5f;
                        BacktankUtil.consumeAir((LivingEntity)mc.player, (ItemStack)((ItemStack)backtanks.get(0)), (int)airCost);
                        lastAirConsumeTime = now2;
                    } else {
                        basicFactor = 1.0f;
                    }
                }
            }
            float f = speed = seconds >= 1.0f ? (float)Math.min(8.0 * Math.pow(1.75, (seconds - 1.0f) * accelerationFactor), 256.0) : 8.0f;
        }
        if (!isDown && wasDown) {
            isCharging = false;
            isDecaying = true;
            lastDecayMs = System.currentTimeMillis();
        }
        if (isDecaying && !isCharging && speed > 0.0f && (now = System.currentTimeMillis()) - lastDecayMs >= 750L) {
            lastDecayMs = now;
            if ((speed /= 1.8f) < 8.0f) {
                speed = 0.0f;
                isDecaying = false;
            }
        }
        if (!isCharging && !isDecaying && speed > 0.0f) {
            isCharging = false;
            isDecaying = true;
            lastDecayMs = System.currentTimeMillis();
        }
        if (Math.abs(speed - oldSpeed) > 0.01f) {
            stack.set((DataComponentType)ModDataComponents.GEAR_SHIELD_SPEED.get(), (Object)Float.valueOf(speed));
        }
        if (isCharging != oldCharging) {
            stack.set((DataComponentType)ModDataComponents.GEAR_SHIELD_CHARGING.get(), (Object)isCharging);
        }
        if (chargeStartMs != oldChargeStartMs) {
            stack.set((DataComponentType)ModDataComponents.GEAR_SHIELD_CHARGE_START.get(), (Object)chargeStartMs);
        }
        if (isDecaying != oldDecaying) {
            stack.set((DataComponentType)ModDataComponents.GEAR_SHIELD_DECAYING.get(), (Object)isDecaying);
        }
        if (lastDecayMs != oldLastDecayMs) {
            stack.set((DataComponentType)ModDataComponents.GEAR_SHIELD_LAST_DECAY.get(), (Object)lastDecayMs);
        }
        stack.set((DataComponentType)ModDataComponents.GEAR_SHIELD_SPEED.get(), (Object)Float.valueOf(speed));
        stack.set((DataComponentType)ModDataComponents.GEAR_SHIELD_CHARGING.get(), (Object)isCharging);
        stack.set((DataComponentType)ModDataComponents.GEAR_SHIELD_DECAYING.get(), (Object)isDecaying);
        stack.set((DataComponentType)ModDataComponents.GEAR_SHIELD_CHARGE_START.get(), (Object)chargeStartMs);
        stack.set((DataComponentType)ModDataComponents.GEAR_SHIELD_LAST_DECAY.get(), (Object)lastDecayMs);
    }

    private static void updateRotationAngle(ItemStack stack, boolean isOffhand) {
        float angle = ((Float)stack.getOrDefault((DataComponentType)ModDataComponents.GEAR_SHIELD_ANGLE.get(), (Object)Float.valueOf(0.0f))).floatValue();
        float speed = ((Float)stack.getOrDefault((DataComponentType)ModDataComponents.GEAR_SHIELD_SPEED.get(), (Object)Float.valueOf(0.0f))).floatValue();
        if (isOffhand) {
            if ((angle += speed / 20.0f) < 0.0f) {
                angle += 360.0f;
            }
        } else if ((angle -= speed / 20.0f) > 360.0f) {
            angle -= 360.0f;
        }
        stack.set((DataComponentType)ModDataComponents.GEAR_SHIELD_ANGLE.get(), (Object)Float.valueOf(angle));
    }

    public static void triggerThrowShield(ItemStack stack, float speed) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null || mc.level == null) {
            return;
        }
        stack.set((DataComponentType)ModDataComponents.GEAR_SHIELD_DECAYING.get(), (Object)true);
        PacketDistributor.sendToServer((CustomPacketPayload)new ShieldThrowPayload(speed, stack), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    static void resetNBT(ItemStack stack) {
        stack.set((DataComponentType)ModDataComponents.GEAR_SHIELD_SPEED.get(), (Object)Float.valueOf(0.0f));
        stack.set((DataComponentType)ModDataComponents.GEAR_SHIELD_CHARGING.get(), (Object)false);
        stack.set((DataComponentType)ModDataComponents.GEAR_SHIELD_CHARGE_START.get(), (Object)0L);
        stack.set((DataComponentType)ModDataComponents.GEAR_SHIELD_DECAYING.get(), (Object)true);
        stack.set((DataComponentType)ModDataComponents.GEAR_SHIELD_LAST_DECAY.get(), (Object)0L);
        stack.set((DataComponentType)ModDataComponents.GEAR_SHIELD_ANGLE.get(), (Object)Float.valueOf(0.0f));
    }
}

