/*
 * Decompiled with CFR 0.152.
 */
package com.erix.creatorsword.entity;

import com.erix.creatorsword.data.ModDataComponents;
import com.erix.creatorsword.entity.ModEntities;
import com.erix.creatorsword.item.cogwheel_shield.CogwheelShieldItems;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class ThrownCogwheelShield
extends ThrowableItemProjectile {
    private static final EntityDataAccessor<Float> SPEED = SynchedEntityData.defineId(ThrownCogwheelShield.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Boolean> RETURNING = SynchedEntityData.defineId(ThrownCogwheelShield.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<ItemStack> ITEM_STACK = SynchedEntityData.defineId(ThrownCogwheelShield.class, (EntityDataSerializer)EntityDataSerializers.ITEM_STACK);
    private static final float BASE_DAMAGE = 5.0f;
    private int lifetime = 0;
    private static final int MAX_LIFETIME = 100;
    private static final float RETURN_SPEED = 1.2f;
    private static final float PICKUP_DISTANCE = 1.2f;
    private ItemStack cachedItemStack;

    public ThrownCogwheelShield(EntityType<? extends ThrownCogwheelShield> type, Level level) {
        super(type, level);
    }

    public ThrownCogwheelShield(Level level, LivingEntity shooter, float speed, ItemStack stack) {
        super((EntityType)ModEntities.COGWHEEL_SHIELD_ENTITY.get(), shooter, level);
        this.getEntityData().set(SPEED, (Object)Float.valueOf(speed));
        this.getEntityData().set(RETURNING, (Object)false);
        this.getEntityData().set(ITEM_STACK, (Object)stack.copy());
    }

    protected void defineSynchedData(// Could not load outer class - annotation placement on inner may be incorrect
    @NotNull SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(SPEED, (Object)Float.valueOf(0.0f));
        builder.define(RETURNING, (Object)false);
        builder.define(ITEM_STACK, (Object)ItemStack.EMPTY);
    }

    @NotNull
    protected Item getDefaultItem() {
        return (Item)CogwheelShieldItems.COGWHEEL_SHIELD.get();
    }

    public ItemStack getItem() {
        if (this.cachedItemStack == null) {
            ItemStack stack = (ItemStack)this.getEntityData().get(ITEM_STACK);
            this.cachedItemStack = !stack.isEmpty() ? stack.copy() : new ItemStack((ItemLike)this.getDefaultItem());
        }
        return this.cachedItemStack;
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide()) {
            ++this.lifetime;
            float speed = ((Float)this.getEntityData().get(SPEED)).floatValue();
            boolean isReturning = (Boolean)this.getEntityData().get(RETURNING);
            Entity owner = this.getOwner();
            if (owner instanceof Player) {
                Player player = (Player)owner;
                Vec3 playerPos = player.position().add(0.0, (double)(player.getEyeHeight() / 2.0f), 0.0);
                Vec3 toPlayer = playerPos.subtract(this.position());
                double distanceToPlayer = toPlayer.length();
                if (isReturning || this.lifetime >= 100) {
                    this.getEntityData().set(RETURNING, (Object)true);
                    this.setDeltaMovement(toPlayer.normalize().scale((double)1.2f));
                    if (distanceToPlayer <= (double)1.2f) {
                        ItemStack stack = this.getItem();
                        if (stack.isEmpty()) {
                            this.discard();
                            return;
                        }
                        stack.set((DataComponentType)ModDataComponents.GEAR_SHIELD_SPEED.get(), (Object)Float.valueOf(speed));
                        stack.set((DataComponentType)ModDataComponents.GEAR_SHIELD_DECAYING.get(), (Object)true);
                        stack.set((DataComponentType)ModDataComponents.GEAR_SHIELD_LAST_DECAY.get(), (Object)System.currentTimeMillis());
                        stack.set((DataComponentType)ModDataComponents.GEAR_SHIELD_CHARGING.get(), (Object)false);
                        if (player.getItemInHand(InteractionHand.OFF_HAND).isEmpty()) {
                            player.setItemInHand(InteractionHand.OFF_HAND, stack);
                        } else if (!player.getInventory().add(stack)) {
                            player.drop(stack, false);
                        } else {
                            player.inventoryMenu.broadcastChanges();
                        }
                        this.discard();
                    }
                }
            }
            if (speed > 0.0f && this.lifetime % 15 == 0) {
                if ((speed /= 2.0f) < 8.0f) {
                    speed = 0.0f;
                }
                this.getEntityData().set(SPEED, (Object)Float.valueOf(speed));
            }
        }
    }

    protected void onHit(@NotNull HitResult result) {
        if (!this.level().isClientSide()) {
            EntityHitResult entityHit;
            Entity target;
            if (result.getType() == HitResult.Type.ENTITY && (target = (entityHit = (EntityHitResult)result).getEntity()) != this.getOwner()) {
                float speed = ((Float)this.getEntityData().get(SPEED)).floatValue();
                float damage = 5.0f * (speed / 256.0f);
                damage = Math.max(0.0f, Math.min(damage, 5.0f));
                target.hurt(this.damageSources().thrown((Entity)this, this.getOwner()), damage);
            }
            this.getEntityData().set(RETURNING, (Object)true);
        }
    }

    public float getRotationAngle() {
        float speed = ((Float)this.getEntityData().get(SPEED)).floatValue();
        return speed * (float)this.tickCount / 20.0f % 360.0f;
    }
}

