/*
 * Decompiled with CFR 0.152.
 */
package com.erix.creatorsword.item.cogwheel_shield;

import com.erix.creatorsword.data.ModDataComponents;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.simibubi.create.foundation.item.render.CustomRenderedItemModel;
import com.simibubi.create.foundation.item.render.CustomRenderedItemModelRenderer;
import com.simibubi.create.foundation.item.render.PartialItemModelRenderer;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;

public class CogwheelShieldItemRenderer
extends CustomRenderedItemModelRenderer {
    private static final PartialModel HANDLE = PartialModel.of((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"creatorsword", (String)"item/cogwheel_shield/handle"));
    private static final PartialModel ROTATING_GEAR = PartialModel.of((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"creatorsword", (String)"item/cogwheel_shield/cogwheel_shield_handless"));

    protected void render(ItemStack stack, CustomRenderedItemModel model, PartialItemModelRenderer renderer, ItemDisplayContext transformType, PoseStack ms, MultiBufferSource buffer, int light, int overlay) {
        ms.pushPose();
        switch (transformType) {
            case THIRD_PERSON_RIGHT_HAND: {
                ms.mulPose(Axis.YP.rotationDegrees(90.0f));
                ms.translate(-0.0625f, 0.125f, 0.0625f);
                ms.scale(0.6f, 0.6f, 0.6f);
                break;
            }
            case THIRD_PERSON_LEFT_HAND: {
                ms.mulPose(Axis.YP.rotationDegrees(90.0f));
                ms.translate(-0.0625f, 0.125f, -0.0625f);
                ms.scale(0.6f, 0.6f, 0.6f);
                break;
            }
            case FIRST_PERSON_RIGHT_HAND: {
                boolean blocking = false;
                if (Minecraft.getInstance().player != null) {
                    boolean bl = blocking = Minecraft.getInstance().player.isUsingItem() && Minecraft.getInstance().player.getUseItem() == stack;
                }
                if (blocking) {
                    ms.mulPose(Axis.XP.rotationDegrees(275.0f));
                    ms.mulPose(Axis.YP.rotationDegrees(90.0f));
                    ms.translate(0.5f, 0.25f, 0.25f);
                    ms.scale(0.9f, 0.25f, 0.9f);
                    break;
                }
                ms.mulPose(Axis.XP.rotationDegrees(280.0f));
                ms.mulPose(Axis.YP.rotationDegrees(90.0f));
                ms.translate(0.5f, 0.15625f, 0.3125f);
                ms.scale(0.9f, 0.25f, 0.9f);
                break;
            }
            case FIRST_PERSON_LEFT_HAND: {
                boolean blocking = false;
                if (Minecraft.getInstance().player != null) {
                    boolean bl = blocking = Minecraft.getInstance().player.isUsingItem() && Minecraft.getInstance().player.getUseItem() == stack;
                }
                if (blocking) {
                    ms.mulPose(Axis.XP.rotationDegrees(275.0f));
                    ms.mulPose(Axis.YP.rotationDegrees(90.0f));
                    ms.translate(0.5f, 0.25f, -0.25f);
                    ms.scale(0.9f, 0.25f, 0.9f);
                    break;
                }
                ms.mulPose(Axis.XP.rotationDegrees(280.0f));
                ms.mulPose(Axis.YP.rotationDegrees(90.0f));
                ms.translate(0.5f, 0.15625f, -0.3125f);
                ms.scale(0.9f, 0.25f, 0.9f);
                break;
            }
            case GROUND: {
                ms.mulPose(Axis.XP.rotationDegrees(-180.0f));
                ms.mulPose(Axis.ZP.rotationDegrees(10.0f));
                ms.scale(0.5f, 0.5f, 0.5f);
                break;
            }
            case GUI: {
                ms.mulPose(Axis.XP.rotationDegrees(76.0f));
                ms.mulPose(Axis.ZP.rotationDegrees(29.0f));
                ms.scale(0.5f, 0.5f, 0.5f);
                break;
            }
            case HEAD: {
                ms.translate(0.0f, 0.359375f, 0.0f);
                ms.scale(0.75f, 0.75f, 0.75f);
                break;
            }
            case FIXED: {
                ms.mulPose(Axis.XP.rotationDegrees(-90.0f));
                ms.scale(0.7f, 0.7f, 0.7f);
                break;
            }
        }
        renderer.render(HANDLE.get(), light);
        float rotationAngle = ((Float)stack.getOrDefault((DataComponentType)ModDataComponents.GEAR_SHIELD_ANGLE.get(), (Object)Float.valueOf(0.0f))).floatValue();
        ms.pushPose();
        ms.mulPose(Axis.YP.rotationDegrees(rotationAngle));
        renderer.render(ROTATING_GEAR.get(), light);
        ms.popPose();
        ms.popPose();
    }
}

