/*
 * Decompiled with CFR 0.152.
 */
package com.erix.creatorsword.item.cogwheel_shield;

import com.erix.creatorsword.data.ModDataComponents;
import com.erix.creatorsword.datagen.enchantments.EnchantmentKeys;
import com.erix.creatorsword.item.cogwheel_shield.CogwheelShieldItemRenderer;
import com.simibubi.create.content.equipment.armor.BacktankUtil;
import com.simibubi.create.foundation.item.render.CustomRenderedItemModelRenderer;
import com.simibubi.create.foundation.item.render.SimpleCustomRenderer;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;

public class CogwheelShieldItem
extends ShieldItem {
    private static final float MIN_SPEED = 8.0f;
    private static final float DECAY_RATE = 0.95f;
    private static final int UPDATE_INTERVAL_TICKS = 2;
    private static final int AIR_CONSUME_INTERVAL_TICKS = 20;
    private static final float NORMAL_MAX_SPEED = 256.0f;
    private static final float OVERDRIVE_MAX_SPEED = 512.0f;

    public CogwheelShieldItem(Item.Properties properties) {
        super(new Item.Properties().stacksTo(1).durability(336));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept((IClientItemExtensions)SimpleCustomRenderer.create((Item)this, (CustomRenderedItemModelRenderer)new CogwheelShieldItemRenderer()));
    }

    public boolean isEnchantable(ItemStack stack) {
        return true;
    }

    public int getEnchantmentValue() {
        return 20;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void tickClient(ItemStack stack, Player player, boolean keyDown) {
        long lastUpdateTick;
        long currentTick = player.level().getGameTime();
        if (currentTick - (lastUpdateTick = ((Long)stack.getOrDefault((DataComponentType)ModDataComponents.GEAR_SHIELD_LAST_UPDATE.get(), (Object)0L)).longValue()) < 2L) {
            return;
        }
        stack.set((DataComponentType)ModDataComponents.GEAR_SHIELD_LAST_UPDATE.get(), (Object)currentTick);
        float speed = this.getSpeed(stack);
        boolean charging = (Boolean)stack.getOrDefault((DataComponentType)ModDataComponents.GEAR_SHIELD_CHARGING.get(), (Object)false);
        boolean decaying = (Boolean)stack.getOrDefault((DataComponentType)ModDataComponents.GEAR_SHIELD_DECAYING.get(), (Object)false);
        float accelFactor = this.getAccelerationFactor(stack, player);
        if (keyDown) {
            if (!charging) {
                charging = true;
                decaying = false;
            }
            float airBoost = this.consumeAirIfNeeded(stack, player, accelFactor, currentTick);
            float nextSpeed = speed * accelFactor * airBoost;
            speed = Math.min(Math.max(nextSpeed, 8.0f), this.getMaxSpeed(stack, player));
        } else {
            if (charging) {
                charging = false;
                decaying = true;
            }
            if (decaying && (speed *= 0.95f) < 1.0f) {
                speed = 0.0f;
                decaying = false;
            }
        }
        this.setSpeed(stack, speed);
        stack.set((DataComponentType)ModDataComponents.GEAR_SHIELD_CHARGING.get(), (Object)charging);
        stack.set((DataComponentType)ModDataComponents.GEAR_SHIELD_DECAYING.get(), (Object)decaying);
    }

    public float getSpeed(ItemStack stack) {
        return ((Float)stack.getOrDefault((DataComponentType)ModDataComponents.GEAR_SHIELD_SPEED.get(), (Object)Float.valueOf(0.0f))).floatValue();
    }

    public void setSpeed(ItemStack stack, float speed) {
        stack.set((DataComponentType)ModDataComponents.GEAR_SHIELD_SPEED.get(), (Object)Float.valueOf(speed));
    }

    private float consumeAirIfNeeded(ItemStack stack, Player player, float accelFactor, long tick) {
        long lastConsumeTick = (Long)stack.getOrDefault((DataComponentType)ModDataComponents.GEAR_SHIELD_LAST_AIR_TICK.get(), (Object)0L);
        if (tick - lastConsumeTick < 20L) {
            return 1.0f;
        }
        stack.set((DataComponentType)ModDataComponents.GEAR_SHIELD_LAST_AIR_TICK.get(), (Object)tick);
        List tanks = BacktankUtil.getAllWithAir((LivingEntity)player);
        if (tanks.isEmpty()) {
            return 1.0f;
        }
        int airCost = (int)(accelFactor * 2.0f);
        if (BacktankUtil.getAir((ItemStack)((ItemStack)tanks.get(0))) < airCost) {
            return 1.0f;
        }
        BacktankUtil.consumeAir((LivingEntity)player, (ItemStack)((ItemStack)tanks.get(0)), (int)airCost);
        return 1.1f;
    }

    private float getAccelerationFactor(ItemStack stack, Player player) {
        Registry registry = player.level().registryAccess().registryOrThrow(Registries.ENCHANTMENT);
        Holder holder = (Holder)registry.getHolder(EnchantmentKeys.PNEUMATIC_BOOST).orElseThrow(() -> new IllegalStateException("Enchantment not found: " + String.valueOf(EnchantmentKeys.PNEUMATIC_BOOST)));
        int enchantLevel = EnchantmentHelper.getItemEnchantmentLevel((Holder)holder, (ItemStack)stack);
        return (float)(1.1 + (double)(0.05f * (float)enchantLevel));
    }

    public static void resetNBT(ItemStack stack) {
        stack.set((DataComponentType)ModDataComponents.GEAR_SHIELD_SPEED.get(), (Object)Float.valueOf(0.0f));
        stack.set((DataComponentType)ModDataComponents.GEAR_SHIELD_CHARGING.get(), (Object)false);
        stack.set((DataComponentType)ModDataComponents.GEAR_SHIELD_LAST_UPDATE.get(), (Object)0L);
        stack.set((DataComponentType)ModDataComponents.GEAR_SHIELD_DECAYING.get(), (Object)true);
        stack.set((DataComponentType)ModDataComponents.GEAR_SHIELD_LAST_AIR_TICK.get(), (Object)0L);
        stack.set((DataComponentType)ModDataComponents.GEAR_SHIELD_ANGLE.get(), (Object)Float.valueOf(0.0f));
    }

    private float getMaxSpeed(ItemStack stack, Player player) {
        Registry registry = player.level().registryAccess().registryOrThrow(Registries.ENCHANTMENT);
        Holder holder = (Holder)registry.getHolder(EnchantmentKeys.OVERDRIVE).orElseThrow(() -> new IllegalStateException("Enchantment not found: " + String.valueOf(EnchantmentKeys.OVERDRIVE)));
        int overdriveLevel = EnchantmentHelper.getItemEnchantmentLevel((Holder)holder, (ItemStack)stack);
        return overdriveLevel > 0 ? 512.0f : 256.0f;
    }
}

