/*
 * Decompiled with CFR 0.152.
 */
package net.fg83.thoroughfabric;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import net.fg83.thoroughfabric.TFConfig;

public class ConfigManager {
    private static final String CONFIG_FILE_NAME = "thoroughfabric.json";
    private static final Path CONFIG_FILE_PATH = Paths.get("config", "thoroughfabric.json");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static TFConfig config;

    public static TFConfig getConfig() {
        if (config == null) {
            ConfigManager.loadConfig();
        }
        return config;
    }

    public static void loadConfig() {
        block9: {
            File directory = CONFIG_FILE_PATH.getParent().toFile();
            if (!directory.exists()) {
                directory.mkdirs();
            }
            if (Files.exists(CONFIG_FILE_PATH, new LinkOption[0])) {
                try (FileReader reader = new FileReader(CONFIG_FILE_PATH.toFile());){
                    config = (TFConfig)GSON.fromJson((Reader)reader, TFConfig.class);
                    break block9;
                }
                catch (IOException e) {
                    throw new RuntimeException("Could not read config file", e);
                }
            }
            config = new TFConfig();
            ConfigManager.saveConfig();
        }
    }

    public static void saveConfig() {
        try (FileWriter writer = new FileWriter(CONFIG_FILE_PATH.toFile());){
            GSON.toJson((Object)config, (Appendable)writer);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not save config file", e);
        }
    }
}

