/*
 * Decompiled with CFR 0.152.
 */
package net.fg83.thoroughfabric;

import java.util.List;
import java.util.Map;
import java.util.function.Function;
import net.fg83.thoroughfabric.ConfigManager;
import net.fg83.thoroughfabric.StepCountData;
import net.fg83.thoroughfabric.TFConfig;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2482;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2771;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public class TFUtils {
    private static final int DEFAULT_MULTIPLIER = 1;
    private static final Map<class_1299, Function<TFConfig, Integer>> MULTIPLIER_MAP = TFUtils.initializeMultiplierMap();
    public static List<class_1299> rideableEntities = List.of(class_1299.field_6139, class_1299.field_6075, class_1299.field_40116, class_1299.field_6057, class_1299.field_6093, class_1299.field_6067, class_1299.field_6048, class_1299.field_6074, class_1299.field_17714, class_1299.field_23214);
    public static List<class_2248> affectedBlocks = List.of(class_2246.field_10219, class_2246.field_10566, class_2246.field_10402, class_2246.field_10520, class_2246.field_10253, class_2246.field_10194);
    private static final Map<class_2248, Function<TFConfig, Integer>> BLOCK_CONFIG_MAP = Map.of(class_2246.field_10219, config -> config.grassReps, class_2246.field_10566, config -> config.grassReps, class_2246.field_10402, config -> config.grassReps, class_2246.field_10520, config -> config.grassReps, class_2246.field_10253, config -> config.coarseDirtReps);

    private static Map<class_1299, Function<TFConfig, Integer>> initializeMultiplierMap() {
        return Map.of(class_1299.field_6139, config -> config.horseMulti, class_1299.field_6048, config -> config.horseMulti, class_1299.field_6075, config -> config.horseMulti, class_1299.field_6074, config -> config.llamaMulti, class_1299.field_17714, config -> config.llamaMulti, class_1299.field_6057, config -> config.muleMulti, class_1299.field_40116, config -> config.camelMulti, class_1299.field_6067, config -> config.donkeyMulti, class_1299.field_6093, config -> config.pigMulti, class_1299.field_23214, config -> config.striderMulti);
    }

    public static class_3222 getPlayerFromEntity(class_1297 entity) {
        class_1297 firstPassenger;
        if (entity instanceof class_3222) {
            return (class_3222)entity;
        }
        if (rideableEntities.contains(entity.method_5864()) && entity.method_5782() && (firstPassenger = entity.method_31483()) instanceof class_3222) {
            return (class_3222)firstPassenger;
        }
        return null;
    }

    public static int calculateStepWeight(class_1297 entity) {
        if (!(entity instanceof class_3222)) {
            return TFUtils.getMultiplier(entity);
        }
        return 1;
    }

    public static int getMultiplier(class_1297 entity) {
        TFConfig config = ConfigManager.getConfig();
        return MULTIPLIER_MAP.getOrDefault(entity.method_5864(), c -> 1).apply(config);
    }

    public static int getMaxSteps(class_2248 block) {
        TFConfig config = ConfigManager.getConfig();
        if (BLOCK_CONFIG_MAP.containsKey(block)) {
            return BLOCK_CONFIG_MAP.get(block).apply(config);
        }
        if (TFUtils.testPathWear(block, config)) {
            return config.pathReps;
        }
        return -1;
    }

    private static boolean testPathWear(class_2248 block, TFConfig config) {
        return block == class_2246.field_10194 && config.pathsWear;
    }

    private static boolean isGrassRelated(class_2680 state) {
        return state.method_27852(class_2246.field_10219) || state.method_27852(class_2246.field_10566) || state.method_27852(class_2246.field_10402) || state.method_27852(class_2246.field_10520);
    }

    private static class_2680 determineNewState(class_2680 currentState) {
        if (TFUtils.isGrassRelated(currentState)) {
            return class_2246.field_10253.method_9564();
        }
        if (currentState.method_27852(class_2246.field_10253)) {
            return class_2246.field_10194.method_9564();
        }
        if (currentState.method_27852(class_2246.field_10194)) {
            return (class_2680)class_2246.field_10351.method_9564().method_11657((class_2769)class_2482.field_11501, (Comparable)class_2771.field_12681);
        }
        return currentState;
    }

    public static boolean checkBlockUpdate(class_1937 world, class_2338 pos, class_2680 state) {
        StepCountData stepCountData = StepCountData.get((class_3218)world);
        int maxSteps = TFUtils.getMaxSteps(state.method_26204());
        return maxSteps != -1 && stepCountData.getStepCount(pos) >= maxSteps;
    }

    public static void doBlockUpdate(class_1937 world, class_2338 pos) {
        int chance;
        class_2680 currentState = world.method_8320(pos);
        class_2680 newState = TFUtils.determineNewState(currentState);
        if (newState != currentState && (chance = (int)(Math.random() * 5.0)) == 0) {
            world.method_8501(pos, newState);
            StepCountData stepCountData = StepCountData.get((class_3218)world);
            stepCountData.resetStepCount(pos);
        }
    }
}

