/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.bettertrims.client.tooltip.component;

import com.bawnorton.bettertrims.client.tooltip.component.DynamicWidthComponent;
import java.util.function.Supplier;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.MultiBufferSource;
import org.joml.Matrix4f;

public record ConditionalComponent(ClientTooltipComponent ifTrue, ClientTooltipComponent ifFalse, Supplier<Boolean> checker) implements DynamicWidthComponent
{
    public int getHeight() {
        return this.checker.get() != false ? this.ifTrue.getHeight() : this.ifFalse.getHeight();
    }

    public int getWidth(Font font) {
        return this.checker.get() != false ? this.ifTrue.getWidth(font) : this.ifFalse.getWidth(font);
    }

    public void renderImage(Font font, int x, int y, GuiGraphics guiGraphics) {
        if (this.checker.get().booleanValue()) {
            this.ifTrue.renderImage(font, x, y, guiGraphics);
        } else {
            this.ifFalse.renderImage(font, x, y, guiGraphics);
        }
    }

    public void renderText(Font font, int mouseX, int mouseY, Matrix4f matrix, MultiBufferSource.BufferSource bufferSource) {
        if (this.checker.get().booleanValue()) {
            this.ifTrue.renderText(font, mouseX, mouseY, matrix, bufferSource);
        } else {
            this.ifFalse.renderText(font, mouseX, mouseY, matrix, bufferSource);
        }
    }

    @Override
    public int getMaxWidth(Font font) {
        int maxWidth = 0;
        ClientTooltipComponent clientTooltipComponent = this.ifTrue;
        if (clientTooltipComponent instanceof DynamicWidthComponent) {
            DynamicWidthComponent dynamic = (DynamicWidthComponent)clientTooltipComponent;
            maxWidth = Math.max(maxWidth, dynamic.getMaxWidth(font));
        } else {
            maxWidth = Math.max(maxWidth, this.ifTrue.getWidth(font));
        }
        return maxWidth;
    }

    @Override
    public int getMinWidth(Font font) {
        int minWidth = Integer.MAX_VALUE;
        ClientTooltipComponent clientTooltipComponent = this.ifTrue;
        if (clientTooltipComponent instanceof DynamicWidthComponent) {
            DynamicWidthComponent dynamic = (DynamicWidthComponent)clientTooltipComponent;
            minWidth = Math.min(minWidth, dynamic.getMinWidth(font));
        } else {
            minWidth = Math.min(minWidth, this.ifTrue.getWidth(font));
        }
        return minWidth;
    }
}

