/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.bettertrims.client.tooltip.component;

import java.util.List;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.MultiBufferSource;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

public record StackedComponent(List<? extends ClientTooltipComponent> components, int offset) implements ClientTooltipComponent
{
    public StackedComponent(List<? extends ClientTooltipComponent> components, int offset) {
        this.components = components.reversed();
        this.offset = offset;
    }

    public int getHeight() {
        return 16;
    }

    public int getWidth(Font font) {
        return Math.max(16, 16 - this.offset + this.offset * this.components.size());
    }

    public void renderImage(Font font, int x, int y, GuiGraphics guiGraphics) {
        if (this.components.isEmpty()) {
            return;
        }
        int currentOffset = this.components.size() - 1;
        for (ClientTooltipComponent clientTooltipComponent : this.components) {
            clientTooltipComponent.renderImage(font, x + this.offset * currentOffset, y, guiGraphics);
            --currentOffset;
        }
    }

    public void renderText(Font font, int mouseX, int mouseY, Matrix4f matrix, MultiBufferSource.BufferSource bufferSource) {
        if (this.components.isEmpty()) {
            return;
        }
        int currentOffset = this.components.size() - 1;
        for (ClientTooltipComponent clientTooltipComponent : this.components) {
            clientTooltipComponent.renderText(font, mouseX + this.offset * currentOffset, mouseY, matrix, bufferSource);
            --currentOffset;
        }
    }

    @Override
    @NotNull
    public String toString() {
        return "StackedComponent{%s}".formatted(this.components);
    }
}

