/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.bettertrims.client.tooltip.condition.predicate;

import com.bawnorton.bettertrims.client.tooltip.component.CompositeBuilder;
import com.bawnorton.bettertrims.client.tooltip.component.CompositeContainerComponent;
import com.bawnorton.bettertrims.client.tooltip.condition.LootConditionTooltips;
import com.bawnorton.bettertrims.client.tooltip.condition.predicate.PredicateTooltip;
import com.bawnorton.bettertrims.client.tooltip.condition.predicate.data.ExactDataComponentPredicateTooltipAdders;
import com.bawnorton.bettertrims.client.tooltip.condition.predicate.data.PartialDataComponentPredicateTooltipAdders;
import com.bawnorton.bettertrims.client.tooltip.util.Styler;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.ItemSubPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.HolderSet;
import net.minecraft.core.component.DataComponentPredicate;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;

public interface ItemPredicateTooltip {
    public static void addToBuilder(ClientLevel level, ItemPredicate predicate, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
        MinMaxBounds.Ints count;
        Map subPredicates;
        DataComponentPredicate components;
        Optional items = predicate.items();
        if (items.isPresent()) {
            ItemPredicateTooltip.addItemsToBuilder(level, (HolderSet<Item>)((HolderSet)items.orElseThrow()), state, builder);
            state = state.withUseWith(true);
        }
        if (!(components = predicate.components()).asPatch().isEmpty()) {
            ItemPredicateTooltip.addDataComponentMatchersToBuilder(level, components, state, builder);
        }
        if (!(subPredicates = predicate.subPredicates()).isEmpty()) {
            ItemPredicateTooltip.addSubPredicatesToBuilder(level, subPredicates, state, builder);
        }
        if (!(count = predicate.count()).isAny()) {
            ItemPredicateTooltip.addCountToBuilder(level, count, state, builder);
        }
    }

    public static String key(String key) {
        return PredicateTooltip.key("item.%s".formatted(key));
    }

    public static void addItemsToBuilder(ClientLevel level, HolderSet<Item> items, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
        PredicateTooltip.addRegisteredElementsToBuilder(level, ItemPredicateTooltip.key("matches"), Registries.ITEM, items, item -> item.getName(item.getDefaultInstance()), state, builder);
    }

    public static void addDataComponentMatchersToBuilder(ClientLevel level, DataComponentPredicate predicate, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
        if (state.doPrefixSpace()) {
            builder.space();
        }
        builder.translate(ItemPredicateTooltip.key("data"), Styler::condition, new Object[0]);
        Set entries = predicate.asPatch().entrySet();
        if (entries.isEmpty()) {
            builder.translate(ItemPredicateTooltip.key("data.exact.any"), Styler::condition, new Object[0]);
        } else if (entries.size() == 1) {
            Map.Entry entry = (Map.Entry)entries.iterator().next();
            Optional value = (Optional)entry.getValue();
            if (value.isEmpty()) {
                ResourceLocation key = BuiltInRegistries.DATA_COMPONENT_TYPE.getKey((Object)((DataComponentType)entry.getKey()));
                if (key != null) {
                    builder.translate(ItemPredicateTooltip.key("data.exact.any_for_type"), Styler::condition, new Object[]{Styler.property(Component.literal((String)key.toString()))});
                } else {
                    builder.translate(ItemPredicateTooltip.key("data.unknown"), Styler::condition, new Object[0]);
                }
                return;
            }
            ExactDataComponentPredicateTooltipAdders.addToBuilder(level, (DataComponentType)entry.getKey(), ((Optional)entry.getValue()).orElseThrow(), state, builder);
        } else {
            CompositeBuilder listBuilder = CompositeContainerComponent.builder().vertical().literal(":", Styler::condition);
            for (Map.Entry entry : entries) {
                Optional value = (Optional)entry.getValue();
                CompositeBuilder termBuilder = CompositeContainerComponent.builder().space().literal("\u2022 ", Styler::condition);
                if (value.isEmpty()) {
                    ResourceLocation key = BuiltInRegistries.DATA_COMPONENT_TYPE.getKey((Object)((DataComponentType)entry.getKey()));
                    if (key != null) {
                        ((CompositeContainerComponent.Builder)termBuilder).translate(ItemPredicateTooltip.key("data.exact.any_for_type"), Styler::condition, new Object[]{Styler.property(Component.literal((String)key.toString()))});
                    } else {
                        ((CompositeContainerComponent.Builder)termBuilder).translate(ItemPredicateTooltip.key("data.unknown"), Styler::condition, new Object[0]);
                    }
                } else {
                    ExactDataComponentPredicateTooltipAdders.addToBuilder(level, (DataComponentType)entry.getKey(), ((Optional)entry.getValue()).orElse(null), state, (CompositeContainerComponent.Builder)termBuilder);
                }
                ((CompositeContainerComponent.Builder)listBuilder).component(((CompositeContainerComponent.Builder)termBuilder).build());
            }
            builder.component(((CompositeContainerComponent.Builder)listBuilder).build());
        }
    }

    public static void addSubPredicatesToBuilder(ClientLevel level, Map<ItemSubPredicate.Type<?>, ItemSubPredicate> subPredicates, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
        if (state.doPrefixSpace()) {
            builder.space();
        }
        builder.translate(ItemPredicateTooltip.key("data.partial"), Styler::condition, new Object[0]);
        if (subPredicates.isEmpty()) {
            builder.translate(ItemPredicateTooltip.key("data.unknown"), new Object[0]);
        } else if (subPredicates.size() == 1) {
            Map.Entry<ItemSubPredicate.Type<?>, ItemSubPredicate> entry = subPredicates.entrySet().iterator().next();
            PartialDataComponentPredicateTooltipAdders.addToBuilder(level, entry.getKey(), entry.getValue(), state, builder);
        } else {
            CompositeBuilder listBuilder = CompositeContainerComponent.builder().vertical().literal(":", Styler::condition);
            for (Map.Entry<ItemSubPredicate.Type<?>, ItemSubPredicate> entry : subPredicates.entrySet()) {
                CompositeBuilder termBuilder = CompositeContainerComponent.builder().space().literal("\u2022 ", Styler::condition);
                PartialDataComponentPredicateTooltipAdders.addToBuilder(level, entry.getKey(), entry.getValue(), state, builder);
                ((CompositeContainerComponent.Builder)listBuilder).component(((CompositeContainerComponent.Builder)termBuilder).build());
            }
            builder.component(((CompositeContainerComponent.Builder)listBuilder).build());
        }
    }

    public static void addCountToBuilder(ClientLevel level, MinMaxBounds.Ints count, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
        CompositeContainerComponent.Builder countBuilder = CompositeContainerComponent.builder().space();
        PredicateTooltip.addMinMaxToBuilder(ItemPredicateTooltip.key("count"), false, count, state, countBuilder);
        builder.component(countBuilder.build());
    }
}

