/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.bettertrims.client.tooltip.condition.predicate.data.partial;

import com.bawnorton.bettertrims.client.tooltip.component.CompositeContainerComponent;
import com.bawnorton.bettertrims.client.tooltip.condition.LootConditionTooltips;
import com.bawnorton.bettertrims.client.tooltip.condition.predicate.PredicateTooltip;
import com.bawnorton.bettertrims.client.tooltip.condition.predicate.data.partial.PartialAdder;
import com.bawnorton.bettertrims.client.tooltip.util.Styler;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.advancements.critereon.CollectionPredicate;
import net.minecraft.advancements.critereon.ItemAttributeModifiersPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import org.apache.commons.lang3.StringUtils;

public final class AttributeModifiersPartialAdder
implements PartialAdder<ItemAttributeModifiersPredicate> {
    @Override
    public void addToBuilder(ClientLevel level, ItemAttributeModifiersPredicate predicate, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
        Optional modifiers = predicate.modifiers();
        if (modifiers.isPresent()) {
            this.addCollectionToBuilder(level, (CollectionPredicate)modifiers.orElseThrow(), "attribute_modifiers", (predicateLevel, entryPredicate, predicateState, collectionBuilder) -> {
                Optional id = entryPredicate.id();
                Optional attributeSet = entryPredicate.attribute();
                Optional slot = entryPredicate.slot();
                Optional operation = entryPredicate.operation();
                MinMaxBounds.Doubles amount = entryPredicate.amount();
                if (attributeSet.isPresent()) {
                    PredicateTooltip.addRegisteredElementsToBuilder(level, this.key("attribute_modifiers.attribute"), Registries.ATTRIBUTE, (HolderSet)attributeSet.orElseThrow(), (attribute, appender) -> {
                        if (operation.isPresent() && !amount.isAny()) {
                            CompositeContainerComponent.Builder detailBuilder = CompositeContainerComponent.builder();
                            PredicateTooltip.addMinMaxToBuilder(this.key("attribute_modifiers.amount.%s".formatted(((AttributeModifier.Operation)operation.orElseThrow()).id())), false, amount, value -> Component.literal((String)((value > 0.0 ? "+" : "-") + ItemAttributeModifiers.ATTRIBUTE_MODIFIER_FORMAT.format(value))), predicateState, detailBuilder);
                            appender.component(detailBuilder.build()).space().textComponent((Component)Styler.positive(Component.translatable((String)attribute.getDescriptionId())));
                            return Component.literal((String)"");
                        }
                        return Component.literal((String)"").append((Component)Styler.positive(Component.translatable((String)attribute.getDescriptionId())));
                    }, predicateState.withPrefixSpace(false), collectionBuilder);
                    predicateState.withPrefixSpace(true);
                }
                if (id.isPresent()) {
                    collectionBuilder.space().translate(this.key("attribute_modifiers.id"), Styler::condition, new Object[]{Styler.value(Component.literal((String)((ResourceLocation)id.orElseThrow()).toString()))});
                }
                if (slot.isPresent()) {
                    List<EquipmentSlot> slots = Arrays.stream(EquipmentSlot.values()).filter(arg_0 -> ((EquipmentSlotGroup)((EquipmentSlotGroup)slot.orElseThrow())).test(arg_0)).toList();
                    if (!slots.isEmpty()) {
                        PredicateTooltip.addEnumListToBuilder(this.key("attribute_modifiers.slot"), slots, s -> Component.translatable((String)StringUtils.capitalize((String)s.getName())), predicateState, collectionBuilder);
                    }
                }
            }, state, builder);
        } else {
            builder.space().translate(this.key("attribute_modifiers.any"), Styler::condition, new Object[0]);
        }
    }
}

