/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.bettertrims.client.tooltip.condition.predicate.data.partial;

import com.bawnorton.bettertrims.client.mixin.accessor.ItemsEnchantmentsPredicateAccessor;
import com.bawnorton.bettertrims.client.tooltip.component.CompositeContainerComponent;
import com.bawnorton.bettertrims.client.tooltip.condition.LootConditionTooltips;
import com.bawnorton.bettertrims.client.tooltip.condition.predicate.PredicateTooltip;
import com.bawnorton.bettertrims.client.tooltip.condition.predicate.data.partial.PartialAdder;
import com.bawnorton.bettertrims.client.tooltip.util.Styler;
import java.util.List;
import java.util.Optional;
import net.minecraft.advancements.critereon.EnchantmentPredicate;
import net.minecraft.advancements.critereon.ItemEnchantmentsPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;

public final class EnchantmentsPredicatePartialAdder<T extends ItemEnchantmentsPredicate>
implements PartialAdder<T> {
    @Override
    public void addToBuilder(ClientLevel level, T predicate, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
        ItemsEnchantmentsPredicateAccessor enchantmentsPredicate = (ItemsEnchantmentsPredicateAccessor)predicate;
        List<EnchantmentPredicate> enchantmentPredicates = enchantmentsPredicate.bettertrims$enchantments();
        if (enchantmentPredicates.isEmpty()) {
            builder.translate(this.key("enchantments.any"), Styler::condition, new Object[0]);
            return;
        }
        boolean useAnd = false;
        for (EnchantmentPredicate enchantmentPredicate : enchantmentPredicates) {
            Optional enchantments = enchantmentPredicate.enchantments();
            MinMaxBounds.Ints enchLevel = enchantmentPredicate.level();
            CompositeContainerComponent.Builder enchBuilder = CompositeContainerComponent.builder();
            if (enchantments.isPresent()) {
                HolderSet enchantmentHolderSet = (HolderSet)enchantments.orElseThrow();
                PredicateTooltip.addRegisteredElementsToBuilder(level, useAnd ? "bettertrims.tooltip.and" : (enchantmentHolderSet.size() == 1 ? this.key("enchantments.matches") : this.key("enchantments.matches_multiple")), Registries.ENCHANTMENT, enchantmentHolderSet, (enchantment, appender) -> {
                    if (!enchLevel.isAny()) {
                        appender.space();
                        PredicateTooltip.addMinMaxToBuilder(this.key("enchantments.level"), false, enchLevel, value -> Component.translatable((String)"enchantment.level.%s".formatted("%.0f".formatted(value))), state, appender);
                    }
                    return enchantment.description();
                }, state, enchBuilder);
                useAnd = true;
            } else {
                ((CompositeContainerComponent.Builder)enchBuilder.space().translate(this.key("enchantments.any"), Styler::condition, new Object[0])).space();
                if (!enchLevel.isAny()) {
                    PredicateTooltip.addMinMaxToBuilder(this.key("enchantments.level"), false, enchLevel, value -> Component.translatable((String)"enchantment.level.%s".formatted("%.0f".formatted(value))), state, enchBuilder);
                }
            }
            builder.component(enchBuilder.build());
        }
    }
}

