/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.bettertrims.mixin;

import com.bawnorton.bettertrims.mixin.EntityMixin;
import com.bawnorton.bettertrims.registry.BetterTrimsAttributes;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={LivingEntity.class})
abstract class LivingEntityMixin
extends EntityMixin {
    @Shadow
    @Final
    private AttributeMap attributes;

    LivingEntityMixin() {
    }

    @ModifyReturnValue(method={"createLivingAttributes"}, at={@At(value="RETURN")})
    private static AttributeSupplier.Builder addAttributes(AttributeSupplier.Builder original) {
        return original.add(BetterTrimsAttributes.TRUE_INVISIBILITY);
    }

    @Override
    protected boolean isTrulyInvisible(Operation<Boolean> original) {
        return super.isTrulyInvisible(original) || this.attributes.getValue(BetterTrimsAttributes.TRUE_INVISIBILITY) >= 1.0;
    }

    @ModifyReturnValue(method={"getVisibilityPercent"}, at={@At(value="RETURN")})
    private double applyTrueInvisibility(double original) {
        double value = this.attributes.getValue(BetterTrimsAttributes.TRUE_INVISIBILITY);
        if (value < 1.0) {
            return original;
        }
        return Math.max(0.1, original * 0.1);
    }
}

