/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.bettertrims.mixin.property.ability.discount_trades;

import com.bawnorton.bettertrims.property.TrimProperties;
import com.bawnorton.bettertrims.property.TrimProperty;
import com.bawnorton.bettertrims.property.ability.TrimAbilityComponents;
import com.bawnorton.bettertrims.property.ability.runner.TrimValueAbilityRunner;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AbstractVillager.class})
abstract class AbstractVillagerMixin
extends AgeableMob {
    @Shadow
    public abstract MerchantOffers getOffers();

    AbstractVillagerMixin(EntityType<? extends AgeableMob> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(method={"setTradingPlayer"}, at={@At(value="TAIL")})
    private void applyTrimsToOffers(@Nullable Player player, CallbackInfo ci) {
        if (player == null) {
            return;
        }
        Level level = this.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        for (TrimProperty property : TrimProperties.getProperties((Level)level2)) {
            for (TrimValueAbilityRunner<?> ability : property.getValueAbilityRunners(TrimAbilityComponents.TRADE_COST)) {
                for (MerchantOffer offer : this.getOffers()) {
                    int oldCost = offer.getBaseCostA().getCount();
                    int newCost = Math.round(ability.runEquipment(level2, (LivingEntity)player, oldCost));
                    offer.addToSpecialPriceDiff(-(oldCost - newCost));
                }
            }
        }
    }
}

