/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.bettertrims.property.ability.type.entity;

import com.bawnorton.bettertrims.client.tooltip.component.CompositeContainerComponent;
import com.bawnorton.bettertrims.client.tooltip.element.TrimElementTooltipProvider;
import com.bawnorton.bettertrims.client.tooltip.util.Styler;
import com.bawnorton.bettertrims.property.ability.type.TrimEntityAbility;
import com.bawnorton.bettertrims.property.context.TrimmedItems;
import com.bawnorton.bettertrims.property.count.CountBasedValue;
import com.bawnorton.bettertrims.version.VRegistry;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public record ApplyMobEffectAbility(Holder<MobEffect> effect, CountBasedValue amplifier, CountBasedValue duration) implements TrimEntityAbility
{
    public static final MapCodec<ApplyMobEffectAbility> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)MobEffect.CODEC.fieldOf("effect").forGetter(ApplyMobEffectAbility::effect), (App)CountBasedValue.CODEC.fieldOf("amplifier").forGetter(ApplyMobEffectAbility::amplifier), (App)CountBasedValue.CODEC.fieldOf("duration").forGetter(ApplyMobEffectAbility::duration)).apply((Applicative)instance, ApplyMobEffectAbility::new));

    @Override
    public void apply(ServerLevel level, LivingEntity wearer, Entity target, TrimmedItems items, @Nullable EquipmentSlot targetSlot, Vec3 origin) {
        if (target instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)target;
            int count = items.size();
            int amplifier = (int)this.amplifier.calculate(count);
            int duration = (int)this.duration.calculate(count) * 20;
            if (amplifier < 0 || duration <= 0) {
                return;
            }
            MobEffectInstance effectInstance = new MobEffectInstance(this.effect, duration, amplifier);
            living.addEffect(effectInstance);
        }
    }

    @Override
    public boolean usesCount() {
        return true;
    }

    @Override
    public MapCodec<? extends TrimEntityAbility> codec() {
        return CODEC;
    }

    public static class TooltipProvider
    implements TrimElementTooltipProvider<ApplyMobEffectAbility> {
        @Override
        public ClientTooltipComponent getTooltip(ClientLevel level, ApplyMobEffectAbility element, boolean includeCount) {
            return TooltipProvider.getEffectTooltip(level, includeCount, element.effect(), element.amplifier(), (builder, styler) -> ((CompositeContainerComponent.Builder)((CompositeContainerComponent.Builder)builder.translate("bettertrims.tooltip.ability.apply_mob_effect.for", (UnaryOperator)styler, new Object[0])).cycle(durationCycler -> element.duration().getValueComponents(4, includeCount, f -> Component.literal((String)"%.0f".formatted(f)), f -> f.floatValue() > 0.0f).forEach(durationCycler::textComponent)).translate("bettertrims.tooltip.ability.apply_mob_effect.seconds", (UnaryOperator)styler, new Object[0])).build());
        }

        public static ClientTooltipComponent getEffectTooltip(ClientLevel level, boolean includeCount, Holder<MobEffect> effect, CountBasedValue amplifier, BiFunction<CompositeContainerComponent.Builder, UnaryOperator<Style>, CompositeContainerComponent> builder) {
            Registry registry = VRegistry.get(level, Registries.MOB_EFFECT);
            MobEffect mobEffect = (MobEffect)effect.unwrap().map(arg_0 -> registry.getOrThrow(arg_0), Function.identity());
            MutableComponent name = Styler.name(mobEffect.getDisplayName().copy());
            List<Component> amplifierValues = amplifier.getValueComponents(4, includeCount, f -> Component.translatable((String)"enchantment.level.%s".formatted("%.0f".formatted(Float.valueOf(f.floatValue() + 1.0f)))), f -> f.floatValue() >= 0.0f);
            return builder.apply(((CompositeContainerComponent.Builder)CompositeContainerComponent.builder().translate("bettertrims.tooltip.ability.apply_mob_effect.grants", (UnaryOperator)Styler.sentiment(mobEffect.isBeneficial()), new Object[0])).textComponent((Component)name).cycle(amplifierCycler -> amplifierValues.forEach(amplifierCycler::textComponent)).spaced(), Styler.sentiment(mobEffect.isBeneficial()));
        }
    }
}

