/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.bettertrims.property.ability.type.entity;

import com.bawnorton.bettertrims.client.tooltip.component.CompositeContainerComponent;
import com.bawnorton.bettertrims.client.tooltip.element.TrimElementTooltipProvider;
import com.bawnorton.bettertrims.client.tooltip.util.Styler;
import com.bawnorton.bettertrims.property.ability.type.TrimEntityAbility;
import com.bawnorton.bettertrims.property.context.TrimmedItems;
import com.bawnorton.bettertrims.property.count.CountBasedValue;
import com.bawnorton.bettertrims.version.VRegistry;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public record DamageEntityAbility(CountBasedValue minDamage, CountBasedValue maxDamage, Holder<DamageType> damageType) implements TrimEntityAbility
{
    public static final MapCodec<DamageEntityAbility> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)CountBasedValue.CODEC.fieldOf("min_damage").forGetter(DamageEntityAbility::minDamage), (App)CountBasedValue.CODEC.fieldOf("max_damage").forGetter(DamageEntityAbility::maxDamage), (App)DamageType.CODEC.fieldOf("damage_type").forGetter(DamageEntityAbility::damageType)).apply((Applicative)instance, DamageEntityAbility::new));

    @Override
    public void apply(ServerLevel level, LivingEntity wearer, Entity target, TrimmedItems items, @Nullable EquipmentSlot targetSlot, Vec3 origin) {
        int count = items.size();
        float damage = Mth.randomBetween((RandomSource)target.getRandom(), (float)this.minDamage.calculate(count), (float)this.maxDamage.calculate(count));
        target.hurt(new DamageSource(this.damageType, (Entity)wearer), damage);
    }

    @Override
    public boolean usesCount() {
        return true;
    }

    @Override
    public MapCodec<? extends TrimEntityAbility> codec() {
        return CODEC;
    }

    public static class TooltipProvider
    implements TrimElementTooltipProvider<DamageEntityAbility> {
        @Override
        public ClientTooltipComponent getTooltip(ClientLevel level, DamageEntityAbility element, boolean includeCount) {
            Registry registry = VRegistry.get(level, Registries.DAMAGE_TYPE);
            ResourceLocation type = (ResourceLocation)element.damageType().unwrap().map(ResourceKey::location, arg_0 -> registry.getKey(arg_0));
            List<Float> minValues = element.minDamage().getValues(4);
            List<Float> maxValues = element.maxDamage().getValues(4);
            ArrayList<MutableComponent> components = new ArrayList<MutableComponent>();
            for (int i = 0; i < 4; ++i) {
                components.add(Styler.trim(Component.literal((String)"[%s]".formatted(i + 1))).append(": ").append((Component)Styler.number(Component.literal((String)"%.1f - %.1f".formatted(minValues.get(i), maxValues.get(i))))));
            }
            return ((CompositeContainerComponent.Builder)((CompositeContainerComponent.Builder)((CompositeContainerComponent.Builder)CompositeContainerComponent.builder().translate("bettertrims.tooltip.ability.damage_entity.deals", Styler::positive, new Object[0])).cycle(builder -> components.forEach(builder::textComponent)).literal(type.toString(), Styler::name)).translate("bettertrims.tooltip.ability.damage_entity.damage", Styler::positive, new Object[0])).spaced().build();
        }
    }
}

