/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.bettertrims.property.ability.type.entity;

import com.bawnorton.bettertrims.client.tooltip.component.CompositeContainerComponent;
import com.bawnorton.bettertrims.client.tooltip.element.TrimElementTooltipProvider;
import com.bawnorton.bettertrims.client.tooltip.util.Styler;
import com.bawnorton.bettertrims.property.ability.type.TrimEntityAbility;
import com.bawnorton.bettertrims.property.context.TrimmedItems;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public record ReplaceBlockAbility(Vec3i offset, Optional<BlockPredicate> predicate, BlockStateProvider blockState, Optional<Holder<GameEvent>> triggerGameEvent, Optional<String> replaceTranslationKey, String offsetTranslationKey, String withTranslationKey) implements TrimEntityAbility
{
    public static final MapCodec<ReplaceBlockAbility> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Vec3i.CODEC.optionalFieldOf("offset", (Object)Vec3i.ZERO).forGetter(ReplaceBlockAbility::offset), (App)BlockPredicate.CODEC.optionalFieldOf("predicate").forGetter(ReplaceBlockAbility::predicate), (App)BlockStateProvider.CODEC.fieldOf("block_state").forGetter(ReplaceBlockAbility::blockState), (App)GameEvent.CODEC.optionalFieldOf("trigger_game_event").forGetter(ReplaceBlockAbility::triggerGameEvent), (App)Codec.STRING.optionalFieldOf("replace_translation_key").forGetter(ReplaceBlockAbility::replaceTranslationKey), (App)Codec.STRING.fieldOf("offset_translation_key").forGetter(ReplaceBlockAbility::offsetTranslationKey), (App)Codec.STRING.fieldOf("with_translation_key").forGetter(ReplaceBlockAbility::withTranslationKey)).apply((Applicative)instance, ReplaceBlockAbility::new));

    @Override
    public void apply(ServerLevel level, LivingEntity wearer, Entity target, TrimmedItems items, @Nullable EquipmentSlot targetSlot, Vec3 origin) {
        BlockPos blockPos = BlockPos.containing((Position)origin).offset(this.offset);
        if (this.predicate.map(blockPredicate -> blockPredicate.test((Object)level, (Object)blockPos)).orElse(true).booleanValue() && level.setBlockAndUpdate(blockPos, this.blockState.getState(wearer.getRandom(), blockPos))) {
            this.triggerGameEvent.ifPresent(holder -> level.gameEvent((Entity)wearer, holder, blockPos));
        }
    }

    @Override
    public MapCodec<? extends TrimEntityAbility> codec() {
        return CODEC;
    }

    public static class TooltipProvider
    implements TrimElementTooltipProvider<ReplaceBlockAbility> {
        @Override
        @Nullable
        public ClientTooltipComponent getTooltip(ClientLevel level, ReplaceBlockAbility element, boolean includeCount) {
            MutableComponent replace = Styler.property(element.replaceTranslationKey.map(Component::translatable).orElse(Component.translatable((String)"bettertrims.tooltip.ability.replace_block.everything")));
            MutableComponent offset = Styler.positive(Component.translatable((String)element.offsetTranslationKey));
            MutableComponent with = Styler.name(Component.translatable((String)element.withTranslationKey));
            return ((CompositeContainerComponent.Builder)((CompositeContainerComponent.Builder)CompositeContainerComponent.builder().translate("bettertrims.tooltip.ability.replace_block.replace", Styler::positive, new Object[0])).textComponent((Component)replace).textComponent((Component)offset).translate("bettertrims.tooltip.ability.replace_block.with", Styler::positive, new Object[0])).textComponent((Component)with).spaced().build();
        }
    }
}

