/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.bettertrims.property.ability.type.entity;

import com.bawnorton.bettertrims.client.tooltip.component.CompositeContainerComponent;
import com.bawnorton.bettertrims.client.tooltip.element.TrimElementTooltipProvider;
import com.bawnorton.bettertrims.client.tooltip.util.Styler;
import com.bawnorton.bettertrims.property.ability.type.TrimEntityAbility;
import com.bawnorton.bettertrims.property.context.TrimmedItems;
import com.bawnorton.bettertrims.property.count.CountBasedValue;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.blockpredicates.BlockPredicate;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public record ReplaceDiskAbility(CountBasedValue radius, CountBasedValue height, Vec3i offset, Optional<BlockPredicate> predicate, BlockStateProvider blockState, Optional<Holder<GameEvent>> triggerGameEvent, Optional<String> replaceTranslationKey, String offsetTranslationKey, String withTranslationKey) implements TrimEntityAbility
{
    public static final MapCodec<ReplaceDiskAbility> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)CountBasedValue.CODEC.fieldOf("radius").forGetter(ReplaceDiskAbility::radius), (App)CountBasedValue.CODEC.fieldOf("height").forGetter(ReplaceDiskAbility::height), (App)Vec3i.CODEC.optionalFieldOf("offset", (Object)Vec3i.ZERO).forGetter(ReplaceDiskAbility::offset), (App)BlockPredicate.CODEC.optionalFieldOf("predicate").forGetter(ReplaceDiskAbility::predicate), (App)BlockStateProvider.CODEC.fieldOf("block_state").forGetter(ReplaceDiskAbility::blockState), (App)GameEvent.CODEC.optionalFieldOf("trigger_game_event").forGetter(ReplaceDiskAbility::triggerGameEvent), (App)Codec.STRING.optionalFieldOf("replace_translation_key").forGetter(ReplaceDiskAbility::replaceTranslationKey), (App)Codec.STRING.fieldOf("offset_translation_key").forGetter(ReplaceDiskAbility::offsetTranslationKey), (App)Codec.STRING.fieldOf("with_translation_key").forGetter(ReplaceDiskAbility::withTranslationKey)).apply((Applicative)instance, ReplaceDiskAbility::new));

    @Override
    public void apply(ServerLevel level, LivingEntity wearer, Entity target, TrimmedItems items, @Nullable EquipmentSlot targetSlot, Vec3 origin) {
        int count = items.size();
        BlockPos blockPos = BlockPos.containing((Position)origin).offset(this.offset);
        RandomSource randomSource = wearer.getRandom();
        int radius = (int)this.radius.calculate(count);
        int hieght = (int)this.height.calculate(count);
        for (BlockPos pos : BlockPos.betweenClosed((BlockPos)blockPos.offset(-radius, 0, -radius), (BlockPos)blockPos.offset(radius, Math.min(hieght - 1, 0), radius))) {
            if (!(pos.distToCenterSqr(origin.x(), (double)pos.getY() + 0.5, origin.z()) < (double)Mth.square((int)radius)) || !this.predicate.map(blockPredicate -> blockPredicate.test((Object)level, (Object)pos)).orElse(true).booleanValue() || !level.setBlockAndUpdate(pos, this.blockState.getState(randomSource, pos))) continue;
            this.triggerGameEvent.ifPresent(holder -> level.gameEvent((Entity)wearer, holder, pos));
        }
    }

    @Override
    public MapCodec<? extends TrimEntityAbility> codec() {
        return CODEC;
    }

    public static class TooltipProvider
    implements TrimElementTooltipProvider<ReplaceDiskAbility> {
        @Override
        @Nullable
        public ClientTooltipComponent getTooltip(ClientLevel level, ReplaceDiskAbility element, boolean includeCount) {
            MutableComponent replace = Styler.property(element.replaceTranslationKey.map(Component::translatable).orElse(Component.translatable((String)"bettertrims.tooltip.ability.replace_disk.anything")));
            MutableComponent offset = Styler.positive(Component.translatable((String)element.offsetTranslationKey));
            MutableComponent with = Styler.name(Component.translatable((String)element.withTranslationKey));
            return ((CompositeContainerComponent.Builder)((CompositeContainerComponent.Builder)((CompositeContainerComponent.Builder)((CompositeContainerComponent.Builder)CompositeContainerComponent.builder().translate("bettertrims.tooltip.ability.replace_disk.replace", Styler::positive, new Object[0])).textComponent((Component)replace).textComponent((Component)offset).translate("bettertrims.tooltip.ability.replace_disk.radius", Styler::positive, new Object[0])).cycle(builder -> element.radius().getValueComponents(4, includeCount).forEach(builder::textComponent)).translate("bettertrims.tooltip.ability.replace_disk.height", Styler::positive, new Object[0])).cycle(builder -> element.height().getValueComponents(4, includeCount).forEach(builder::textComponent)).translate("bettertrims.tooltip.ability.replace_block.with", Styler::positive, new Object[0])).textComponent((Component)with).spaced().build();
        }
    }
}

