/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.bettertrims.property.ability.type.entity;

import com.bawnorton.bettertrims.client.tooltip.component.CompositeContainerComponent;
import com.bawnorton.bettertrims.client.tooltip.element.TrimElementTooltipProvider;
import com.bawnorton.bettertrims.client.tooltip.util.Styler;
import com.bawnorton.bettertrims.property.ability.type.TrimEntityAbility;
import com.bawnorton.bettertrims.property.context.TrimmedItems;
import com.bawnorton.bettertrims.version.VRegistry;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.ConstantFloat;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.enchantment.effects.SpawnParticlesEffect;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public record SpawnParticlesAbility(ParticleOptions particle, SpawnParticlesEffect.PositionSource horizontalPosition, SpawnParticlesEffect.PositionSource verticalPosition, SpawnParticlesEffect.VelocitySource horizontalVelocity, SpawnParticlesEffect.VelocitySource verticalVelocity, FloatProvider speed) implements TrimEntityAbility
{
    public static final MapCodec<SpawnParticlesAbility> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ParticleTypes.CODEC.fieldOf("particle").forGetter(SpawnParticlesAbility::particle), (App)SpawnParticlesEffect.PositionSource.CODEC.fieldOf("horizontal_position").forGetter(SpawnParticlesAbility::horizontalPosition), (App)SpawnParticlesEffect.PositionSource.CODEC.fieldOf("vertical_position").forGetter(SpawnParticlesAbility::verticalPosition), (App)SpawnParticlesEffect.VelocitySource.CODEC.fieldOf("horizontal_velocity").forGetter(SpawnParticlesAbility::horizontalVelocity), (App)SpawnParticlesEffect.VelocitySource.CODEC.fieldOf("vertical_velocity").forGetter(SpawnParticlesAbility::verticalVelocity), (App)FloatProvider.CODEC.optionalFieldOf("speed", (Object)ConstantFloat.ZERO).forGetter(SpawnParticlesAbility::speed)).apply((Applicative)instance, SpawnParticlesAbility::new));

    @Override
    public void apply(ServerLevel level, LivingEntity wearer, Entity target, TrimmedItems items, @Nullable EquipmentSlot targetSlot, Vec3 origin) {
        RandomSource random = target.getRandom();
        Vec3 targetVelocity = target.getKnownMovement();
        float width = target.getBbWidth();
        float height = target.getBbHeight();
        level.sendParticles(this.particle, this.horizontalPosition.getCoordinate(origin.x(), origin.x(), width, random), this.verticalPosition.getCoordinate(origin.y(), origin.y() + (double)(height / 2.0f), height, random), this.horizontalPosition.getCoordinate(origin.z(), origin.z(), width, random), 0, this.horizontalVelocity.getVelocity(targetVelocity.x(), random), this.verticalVelocity.getVelocity(targetVelocity.y(), random), this.horizontalVelocity.getVelocity(targetVelocity.z(), random), (double)this.speed.sample(random));
    }

    @Override
    public MapCodec<? extends TrimEntityAbility> codec() {
        return CODEC;
    }

    public static class TooltipProvider
    implements TrimElementTooltipProvider<SpawnParticlesAbility> {
        @Override
        @Nullable
        public ClientTooltipComponent getTooltip(ClientLevel level, SpawnParticlesAbility element, boolean includeCount) {
            Component particleName = TooltipProvider.getParticleName(level, element);
            if (particleName == null) {
                return null;
            }
            return ((CompositeContainerComponent.Builder)((CompositeContainerComponent.Builder)CompositeContainerComponent.builder().translate("bettertrims.tooltip.ability.spawn_particles.spawns", Styler::positive, new Object[0])).textComponent(particleName).translate("bettertrims.tooltip.ability.spawn_particles.particles", Styler::positive, new Object[0])).spaced().build();
        }

        @Nullable
        private static Component getParticleName(ClientLevel level, SpawnParticlesAbility element) {
            ParticleOptions particleOptions = element.particle();
            Objects.requireNonNull(particleOptions);
            ParticleOptions particleOptions2 = particleOptions;
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BlockParticleOption.class}, (Object)particleOptions2, n)) {
                case 0 -> {
                    BlockParticleOption blockParticle = (BlockParticleOption)particleOptions2;
                    BlockState state = blockParticle.getState();
                    MutableComponent blockName = state.getBlock().getName();
                    yield Styler.positive(Component.translatable((String)"bettertrims.tooltip.ability.spawn_particles.block", (Object[])new Object[]{Styler.name(blockName)}));
                }
                default -> {
                    Registry registry = VRegistry.get(level, Registries.PARTICLE_TYPE);
                    ResourceLocation particleType = registry.getKey((Object)element.particle().getType());
                    if (particleType == null) {
                        yield null;
                    }
                    yield Styler.name(Component.literal((String)particleType.toString()));
                }
            };
        }
    }
}

