/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.bettertrims.property.ability.type.toggle;

import com.bawnorton.bettertrims.client.tooltip.component.CompositeContainerComponent;
import com.bawnorton.bettertrims.client.tooltip.element.TrimElementTooltipProvider;
import com.bawnorton.bettertrims.client.tooltip.util.Styler;
import com.bawnorton.bettertrims.mixin.accessor.ItemStackAccessor;
import com.bawnorton.bettertrims.property.ability.type.TrimToggleAbility;
import com.bawnorton.bettertrims.property.context.TrimmedItems;
import com.bawnorton.bettertrims.property.count.CountBasedValue;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public record AttributeAbility(ResourceLocation id, Holder<Attribute> attribute, CountBasedValue value, AttributeModifier.Operation operation) implements TrimToggleAbility
{
    public static final MapCodec<AttributeAbility> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("id").forGetter(AttributeAbility::id), (App)Attribute.CODEC.fieldOf("attribute").forGetter(AttributeAbility::attribute), (App)CountBasedValue.CODEC.fieldOf("value").forGetter(AttributeAbility::value), (App)AttributeModifier.Operation.CODEC.fieldOf("operation").forGetter(AttributeAbility::operation)).apply((Applicative)instance, AttributeAbility::new));

    private Multimap<Holder<Attribute>, AttributeModifier> makeAttributeMap(int count) {
        HashMultimap multimap = HashMultimap.create();
        multimap.put(this.attribute, (Object)this.getAttributeModifier(count));
        return multimap;
    }

    private AttributeModifier getAttributeModifier(int count) {
        return new AttributeModifier(this.id, (double)this.value.calculate(count), this.operation);
    }

    @Override
    public void start(ServerLevel level, LivingEntity wearer, TrimmedItems items) {
        wearer.getAttributes().addTransientAttributeModifiers(this.makeAttributeMap(items.size()));
    }

    @Override
    public void stop(ServerLevel level, LivingEntity wearer, TrimmedItems items) {
        wearer.getAttributes().removeAttributeModifiers(this.makeAttributeMap(items.size()));
    }

    @Override
    public boolean usesCount() {
        return true;
    }

    @Override
    public MapCodec<? extends TrimToggleAbility> codec() {
        return CODEC;
    }

    public static class TooltipProvider
    implements TrimElementTooltipProvider<AttributeAbility> {
        @Override
        @Nullable
        public ClientTooltipComponent getTooltip(ClientLevel level, AttributeAbility element, boolean includeCount) {
            boolean distinct = element.value().getValueComponents(4, includeCount).size() == 1;
            ArrayList modifiers = new ArrayList();
            for (int i = 1; i <= 4; ++i) {
                int count = i;
                ((ItemStackAccessor)ItemStack.EMPTY).bettertrims$addModifierTooltip(component -> {
                    if (includeCount && !distinct) {
                        component = Styler.trim(Component.literal((String)"[%d]".formatted(count))).append(": ").append(component);
                    }
                    modifiers.add(component);
                }, (Player)Minecraft.getInstance().player, element.attribute(), element.getAttributeModifier(i));
            }
            return CompositeContainerComponent.builder().cycle(builder -> modifiers.forEach(builder::textComponent)).build();
        }
    }
}

