/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.bettertrims.property.element;

import com.bawnorton.bettertrims.property.element.TrimElement;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public record ConditionalElement<T extends TrimElement>(T element, Optional<LootItemCondition> requirements) {
    public static Codec<LootItemCondition> conditionCodec(LootContextParamSet contextKeySet) {
        return LootItemCondition.DIRECT_CODEC.validate(lootItemCondition -> {
            ProblemReporter.Collector collector = new ProblemReporter.Collector();
            ValidationContext validationContext = new ValidationContext((ProblemReporter)collector, contextKeySet);
            lootItemCondition.validate(validationContext);
            return collector.getReport().map(string -> DataResult.error(() -> "Validation error in trim element condition: " + string)).orElseGet(() -> DataResult.success((Object)lootItemCondition));
        });
    }

    public static <T extends TrimElement> Codec<ConditionalElement<T>> ability(Codec<T> codec, LootContextParamSet contextKeySet) {
        return RecordCodecBuilder.create(instance -> instance.group((App)codec.fieldOf("ability").forGetter(ConditionalElement::element), (App)ConditionalElement.conditionCodec(contextKeySet).optionalFieldOf("requirements").forGetter(ConditionalElement::requirements)).apply((Applicative)instance, ConditionalElement::new));
    }

    public static <T extends TrimElement> Codec<ConditionalElement<T>> itemProperty(Codec<T> codec, LootContextParamSet contextKeySet) {
        return RecordCodecBuilder.create(instance -> instance.group((App)codec.fieldOf("item_property").forGetter(ConditionalElement::element), (App)ConditionalElement.conditionCodec(contextKeySet).optionalFieldOf("requirements").forGetter(ConditionalElement::requirements)).apply((Applicative)instance, ConditionalElement::new));
    }

    public boolean matches(LootContext context) {
        return this.requirements.map(condition -> condition.test((Object)context)).orElse(true);
    }
}

