package com.bawnorton.bettertrims.client.tooltip.condition.predicate.data.partial;

import com.bawnorton.bettertrims.client.tooltip.component.CompositeContainerComponent;
import com.bawnorton.bettertrims.client.tooltip.condition.LootConditionTooltips;
import com.bawnorton.bettertrims.client.tooltip.condition.predicate.PredicateTooltip;
import com.bawnorton.bettertrims.client.tooltip.util.Styler;
import org.apache.commons.lang3.StringUtils;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1304;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_2096;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_638;
import net.minecraft.class_6885;
import net.minecraft.class_7924;
import net.minecraft.class_9274;
import net.minecraft.class_9285;
import net.minecraft.class_9648;
import net.minecraft.class_9653;

public final class AttributeModifiersPartialAdder implements PartialAdder</*$ attribute_modifiers_predicate >>*/ class_9653 > {
	@Override
	public void addToBuilder(class_638 level, /*$ attribute_modifiers_predicate >>*/ class_9653 predicate, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
		Optional<class_9648<class_9285.class_9287, /*$ attribute_modifiers_predicate >>*/ class_9653 .class_9654>> modifiers = predicate.comp_2623();
		if (modifiers.isPresent()) {
			addCollectionToBuilder(
					level,
					modifiers.orElseThrow(),
					"attribute_modifiers",
					(predicateLevel, entryPredicate, predicateState, collectionBuilder) -> {
						Optional<class_2960> id = entryPredicate.comp_2625();
						Optional<class_6885<class_1320>> attributeSet = entryPredicate.comp_2624();
						Optional<class_9274> slot = entryPredicate.comp_2629();
						Optional<class_1322.class_1323> operation = entryPredicate.comp_2628();
						class_2096.class_2099 amount = entryPredicate.comp_2627();

						if (attributeSet.isPresent()) {
							PredicateTooltip.addRegisteredElementsToBuilder(
									level,
									key("attribute_modifiers.attribute"),
									class_7924.field_41251,
									attributeSet.orElseThrow(),
									(attribute, appender) -> {
										if (operation.isPresent() && !amount.method_9041()) {
											CompositeContainerComponent.Builder detailBuilder = CompositeContainerComponent.builder();
											PredicateTooltip.addMinMaxToBuilder(
													key("attribute_modifiers.amount.%s".formatted(operation.orElseThrow().method_56082())),
													false,
													amount,
													value -> class_2561.method_43470((value > 0 ? "+" : "-") + class_9285.field_49329.format(value)),
													predicateState,
													detailBuilder
											);
											appender.component(detailBuilder.build())
													.space()
													.textComponent(Styler.positive(class_2561.method_43471(attribute.method_26830())));
											return class_2561.method_43470("");
										}
										return class_2561.method_43470("").method_10852(Styler.positive(class_2561.method_43471(attribute.method_26830())));
									},
									predicateState.withPrefixSpace(false),
									collectionBuilder
							);
							predicateState.withPrefixSpace(true);
						}

						if (id.isPresent()) {
							collectionBuilder.space()
									.translate(key("attribute_modifiers.id"), Styler::condition, Styler.value(class_2561.method_43470(id.orElseThrow().toString())));
						}

						if (slot.isPresent()) {
							//? if >=1.21.8 {
							/*List<EquipmentSlot> slots = slot.orElseThrow().slots();
							 *///?} else {
							List<class_1304> slots = Arrays.stream(class_1304.values()).filter(slot.orElseThrow()::method_57286).toList();
							if (!slots.isEmpty()) {
								PredicateTooltip.addEnumListToBuilder(
										key("attribute_modifiers.slot"),
										slots,
										s -> class_2561.method_43471(StringUtils.capitalize(s.method_5923())),
										predicateState,
										collectionBuilder
								);
							}
							//?}
						}
					},
					state,
					builder
			);
		} else {
			builder.space().translate(key("attribute_modifiers.any"), Styler::condition);
		}
	}
}
