package com.bawnorton.bettertrims.property.ability.type;

import com.bawnorton.bettertrims.BetterTrims;
import com.bawnorton.bettertrims.property.AllOf;
import com.bawnorton.bettertrims.property.ability.type.entity.*;
import com.bawnorton.bettertrims.property.context.TrimmedItems;
import com.bawnorton.bettertrims.property.element.TrimElement;
import com.bawnorton.bettertrims.registry.BetterTrimsRegistries;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import org.jetbrains.annotations.Nullable;

import java.util.function.Function;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_2378;
import net.minecraft.class_243;
import net.minecraft.class_3218;

public interface TrimEntityAbility extends TrimElement {
	Codec<TrimEntityAbility> CODEC = BetterTrimsRegistries.TRIM_ENTITY_ABILITY_TYPE
			.method_39673()
			.dispatch(TrimEntityAbility::codec, Function.identity());

	static MapCodec<? extends TrimEntityAbility> bootstrap(class_2378<MapCodec<? extends TrimEntityAbility>> registry) {
		class_2378.method_10230(registry, BetterTrims.rl("all_of"), AllOf.EntityAbilities.CODEC);
		class_2378.method_10230(registry, BetterTrims.rl("apply_mob_effect"), ApplyMobEffectAbility.CODEC);
		class_2378.method_10230(registry, BetterTrims.rl("change_item_damage"), ChangeItemDamageAbility.CODEC);
		class_2378.method_10230(registry, BetterTrims.rl("damage_entity"), DamageEntityAbility.CODEC);
		class_2378.method_10230(registry, BetterTrims.rl("explode"), ExplodeAbility.CODEC);
		class_2378.method_10230(registry, BetterTrims.rl("ignite"), IgniteAbility.CODEC);
		class_2378.method_10230(registry, BetterTrims.rl("play_sound"), PlaySoundAbility.CODEC);
		class_2378.method_10230(registry, BetterTrims.rl("replace_block"), ReplaceBlockAbility.CODEC);
		class_2378.method_10230(registry, BetterTrims.rl("replace_disk"), ReplaceDiskAbility.CODEC);
		class_2378.method_10230(registry, BetterTrims.rl("run_function"), RunFunctionAbility.CODEC);
		class_2378.method_10230(registry, BetterTrims.rl("set_block_properties"), SetBlockPropertiesAbility.CODEC);
		class_2378.method_10230(registry, BetterTrims.rl("spawn_particles"), SpawnParticlesAbility.CODEC);
		return class_2378.method_10230(registry, BetterTrims.rl("summon_entity"), SummonEntityAbility.CODEC);
	}

	void apply(class_3218 level, class_1309 wearer, class_1297 target, TrimmedItems items, @Nullable class_1304 targetSlot, class_243 origin);

	MapCodec<? extends TrimEntityAbility> codec();
}
