/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.bettertrims.client.tooltip;

import com.bawnorton.bettertrims.client.mixin.accessor.ClientTextTooltipAccessor;
import com.bawnorton.bettertrims.client.tooltip.component.CompositeComponent;
import com.bawnorton.bettertrims.client.tooltip.component.CompositeContainerComponent;
import com.bawnorton.bettertrims.client.tooltip.component.ConditionalComponent;
import com.bawnorton.bettertrims.client.tooltip.component.CyclingComponent;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_327;
import net.minecraft.class_5224;
import net.minecraft.class_5250;
import net.minecraft.class_5683;
import net.minecraft.class_5684;

public final class TooltipComponentOptimiser {
    private static final CompositeContainerComponent EMPTY = CompositeContainerComponent.builder().build();
    private static final List<Pass> OPTIMISATION_PASSES = List.of(TooltipComponentOptimiser::flatten, TooltipComponentOptimiser::flattenHorizontal, TooltipComponentOptimiser::flattenVertical, TooltipComponentOptimiser::mergeTextTooltips);
    private static final List<Pass> FINAL_PASSES = List.of(TooltipComponentOptimiser::clearHorizontalOffsets, TooltipComponentOptimiser::setPropertVerticalOffsets);

    private TooltipComponentOptimiser() {
    }

    public static class_5684 optimise(CompositeComponent component, class_327 font) {
        if (component == null || component.getComponents().isEmpty()) {
            return EMPTY;
        }
        CompositeComponent current = component;
        for (int i = 0; i < 2; ++i) {
            for (Pass pass : OPTIMISATION_PASSES) {
                current = pass.apply(current, font);
            }
        }
        for (Pass pass : FINAL_PASSES) {
            current = pass.apply(current, font);
        }
        return current;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static class_5684 flatten(class_5684 component, class_327 font) {
        if (!(component instanceof CompositeComponent)) {
            return TooltipComponentOptimiser.forwardPassToNonComposite(component, font, TooltipComponentOptimiser::flatten);
        }
        CompositeComponent composite = (CompositeComponent)component;
        if (composite instanceof CyclingComponent) {
            CyclingComponent cycling = (CyclingComponent)composite;
            return TooltipComponentOptimiser.forwardPassToCycling(cycling, font, TooltipComponentOptimiser::flatten);
        }
        CompositeContainerComponent.Builder builder = CompositeContainerComponent.builder();
        if (composite instanceof CompositeContainerComponent) {
            CompositeContainerComponent container = (CompositeContainerComponent)composite;
            if (container.getComponents().size() == 1) {
                class_5684 single = container.getComponents().getFirst();
                return TooltipComponentOptimiser.flatten(single, font);
            }
            if (container instanceof CompositeContainerComponent.Vertical) {
                builder.vertical();
            }
            if (container.isCentred()) {
                builder.centred(true);
            }
        }
        Iterator<class_5684> iterator = composite.getComponents().iterator();
        block6: while (iterator.hasNext()) {
            class_5684 class_56842;
            class_5684 child = iterator.next();
            Objects.requireNonNull(child);
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ConditionalComponent.class, CompositeComponent.class}, (Object)class_56842, n)) {
                case 0: {
                    ConditionalComponent conditionalComponent = (ConditionalComponent)class_56842;
                    try {
                        Object object;
                        class_5684 ifTrue = object = conditionalComponent.ifTrue();
                        class_5684 ifFalse = object = conditionalComponent.ifFalse();
                        Object checker = object = conditionalComponent.checker();
                        builder.component(new ConditionalComponent(TooltipComponentOptimiser.flatten(ifTrue, font), TooltipComponentOptimiser.flatten(ifFalse, font), (Supplier<Boolean>)checker));
                        continue block6;
                    }
                    catch (Throwable throwable) {
                        throw new MatchException(throwable.toString(), throwable);
                    }
                }
                case 1: {
                    CompositeComponent cc = (CompositeComponent)class_56842;
                    builder.component(TooltipComponentOptimiser.flatten(cc, font));
                    continue block6;
                }
            }
            builder.component(TooltipComponentOptimiser.flatten(child, font));
        }
        return builder.build();
    }

    /*
     * Loose catch block
     */
    private static class_5684 mergeTextTooltips(class_5684 component, class_327 font) {
        if (!(component instanceof CompositeComponent)) {
            return TooltipComponentOptimiser.forwardPassToNonComposite(component, font, TooltipComponentOptimiser::mergeTextTooltips);
        }
        CompositeComponent composite = (CompositeComponent)component;
        if (composite instanceof CyclingComponent) {
            CyclingComponent cycling = (CyclingComponent)composite;
            return TooltipComponentOptimiser.forwardPassToCycling(cycling, font, TooltipComponentOptimiser::mergeTextTooltips);
        }
        CompositeContainerComponent.Builder builder = CompositeContainerComponent.builder();
        if (composite instanceof CompositeContainerComponent) {
            CompositeContainerComponent container = (CompositeContainerComponent)composite;
            if (container instanceof CompositeContainerComponent.Vertical) {
                builder.vertical();
            }
            if (container.isCentred()) {
                builder.centred(true);
            }
        }
        TextMerger merger = new TextMerger(composite instanceof CompositeContainerComponent.Vertical);
        block8: for (class_5684 child : composite.getComponents()) {
            class_5684 class_56842;
            Objects.requireNonNull(child);
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{class_5683.class, ConditionalComponent.class}, (Object)class_56842, n)) {
                case 0: {
                    class_5683 text = (class_5683)class_56842;
                    merger.add(text);
                    continue block8;
                }
                case 1: {
                    Object object;
                    ConditionalComponent conditionalComponent = (ConditionalComponent)class_56842;
                    class_5684 ifTrue = object = conditionalComponent.ifTrue();
                    class_5684 ifFalse = object = conditionalComponent.ifFalse();
                    Object checker = object = conditionalComponent.checker();
                    merger.flush(builder);
                    builder.component(new ConditionalComponent(TooltipComponentOptimiser.mergeTextTooltips(ifTrue, font), TooltipComponentOptimiser.mergeTextTooltips(ifFalse, font), (Supplier<Boolean>)checker));
                    continue block8;
                }
            }
            merger.flush(builder);
            builder.component(TooltipComponentOptimiser.mergeTextTooltips(child, font));
        }
        merger.flush(builder);
        return builder.build();
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
    }

    private static class_5684 flattenHorizontal(class_5684 component, class_327 font) {
        if (!(component instanceof CompositeComponent)) {
            return TooltipComponentOptimiser.forwardPassToNonComposite(component, font, TooltipComponentOptimiser::flattenHorizontal);
        }
        CompositeComponent composite = (CompositeComponent)component;
        if (composite instanceof CyclingComponent) {
            CyclingComponent cycling = (CyclingComponent)composite;
            return TooltipComponentOptimiser.forwardPassToCycling(cycling, font, TooltipComponentOptimiser::flattenHorizontal);
        }
        if (composite instanceof CompositeContainerComponent) {
            CompositeContainerComponent container = (CompositeContainerComponent)composite;
            CompositeContainerComponent.Builder builder = CompositeContainerComponent.builder();
            if (container instanceof CompositeContainerComponent.Vertical) {
                builder.vertical();
            } else if (container instanceof CompositeContainerComponent.Horizontal) {
                builder.horizontal();
            }
            if (container.isCentred()) {
                builder.centred(true);
            }
            for (class_5684 child : container.getComponents()) {
                class_5684 flattenedChild = TooltipComponentOptimiser.flattenHorizontal(child, font);
                if (container instanceof CompositeContainerComponent.Horizontal && flattenedChild instanceof CompositeContainerComponent.Horizontal) {
                    CompositeContainerComponent.Horizontal nested = (CompositeContainerComponent.Horizontal)flattenedChild;
                    for (class_5684 grandChild : nested.getComponents()) {
                        builder.component(grandChild);
                    }
                    continue;
                }
                builder.component(flattenedChild);
            }
            return builder.build();
        }
        CompositeContainerComponent.Builder builder = CompositeContainerComponent.builder();
        for (class_5684 child : composite.getComponents()) {
            builder.component(TooltipComponentOptimiser.flattenHorizontal(child, font));
        }
        return builder.build();
    }

    private static class_5684 flattenVertical(class_5684 component, class_327 font) {
        if (!(component instanceof CompositeComponent)) {
            return TooltipComponentOptimiser.forwardPassToNonComposite(component, font, TooltipComponentOptimiser::flattenVertical);
        }
        CompositeComponent composite = (CompositeComponent)component;
        if (composite instanceof CyclingComponent) {
            CyclingComponent cycling = (CyclingComponent)composite;
            return TooltipComponentOptimiser.forwardPassToCycling(cycling, font, TooltipComponentOptimiser::flattenVertical);
        }
        if (composite instanceof CompositeContainerComponent) {
            CompositeContainerComponent container = (CompositeContainerComponent)composite;
            CompositeContainerComponent.Builder builder = CompositeContainerComponent.builder();
            if (container instanceof CompositeContainerComponent.Vertical) {
                builder.vertical();
            } else if (container instanceof CompositeContainerComponent.Horizontal) {
                builder.horizontal();
            }
            if (container.isCentred()) {
                builder.centred(true);
            }
            for (class_5684 child : container.getComponents()) {
                class_5684 flattenedChild = TooltipComponentOptimiser.flattenVertical(child, font);
                if (container instanceof CompositeContainerComponent.Vertical && flattenedChild instanceof CompositeContainerComponent.Vertical) {
                    CompositeContainerComponent.Vertical nested = (CompositeContainerComponent.Vertical)flattenedChild;
                    for (class_5684 grandChild : nested.getComponents()) {
                        builder.component(grandChild);
                    }
                    continue;
                }
                builder.component(flattenedChild);
            }
            return builder.build();
        }
        CompositeContainerComponent.Builder builder = CompositeContainerComponent.builder();
        for (class_5684 child : composite.getComponents()) {
            builder.component(TooltipComponentOptimiser.flattenVertical(child, font));
        }
        return builder.build();
    }

    public static class_5684 clearHorizontalOffsets(class_5684 root, class_327 font) {
        return TooltipComponentOptimiser.clearHorizontalOffsets(root, font, 0, 0, 0);
    }

    private static class_5684 clearHorizontalOffsets(class_5684 component, class_327 font, int absX, int anchorAbsX, int verticalDepth) {
        if (!(component instanceof CompositeComponent)) {
            return TooltipComponentOptimiser.forwardPassToNonComposite(component, font, (c, f) -> TooltipComponentOptimiser.clearHorizontalOffsets(c, f, absX, anchorAbsX, verticalDepth));
        }
        CompositeComponent composite = (CompositeComponent)component;
        CompositeComponent compositeComponent = composite;
        Objects.requireNonNull(compositeComponent);
        CompositeComponent compositeComponent2 = compositeComponent;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{CyclingComponent.class, CompositeContainerComponent.Horizontal.class, CompositeContainerComponent.Vertical.class}, (Object)compositeComponent2, n)) {
            case 0: {
                CyclingComponent cycling = (CyclingComponent)compositeComponent2;
                return TooltipComponentOptimiser.forwardPassToCycling(cycling, font, (c, f) -> TooltipComponentOptimiser.clearHorizontalOffsets(c, f, absX, anchorAbsX, verticalDepth));
            }
            case 1: {
                CompositeContainerComponent.Horizontal horizontal = (CompositeContainerComponent.Horizontal)compositeComponent2;
                int runningX = 0;
                for (class_5684 child : horizontal.getComponents()) {
                    int childAbsX = absX + runningX;
                    TooltipComponentOptimiser.clearChildHorizontalOffsets(font, anchorAbsX, verticalDepth, child, childAbsX);
                    runningX += child.method_32664(font);
                }
                return composite;
            }
            case 2: {
                CompositeContainerComponent.Vertical vertical = (CompositeContainerComponent.Vertical)compositeComponent2;
                vertical.setHorizontalOffset(absX - anchorAbsX);
                List<class_5684> children = vertical.getComponents();
                for (int i = 0; i < children.size(); ++i) {
                    class_5684 child = children.get(i);
                    int childAbsX = i == 0 ? absX : anchorAbsX;
                    TooltipComponentOptimiser.clearChildHorizontalOffsets(font, anchorAbsX, verticalDepth, child, childAbsX);
                }
                return vertical;
            }
        }
        int runningX = 0;
        for (class_5684 child : composite.getComponents()) {
            int childAbsX = absX + runningX;
            TooltipComponentOptimiser.clearHorizontalOffsets(child, font, childAbsX, anchorAbsX, verticalDepth);
            runningX += child.method_32664(font);
        }
        return composite;
    }

    private static void clearChildHorizontalOffsets(class_327 font, int anchorAbsX, int verticalDepth, class_5684 child, int childAbsX) {
        if (child instanceof CompositeContainerComponent.Vertical) {
            CompositeContainerComponent.Vertical nestedVert = (CompositeContainerComponent.Vertical)child;
            nestedVert.setHorizontalOffset(childAbsX - anchorAbsX);
            TooltipComponentOptimiser.clearHorizontalOffsets(nestedVert, font, childAbsX, anchorAbsX, verticalDepth + 1);
        } else if (child instanceof CompositeContainerComponent.Horizontal) {
            CompositeContainerComponent.Horizontal horChild = (CompositeContainerComponent.Horizontal)child;
            TooltipComponentOptimiser.clearHorizontalOffsets(horChild, font, childAbsX, anchorAbsX, verticalDepth);
        } else {
            TooltipComponentOptimiser.clearHorizontalOffsets(child, font, childAbsX, anchorAbsX, verticalDepth);
        }
    }

    private static class_5684 setPropertVerticalOffsets(class_5684 clientTooltipComponent, class_327 font) {
        return TooltipComponentOptimiser.setProperVerticalOffsets(clientTooltipComponent, font, 0);
    }

    private static class_5684 setProperVerticalOffsets(class_5684 component, class_327 font, int verticalDepth) {
        int initialDepth = verticalDepth;
        if (!(component instanceof CompositeComponent)) {
            return TooltipComponentOptimiser.forwardPassToNonComposite(component, font, (c, f) -> TooltipComponentOptimiser.setProperVerticalOffsets(c, f, initialDepth));
        }
        CompositeComponent composite = (CompositeComponent)component;
        if (composite instanceof CyclingComponent) {
            CyclingComponent cycling = (CyclingComponent)composite;
            return TooltipComponentOptimiser.forwardPassToCycling(cycling, font, (c, f) -> TooltipComponentOptimiser.setProperVerticalOffsets(c, f, initialDepth));
        }
        if (composite instanceof CompositeContainerComponent.Vertical) {
            CompositeContainerComponent.Vertical vertical = (CompositeContainerComponent.Vertical)composite;
            vertical.setHorizontalOffset(vertical.getHorizontalOffset() - verticalDepth * font.method_1727("  "));
            ++verticalDepth;
        }
        for (class_5684 child : composite.getComponents()) {
            TooltipComponentOptimiser.setProperVerticalOffsets(child, font, verticalDepth);
        }
        return composite;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static class_5684 forwardPassToNonComposite(class_5684 component, class_327 font, Pass pass) {
        class_5684 ifTrue;
        Object object;
        if (!(component instanceof ConditionalComponent)) return component;
        ConditionalComponent conditionalComponent = (ConditionalComponent)component;
        try {
            ifTrue = object = conditionalComponent.ifTrue();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        class_5684 ifFalse = object = conditionalComponent.ifFalse();
        Object checker = object = conditionalComponent.checker();
        return new ConditionalComponent(pass.apply(ifTrue, font), pass.apply(ifFalse, font), (Supplier<Boolean>)checker);
    }

    private static CyclingComponent forwardPassToCycling(CyclingComponent cycling, class_327 font, Pass pass) {
        CyclingComponent.Builder cyclingBuilder = CyclingComponent.builder();
        for (class_5684 child : cycling.getComponents()) {
            cyclingBuilder.component(pass.apply(child, font));
        }
        return cyclingBuilder.build();
    }

    static interface Pass {
        public class_5684 apply(class_5684 var1, class_327 var2);
    }

    private static class TextMerger {
        private final List<class_5683> buffer = new ArrayList<class_5683>();
        private final boolean isVertical;

        public TextMerger(boolean isVertical) {
            this.isVertical = isVertical;
        }

        void add(class_5683 text) {
            this.buffer.add(text);
        }

        void flush(CompositeContainerComponent.Builder builder) {
            if (this.buffer.isEmpty()) {
                return;
            }
            if (this.buffer.size() == 1) {
                builder.component((class_5684)this.buffer.getFirst());
            } else if (!this.isVertical) {
                builder.component((class_5684)this.mergeAll(this.buffer));
            } else {
                this.buffer.forEach(builder::component);
            }
            this.buffer.clear();
        }

        private class_5683 mergeAll(List<class_5683> tooltips) {
            class_5250 combined = class_2561.method_43473();
            var ref = new Object(this){
                class_2583 currentStyle = null;
            };
            StringBuilder sb = new StringBuilder();
            class_5224 sink = (index, style, codepoint) -> {
                if (ref.currentStyle == null) {
                    ref.currentStyle = style;
                }
                if (!style.equals((Object)ref.currentStyle)) {
                    if (!sb.isEmpty()) {
                        combined.method_10852((class_2561)class_2561.method_43470((String)sb.toString()).method_27696(ref.currentStyle));
                        sb.setLength(0);
                    }
                    ref.currentStyle = style;
                }
                sb.appendCodePoint(codepoint);
                return true;
            };
            for (class_5683 t : tooltips) {
                ((ClientTextTooltipAccessor)t).bettertrims$text().accept(sink);
            }
            if (!sb.isEmpty()) {
                combined.method_10852((class_2561)class_2561.method_43470((String)sb.toString()).method_27696(ref.currentStyle));
            }
            return new class_5683(combined.method_30937());
        }
    }
}

