/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.bettertrims.client.tooltip.condition.predicate;

import com.bawnorton.bettertrims.client.tooltip.component.CompositeBuilder;
import com.bawnorton.bettertrims.client.tooltip.component.CompositeContainerComponent;
import com.bawnorton.bettertrims.client.tooltip.condition.LootConditionTooltips;
import com.bawnorton.bettertrims.client.tooltip.condition.predicate.EntitySubPredicateTooltip;
import com.bawnorton.bettertrims.client.tooltip.condition.predicate.ItemPredicateTooltip;
import com.bawnorton.bettertrims.client.tooltip.condition.predicate.LocationPredicateTooltip;
import com.bawnorton.bettertrims.client.tooltip.condition.predicate.PredicateTooltip;
import com.bawnorton.bettertrims.client.tooltip.util.Formatter;
import com.bawnorton.bettertrims.client.tooltip.util.Styler;
import com.bawnorton.bettertrims.version.VRegistry;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_1291;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_2025;
import net.minecraft.class_2040;
import net.minecraft.class_2048;
import net.minecraft.class_2050;
import net.minecraft.class_2073;
import net.minecraft.class_2090;
import net.minecraft.class_2096;
import net.minecraft.class_2102;
import net.minecraft.class_2105;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_3735;
import net.minecraft.class_5250;
import net.minecraft.class_5684;
import net.minecraft.class_638;
import net.minecraft.class_7376;
import net.minecraft.class_7924;
import net.minecraft.class_9350;
import net.minecraft.class_9750;
import org.apache.commons.lang3.StringUtils;

public interface EntityPredicateTooltip {
    public static void addToBuilder(class_638 level, class_2048 predicate, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
        Optional slots;
        Optional team;
        Optional targetedEntity;
        Optional passenger;
        Optional vehicle;
        Optional periodicTick;
        Optional subPredicate;
        Optional equipment;
        Optional flags;
        Optional nbt;
        Optional effects;
        Optional affectsMovement;
        Optional steppingOn;
        class_2048.class_9777 location;
        Optional located;
        Optional movement;
        Optional distancePredicate;
        Optional entityTypePredicate = predicate.comp_1761();
        if (entityTypePredicate.isPresent()) {
            EntityPredicateTooltip.addEntityTypePredicateToBuilder(level, (class_2050)entityTypePredicate.orElseThrow(), state, builder);
        }
        if ((distancePredicate = predicate.comp_1762()).isPresent()) {
            EntityPredicateTooltip.addDistancePredicateToBuilder(level, (class_2025)distancePredicate.orElseThrow(), state, builder);
        }
        if ((movement = predicate.comp_2668()).isPresent()) {
            EntityPredicateTooltip.addMovementPredicateToBuilder(level, (class_9750)movement.orElseThrow(), state, builder);
        }
        if ((located = (location = predicate.comp_1763()).comp_2813()).isPresent()) {
            EntityPredicateTooltip.addLocationPredicateToBuilder(level, (class_2090)located.orElseThrow(), state, builder);
        }
        if ((steppingOn = location.comp_2814()).isPresent()) {
            EntityPredicateTooltip.addLocationPredicateToBuilder(level, (class_2090)steppingOn.orElseThrow(), state, builder);
        }
        if ((affectsMovement = location.comp_2815()).isPresent()) {
            EntityPredicateTooltip.addLocationPredicateToBuilder(level, (class_2090)affectsMovement.orElseThrow(), state, builder);
        }
        if ((effects = predicate.comp_1765()).isPresent()) {
            EntityPredicateTooltip.addMobEffectsPredicateToBuilder(level, (class_2102)effects.orElseThrow(), state, builder);
        }
        if ((nbt = predicate.comp_1766()).isPresent()) {
            EntityPredicateTooltip.addNbtPredicateToBuilder(level, EntityPredicateTooltip.key("nbt"), (class_2105)nbt.orElseThrow(), state, builder);
        }
        if ((flags = predicate.comp_1767()).isPresent()) {
            EntityPredicateTooltip.addEntityFlagsPredicateToBuilder(level, (class_2040)flags.orElseThrow(), state, builder);
        }
        if ((equipment = predicate.comp_1768()).isPresent()) {
            EntityPredicateTooltip.addEntityEquipmentPredicateToBuilder(level, (class_3735)equipment.orElseThrow(), state, builder);
        }
        if ((subPredicate = predicate.comp_1769()).isPresent()) {
            EntityPredicateTooltip.addEntitySubPredicateToBuilder(level, (class_7376)subPredicate.orElseThrow(), state, builder);
        }
        if ((periodicTick = predicate.comp_2669()).isPresent()) {
            EntityPredicateTooltip.addPeriodicTickToBuilder(level, (Integer)periodicTick.orElseThrow(), state, builder);
        }
        if ((vehicle = predicate.comp_1770()).isPresent()) {
            EntityPredicateTooltip.addEntityPredicateToBuilder(level, "vehicle", (class_2048)vehicle.orElseThrow(), state, builder);
        }
        if ((passenger = predicate.comp_1771()).isPresent()) {
            EntityPredicateTooltip.addEntityPredicateToBuilder(level, "passenger", (class_2048)passenger.orElseThrow(), state, builder);
        }
        if ((targetedEntity = predicate.comp_1772()).isPresent()) {
            EntityPredicateTooltip.addEntityPredicateToBuilder(level, "targeted_entity", (class_2048)targetedEntity.orElseThrow(), state, builder);
        }
        if ((team = predicate.comp_1773()).isPresent()) {
            EntityPredicateTooltip.addTeamToBuilder(level, (String)team.orElseThrow(), state, builder);
        }
        if ((slots = predicate.comp_2446()).isPresent()) {
            EntityPredicateTooltip.addSlotsPredicateToBuilder(level, (class_9350)slots.orElseThrow(), state, builder);
        }
    }

    public static String key(String key) {
        return PredicateTooltip.key("entity.%s".formatted(key));
    }

    public static void addEntityTypePredicateToBuilder(class_638 level, class_2050 predicate, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
        PredicateTooltip.addRegisteredElementsToBuilder(level, EntityPredicateTooltip.key("matches"), class_7924.field_41266, predicate.comp_1775(), class_1299::method_5897, state, builder);
    }

    public static void addDistancePredicateToBuilder(class_638 level, class_2025 predicate, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
        class_2096.class_2099 x = predicate.comp_1743();
        class_2096.class_2099 y = predicate.comp_1744();
        class_2096.class_2099 z = predicate.comp_1745();
        class_2096.class_2099 horizontal = predicate.comp_1746();
        class_2096.class_2099 absolute = predicate.comp_1747();
        CompositeContainerComponent.Builder distanceBuilder = CompositeContainerComponent.builder().space().translate(EntityPredicateTooltip.key("distance"), new Object[0]).space();
        boolean useAnd = false;
        if (!x.method_9041()) {
            PredicateTooltip.addMinMaxToBuilder(EntityPredicateTooltip.key("distance.x"), false, x, state, distanceBuilder);
            useAnd = true;
        }
        if (!y.method_9041()) {
            PredicateTooltip.addMinMaxToBuilder(EntityPredicateTooltip.key("distance.y"), useAnd, y, state, distanceBuilder);
            useAnd = true;
        }
        if (!z.method_9041()) {
            PredicateTooltip.addMinMaxToBuilder(EntityPredicateTooltip.key("distance.z"), useAnd, z, state, distanceBuilder);
            useAnd = true;
        }
        if (!horizontal.method_9041()) {
            PredicateTooltip.addMinMaxToBuilder(EntityPredicateTooltip.key("distance.horizontal"), useAnd, horizontal, state, distanceBuilder);
            useAnd = true;
        }
        if (!absolute.method_9041()) {
            PredicateTooltip.addMinMaxToBuilder(EntityPredicateTooltip.key("distance.absolute"), useAnd, absolute, state, distanceBuilder);
        }
        builder.component(distanceBuilder.build());
    }

    public static void addMovementPredicateToBuilder(class_638 level, class_9750 predicate, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
        class_2096.class_2099 x = predicate.comp_2772();
        class_2096.class_2099 y = predicate.comp_2773();
        class_2096.class_2099 z = predicate.comp_2774();
        class_2096.class_2099 horizontalSpeed = predicate.comp_2776();
        class_2096.class_2099 verticalSpeed = predicate.comp_2777();
        class_2096.class_2099 speed = predicate.comp_2775();
        class_2096.class_2099 fallDistance = predicate.comp_2778();
        CompositeContainerComponent.Builder movementBuilder = CompositeContainerComponent.builder();
        boolean useAnd = false;
        if (!x.method_9041()) {
            PredicateTooltip.addMinMaxToBuilder(EntityPredicateTooltip.key("movement.x"), false, x, state, movementBuilder);
            useAnd = true;
        }
        if (!y.method_9041()) {
            PredicateTooltip.addMinMaxToBuilder(EntityPredicateTooltip.key("movement.y"), useAnd, y, state, movementBuilder);
            useAnd = true;
        }
        if (!z.method_9041()) {
            PredicateTooltip.addMinMaxToBuilder(EntityPredicateTooltip.key("movement.z"), useAnd, z, state, movementBuilder);
            useAnd = true;
        }
        if (!horizontalSpeed.method_9041()) {
            PredicateTooltip.addMinMaxToBuilder(EntityPredicateTooltip.key("movement.horizontal_speed"), useAnd, horizontalSpeed, state, movementBuilder);
            useAnd = true;
        }
        if (!verticalSpeed.method_9041()) {
            PredicateTooltip.addMinMaxToBuilder(EntityPredicateTooltip.key("movement.vertical_speed"), useAnd, verticalSpeed, state, movementBuilder);
            useAnd = true;
        }
        if (!speed.method_9041()) {
            PredicateTooltip.addMinMaxToBuilder(EntityPredicateTooltip.key("movement.speed"), useAnd, speed, state, movementBuilder);
            useAnd = true;
        }
        if (!fallDistance.method_9041()) {
            PredicateTooltip.addMinMaxToBuilder(EntityPredicateTooltip.key("movement.fall_distance"), useAnd, fallDistance, state, movementBuilder);
        }
        builder.component(movementBuilder.build());
    }

    public static void addLocationPredicateToBuilder(class_638 level, class_2090 predicate, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
        LocationPredicateTooltip.addToBuilder(level, predicate, state, builder);
    }

    public static void addMobEffectsPredicateToBuilder(class_638 level, class_2102 predicate, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
        Map effectMap = predicate.comp_1811();
        if (effectMap.isEmpty()) {
            builder.space().translate(EntityPredicateTooltip.key("effects.any"), Styler::value, new Object[0]);
        } else {
            class_2378 registry = VRegistry.get(level, class_7924.field_41208);
            CompositeContainerComponent.Builder effectsBuilder = CompositeContainerComponent.builder().space();
            if (effectMap.size() == 1) {
                effectsBuilder.translate(EntityPredicateTooltip.key("effects.single"), Styler::condition, new Object[0]);
            } else {
                effectsBuilder.translate(EntityPredicateTooltip.key("effects.all_of"), Styler::condition, new Object[0]);
            }
            effectsBuilder.space().cycle(effectCycler -> effectMap.forEach((effectHolder, effectInstancePredicate) -> {
                CompositeContainerComponent effectConditions;
                class_2096.class_2100 duration;
                class_2096.class_2100 amplifier;
                Optional visible;
                class_1291 effect = (class_1291)effectHolder.method_40229().map(arg_0 -> ((class_2378)registry).method_31140(arg_0), Function.identity());
                CompositeBuilder effectBuilder = CompositeContainerComponent.builder().translate(EntityPredicateTooltip.key("effects.effect"), Styler::condition, new Object[]{Styler.name(effect.method_5560().method_27661())});
                CompositeContainerComponent.Builder conditionBuilder = CompositeContainerComponent.builder();
                boolean useAnd = false;
                Optional ambient = effectInstancePredicate.comp_1814();
                if (ambient.isPresent()) {
                    conditionBuilder.translate(EntityPredicateTooltip.key("effects.ambient.%s".formatted((Boolean)ambient.orElseThrow() != false ? "true" : "false")), Styler::value, new Object[0]);
                    useAnd = true;
                }
                if ((visible = effectInstancePredicate.comp_1815()).isPresent()) {
                    if (useAnd) {
                        conditionBuilder.literal(", ", Styler::condition);
                    }
                    conditionBuilder.translate(EntityPredicateTooltip.key("effects.visible.%s".formatted((Boolean)visible.orElseThrow() != false ? "true" : "false")), Styler::value, new Object[0]);
                    useAnd = true;
                }
                if (!(amplifier = effectInstancePredicate.comp_1812()).method_9041()) {
                    if (useAnd) {
                        conditionBuilder.literal(", ", Styler::condition);
                    }
                    PredicateTooltip.addMinMaxToBuilder(EntityPredicateTooltip.key("effects.amplifier"), false, amplifier, value -> class_2561.method_43471((String)"enchantment.level.%s".formatted("%.0f".formatted(value + 1.0))), state, conditionBuilder);
                    useAnd = true;
                }
                if (!(duration = effectInstancePredicate.comp_1813()).method_9041()) {
                    if (useAnd) {
                        conditionBuilder.literal(", ", Styler::condition);
                    }
                    PredicateTooltip.addMinMaxToBuilder(EntityPredicateTooltip.key("effects.duration"), false, duration, i -> Formatter.decimal(i * 20.0), state, conditionBuilder);
                }
                if (!(effectConditions = conditionBuilder.build()).isEmpty()) {
                    ((CompositeContainerComponent.Builder)((CompositeContainerComponent.Builder)effectBuilder).literal(" (", Styler::condition)).component(effectConditions).literal(")", Styler::condition);
                }
                effectCycler.component(((CompositeContainerComponent.Builder)effectBuilder).build());
            }));
            builder.component(effectsBuilder.build());
        }
    }

    public static void addNbtPredicateToBuilder(class_638 level, String key, class_2105 predicate, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
        builder.component(((CompositeContainerComponent.Builder)CompositeContainerComponent.builder().space().translate(key, Styler::condition, new Object[]{Styler.value(class_2561.method_43470((String)predicate.comp_1816().toString()))})).build());
    }

    public static void addEntityFlagsPredicateToBuilder(class_638 level, class_2040 predicate, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
        Map<String, Optional> flagMap = Map.of("on_ground", predicate.comp_2666(), "on_fire", predicate.comp_1756(), "crouching", predicate.comp_1757(), "sprinting", predicate.comp_1758(), "swimming", predicate.comp_1759(), "flying", predicate.comp_2667(), "baby", predicate.comp_1760());
        CompositeContainerComponent.Builder flagsBuilder = CompositeContainerComponent.builder().space();
        boolean useAnd = false;
        for (Map.Entry<String, Optional> entry : flagMap.entrySet()) {
            if (!entry.getValue().isPresent()) continue;
            if (useAnd) {
                flagsBuilder.literal(" & ", Styler::condition);
            }
            flagsBuilder.translate(EntityPredicateTooltip.key("flags.%s.%s".formatted(entry.getKey(), (Boolean)entry.getValue().orElseThrow() != false ? "true" : "false")), Styler::value, new Object[0]);
            useAnd = true;
        }
    }

    public static void addEntityEquipmentPredicateToBuilder(class_638 level, class_3735 predicate, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
        Map<class_1304, Optional> equipmentMap = Map.of(class_1304.field_6169, predicate.comp_1750(), class_1304.field_6174, predicate.comp_1751(), class_1304.field_6172, predicate.comp_1752(), class_1304.field_6166, predicate.comp_1753(), class_1304.field_6173, predicate.comp_1754(), class_1304.field_6171, predicate.comp_1755());
        List<CompositeContainerComponent> equipmentComponents = equipmentMap.entrySet().stream().map(entry -> {
            class_1304 slot = (class_1304)entry.getKey();
            Optional itemPredicate = (Optional)entry.getValue();
            if (itemPredicate.isEmpty()) {
                return null;
            }
            CompositeBuilder itemBuilder = CompositeContainerComponent.builder().translate(EntityPredicateTooltip.key("equipment.item"), Styler::condition, new Object[0]);
            ItemPredicateTooltip.addToBuilder(level, (class_2073)itemPredicate.orElseThrow(), new LootConditionTooltips.State().withUseWith(true), (CompositeContainerComponent.Builder)itemBuilder);
            class_5250 slotName = Styler.name(class_2561.method_43470((String)StringUtils.capitalize((String)slot.method_5923())));
            ((CompositeContainerComponent.Builder)itemBuilder).space().translate(EntityPredicateTooltip.key("equipment.slot"), Styler::condition, new Object[]{slotName});
            return ((CompositeContainerComponent.Builder)itemBuilder).build();
        }).filter(Objects::nonNull).toList();
        CompositeContainerComponent.Builder equipmentComponentBuilder = CompositeContainerComponent.builder();
        if (equipmentComponents.size() == 1) {
            equipmentComponentBuilder.translate(EntityPredicateTooltip.key("equipment.single"), Styler::condition, new Object[0]);
            equipmentComponentBuilder.space().component(equipmentComponents.getFirst());
        } else if (equipmentComponents.size() > 1) {
            equipmentComponentBuilder.vertical().translate(EntityPredicateTooltip.key("equipment.all_of"), Styler::condition, new Object[0]);
            CompositeContainerComponent.Builder entryBuilder = CompositeContainerComponent.builder().vertical();
            equipmentComponents.forEach(entry -> entryBuilder.component(((CompositeContainerComponent.Builder)CompositeContainerComponent.builder().literal("\u2022 ", Styler::condition)).component((class_5684)entry).build()));
            equipmentComponentBuilder.component(entryBuilder.build());
        }
        CompositeContainerComponent.Builder equipmentBuilder = ((CompositeContainerComponent.Builder)CompositeContainerComponent.builder().space().translate(EntityPredicateTooltip.key("equipment.matches"), Styler::condition, new Object[0])).space().component(equipmentComponentBuilder.build());
        builder.component(equipmentBuilder.build());
    }

    public static void addEntitySubPredicateToBuilder(class_638 level, class_7376 predicate, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
        EntitySubPredicateTooltip.addToBuilder(level, predicate, state, builder);
    }

    public static void addPeriodicTickToBuilder(class_638 level, int tick, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
        builder.component(CompositeContainerComponent.builder().space().translate(EntityPredicateTooltip.key("periodic_tick"), Styler.number(tick)).build());
    }

    public static void addEntityPredicateToBuilder(class_638 level, String label, class_2048 predicate, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
        CompositeContainerComponent.Builder entityBuilder = ((CompositeContainerComponent.Builder)CompositeContainerComponent.builder().translate(EntityPredicateTooltip.key("%s.matches".formatted(label)), Styler::condition, new Object[0])).space();
        EntityPredicateTooltip.addToBuilder(level, predicate, state, entityBuilder);
        builder.component(entityBuilder.build());
    }

    public static void addTeamToBuilder(class_638 level, String team, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
        builder.component(CompositeContainerComponent.builder().space().translate(EntityPredicateTooltip.key("team"), Styler.name(class_2561.method_43470((String)team))).build());
    }

    public static void addSlotsPredicateToBuilder(class_638 level, class_9350 predicate, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
        Map slots = predicate.comp_2455();
        CompositeContainerComponent.Builder slotsBuilder = ((CompositeContainerComponent.Builder)CompositeContainerComponent.builder().space().translate(EntityPredicateTooltip.key("slots.matches"), Styler::condition, new Object[0])).space().cycle(slotCycler -> slots.forEach((slotRange, itemPredicate) -> {
            IntList slotsList = slotRange.method_58075();
            if (slotsList.isEmpty()) {
                return;
            }
            for (int i = 0; i < slotsList.size(); ++i) {
                int slot = slotsList.getInt(i);
                CompositeContainerComponent.Builder slotBuilder = ((CompositeContainerComponent.Builder)CompositeContainerComponent.builder().translate(EntityPredicateTooltip.key("slots.slot"), Styler::condition, new Object[]{Styler.number(slot)})).space();
                ItemPredicateTooltip.addToBuilder(level, itemPredicate, new LootConditionTooltips.State(), slotBuilder);
                slotCycler.component(slotBuilder.build());
            }
        }));
        builder.component(slotsBuilder.build());
    }
}

