/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.bettertrims.client.tooltip.component;

import com.bawnorton.bettertrims.client.tooltip.component.DynamicWidthComponent;
import java.util.function.Supplier;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;

public record ConditionalComponent(ClientTooltipComponent ifTrue, ClientTooltipComponent ifFalse, Supplier<Boolean> checker) implements DynamicWidthComponent
{
    public int getHeight(Font font) {
        return this.checker.get() != false ? this.ifTrue.getHeight(font) : this.ifFalse.getHeight(font);
    }

    public int getWidth(Font font) {
        return this.checker.get() != false ? this.ifTrue.getWidth(font) : this.ifFalse.getWidth(font);
    }

    public void renderText(GuiGraphics guiGraphics, Font font, int x, int y) {
        if (this.checker.get().booleanValue()) {
            this.ifTrue.renderText(guiGraphics, font, x, y);
        } else {
            this.ifFalse.renderText(guiGraphics, font, x, y);
        }
    }

    public void renderImage(Font font, int x, int y, int width, int height, GuiGraphics guiGraphics) {
        if (this.checker.get().booleanValue()) {
            this.ifTrue.renderImage(font, x, y, width, height, guiGraphics);
        } else {
            this.ifFalse.renderImage(font, x, y, width, height, guiGraphics);
        }
    }

    public boolean showTooltipWithItemInHand() {
        return this.checker.get() != false && this.ifTrue.showTooltipWithItemInHand() || this.checker.get() == false && this.ifFalse.showTooltipWithItemInHand();
    }

    @Override
    public int getMaxWidth(Font font) {
        int maxWidth = 0;
        ClientTooltipComponent clientTooltipComponent = this.ifTrue;
        if (clientTooltipComponent instanceof DynamicWidthComponent) {
            DynamicWidthComponent dynamic = (DynamicWidthComponent)clientTooltipComponent;
            maxWidth = Math.max(maxWidth, dynamic.getMaxWidth(font));
        } else {
            maxWidth = Math.max(maxWidth, this.ifTrue.getWidth(font));
        }
        return maxWidth;
    }

    @Override
    public int getMinWidth(Font font) {
        int minWidth = Integer.MAX_VALUE;
        ClientTooltipComponent clientTooltipComponent = this.ifTrue;
        if (clientTooltipComponent instanceof DynamicWidthComponent) {
            DynamicWidthComponent dynamic = (DynamicWidthComponent)clientTooltipComponent;
            minWidth = Math.min(minWidth, dynamic.getMinWidth(font));
        } else {
            minWidth = Math.min(minWidth, this.ifTrue.getWidth(font));
        }
        return minWidth;
    }
}

