/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.bettertrims.client.tooltip.condition.predicate;

import com.bawnorton.bettertrims.client.tooltip.component.CompositeBuilder;
import com.bawnorton.bettertrims.client.tooltip.component.CompositeContainerComponent;
import com.bawnorton.bettertrims.client.tooltip.condition.LootConditionTooltips;
import com.bawnorton.bettertrims.client.tooltip.condition.predicate.EntitySubPredicateTooltip;
import com.bawnorton.bettertrims.client.tooltip.condition.predicate.ItemPredicateTooltip;
import com.bawnorton.bettertrims.client.tooltip.condition.predicate.LocationPredicateTooltip;
import com.bawnorton.bettertrims.client.tooltip.condition.predicate.PredicateTooltip;
import com.bawnorton.bettertrims.client.tooltip.condition.predicate.data.DataComponentMatchersTooltip;
import com.bawnorton.bettertrims.client.tooltip.util.Formatter;
import com.bawnorton.bettertrims.client.tooltip.util.Styler;
import com.bawnorton.bettertrims.version.VRegistry;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.advancements.critereon.DataComponentMatchers;
import net.minecraft.advancements.critereon.DistancePredicate;
import net.minecraft.advancements.critereon.EntityEquipmentPredicate;
import net.minecraft.advancements.critereon.EntityFlagsPredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.EntitySubPredicate;
import net.minecraft.advancements.critereon.EntityTypePredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.MobEffectsPredicate;
import net.minecraft.advancements.critereon.MovementPredicate;
import net.minecraft.advancements.critereon.NbtPredicate;
import net.minecraft.advancements.critereon.SlotsPredicate;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import org.apache.commons.lang3.StringUtils;

public interface EntityPredicateTooltip {
    public static void addToBuilder(ClientLevel level, EntityPredicate predicate, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
        DataComponentMatchers components;
        Optional slots;
        Optional team;
        Optional targetedEntity;
        Optional passenger;
        Optional vehicle;
        Optional periodicTick;
        Optional subPredicate;
        Optional equipment;
        Optional flags;
        Optional nbt;
        Optional effects;
        Optional affectsMovement;
        Optional steppingOn;
        EntityPredicate.LocationWrapper location;
        Optional located;
        Optional movement;
        Optional distancePredicate;
        Optional entityTypePredicate = predicate.entityType();
        if (entityTypePredicate.isPresent()) {
            EntityPredicateTooltip.addEntityTypePredicateToBuilder(level, (EntityTypePredicate)entityTypePredicate.orElseThrow(), state, builder);
        }
        if ((distancePredicate = predicate.distanceToPlayer()).isPresent()) {
            EntityPredicateTooltip.addDistancePredicateToBuilder(level, (DistancePredicate)distancePredicate.orElseThrow(), state, builder);
        }
        if ((movement = predicate.movement()).isPresent()) {
            EntityPredicateTooltip.addMovementPredicateToBuilder(level, (MovementPredicate)movement.orElseThrow(), state, builder);
        }
        if ((located = (location = predicate.location()).located()).isPresent()) {
            EntityPredicateTooltip.addLocationPredicateToBuilder(level, (LocationPredicate)located.orElseThrow(), state, builder);
        }
        if ((steppingOn = location.steppingOn()).isPresent()) {
            EntityPredicateTooltip.addLocationPredicateToBuilder(level, (LocationPredicate)steppingOn.orElseThrow(), state, builder);
        }
        if ((affectsMovement = location.affectsMovement()).isPresent()) {
            EntityPredicateTooltip.addLocationPredicateToBuilder(level, (LocationPredicate)affectsMovement.orElseThrow(), state, builder);
        }
        if ((effects = predicate.effects()).isPresent()) {
            EntityPredicateTooltip.addMobEffectsPredicateToBuilder(level, (MobEffectsPredicate)effects.orElseThrow(), state, builder);
        }
        if ((nbt = predicate.nbt()).isPresent()) {
            EntityPredicateTooltip.addNbtPredicateToBuilder(level, EntityPredicateTooltip.key("nbt"), (NbtPredicate)nbt.orElseThrow(), state, builder);
        }
        if ((flags = predicate.flags()).isPresent()) {
            EntityPredicateTooltip.addEntityFlagsPredicateToBuilder(level, (EntityFlagsPredicate)flags.orElseThrow(), state, builder);
        }
        if ((equipment = predicate.equipment()).isPresent()) {
            EntityPredicateTooltip.addEntityEquipmentPredicateToBuilder(level, (EntityEquipmentPredicate)equipment.orElseThrow(), state, builder);
        }
        if ((subPredicate = predicate.subPredicate()).isPresent()) {
            EntityPredicateTooltip.addEntitySubPredicateToBuilder(level, (EntitySubPredicate)subPredicate.orElseThrow(), state, builder);
        }
        if ((periodicTick = predicate.periodicTick()).isPresent()) {
            EntityPredicateTooltip.addPeriodicTickToBuilder(level, (Integer)periodicTick.orElseThrow(), state, builder);
        }
        if ((vehicle = predicate.vehicle()).isPresent()) {
            EntityPredicateTooltip.addEntityPredicateToBuilder(level, "vehicle", (EntityPredicate)vehicle.orElseThrow(), state, builder);
        }
        if ((passenger = predicate.passenger()).isPresent()) {
            EntityPredicateTooltip.addEntityPredicateToBuilder(level, "passenger", (EntityPredicate)passenger.orElseThrow(), state, builder);
        }
        if ((targetedEntity = predicate.targetedEntity()).isPresent()) {
            EntityPredicateTooltip.addEntityPredicateToBuilder(level, "targeted_entity", (EntityPredicate)targetedEntity.orElseThrow(), state, builder);
        }
        if ((team = predicate.team()).isPresent()) {
            EntityPredicateTooltip.addTeamToBuilder(level, (String)team.orElseThrow(), state, builder);
        }
        if ((slots = predicate.slots()).isPresent()) {
            EntityPredicateTooltip.addSlotsPredicateToBuilder(level, (SlotsPredicate)slots.orElseThrow(), state, builder);
        }
        if (!(components = predicate.components()).isEmpty()) {
            EntityPredicateTooltip.addDataComponentMatchersToBuilder(level, components, state, builder);
        }
    }

    public static String key(String key) {
        return PredicateTooltip.key("entity.%s".formatted(key));
    }

    public static void addEntityTypePredicateToBuilder(ClientLevel level, EntityTypePredicate predicate, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
        PredicateTooltip.addRegisteredElementsToBuilder(level, EntityPredicateTooltip.key("matches"), Registries.ENTITY_TYPE, predicate.types(), EntityType::getDescription, state, builder);
    }

    public static void addDistancePredicateToBuilder(ClientLevel level, DistancePredicate predicate, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
        MinMaxBounds.Doubles x = predicate.x();
        MinMaxBounds.Doubles y = predicate.y();
        MinMaxBounds.Doubles z = predicate.z();
        MinMaxBounds.Doubles horizontal = predicate.horizontal();
        MinMaxBounds.Doubles absolute = predicate.absolute();
        CompositeContainerComponent.Builder distanceBuilder = CompositeContainerComponent.builder().space().translate(EntityPredicateTooltip.key("distance"), new Object[0]).space();
        boolean useAnd = false;
        if (!x.isAny()) {
            PredicateTooltip.addMinMaxToBuilder(EntityPredicateTooltip.key("distance.x"), false, x, state, distanceBuilder);
            useAnd = true;
        }
        if (!y.isAny()) {
            PredicateTooltip.addMinMaxToBuilder(EntityPredicateTooltip.key("distance.y"), useAnd, y, state, distanceBuilder);
            useAnd = true;
        }
        if (!z.isAny()) {
            PredicateTooltip.addMinMaxToBuilder(EntityPredicateTooltip.key("distance.z"), useAnd, z, state, distanceBuilder);
            useAnd = true;
        }
        if (!horizontal.isAny()) {
            PredicateTooltip.addMinMaxToBuilder(EntityPredicateTooltip.key("distance.horizontal"), useAnd, horizontal, state, distanceBuilder);
            useAnd = true;
        }
        if (!absolute.isAny()) {
            PredicateTooltip.addMinMaxToBuilder(EntityPredicateTooltip.key("distance.absolute"), useAnd, absolute, state, distanceBuilder);
        }
        builder.component(distanceBuilder.build());
    }

    public static void addMovementPredicateToBuilder(ClientLevel level, MovementPredicate predicate, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
        MinMaxBounds.Doubles x = predicate.x();
        MinMaxBounds.Doubles y = predicate.y();
        MinMaxBounds.Doubles z = predicate.z();
        MinMaxBounds.Doubles horizontalSpeed = predicate.horizontalSpeed();
        MinMaxBounds.Doubles verticalSpeed = predicate.verticalSpeed();
        MinMaxBounds.Doubles speed = predicate.speed();
        MinMaxBounds.Doubles fallDistance = predicate.fallDistance();
        CompositeContainerComponent.Builder movementBuilder = CompositeContainerComponent.builder();
        boolean useAnd = false;
        if (!x.isAny()) {
            PredicateTooltip.addMinMaxToBuilder(EntityPredicateTooltip.key("movement.x"), false, x, state, movementBuilder);
            useAnd = true;
        }
        if (!y.isAny()) {
            PredicateTooltip.addMinMaxToBuilder(EntityPredicateTooltip.key("movement.y"), useAnd, y, state, movementBuilder);
            useAnd = true;
        }
        if (!z.isAny()) {
            PredicateTooltip.addMinMaxToBuilder(EntityPredicateTooltip.key("movement.z"), useAnd, z, state, movementBuilder);
            useAnd = true;
        }
        if (!horizontalSpeed.isAny()) {
            PredicateTooltip.addMinMaxToBuilder(EntityPredicateTooltip.key("movement.horizontal_speed"), useAnd, horizontalSpeed, state, movementBuilder);
            useAnd = true;
        }
        if (!verticalSpeed.isAny()) {
            PredicateTooltip.addMinMaxToBuilder(EntityPredicateTooltip.key("movement.vertical_speed"), useAnd, verticalSpeed, state, movementBuilder);
            useAnd = true;
        }
        if (!speed.isAny()) {
            PredicateTooltip.addMinMaxToBuilder(EntityPredicateTooltip.key("movement.speed"), useAnd, speed, state, movementBuilder);
            useAnd = true;
        }
        if (!fallDistance.isAny()) {
            PredicateTooltip.addMinMaxToBuilder(EntityPredicateTooltip.key("movement.fall_distance"), useAnd, fallDistance, state, movementBuilder);
        }
        builder.component(movementBuilder.build());
    }

    public static void addLocationPredicateToBuilder(ClientLevel level, LocationPredicate predicate, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
        LocationPredicateTooltip.addToBuilder(level, predicate, state, builder);
    }

    public static void addMobEffectsPredicateToBuilder(ClientLevel level, MobEffectsPredicate predicate, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
        Map effectMap = predicate.effectMap();
        if (effectMap.isEmpty()) {
            builder.space().translate(EntityPredicateTooltip.key("effects.any"), Styler::value, new Object[0]);
        } else {
            Registry registry = VRegistry.get(level, Registries.MOB_EFFECT);
            CompositeContainerComponent.Builder effectsBuilder = CompositeContainerComponent.builder().space();
            if (effectMap.size() == 1) {
                effectsBuilder.translate(EntityPredicateTooltip.key("effects.single"), Styler::condition, new Object[0]);
            } else {
                effectsBuilder.translate(EntityPredicateTooltip.key("effects.all_of"), Styler::condition, new Object[0]);
            }
            effectsBuilder.space().cycle(effectCycler -> effectMap.forEach((effectHolder, effectInstancePredicate) -> {
                CompositeContainerComponent effectConditions;
                MinMaxBounds.Ints duration;
                MinMaxBounds.Ints amplifier;
                Optional visible;
                MobEffect effect = (MobEffect)effectHolder.unwrap().map(arg_0 -> ((Registry)registry).getValueOrThrow(arg_0), Function.identity());
                CompositeBuilder effectBuilder = CompositeContainerComponent.builder().translate(EntityPredicateTooltip.key("effects.effect"), Styler::condition, new Object[]{Styler.name(effect.getDisplayName().copy())});
                CompositeContainerComponent.Builder conditionBuilder = CompositeContainerComponent.builder();
                boolean useAnd = false;
                Optional ambient = effectInstancePredicate.ambient();
                if (ambient.isPresent()) {
                    conditionBuilder.translate(EntityPredicateTooltip.key("effects.ambient.%s".formatted((Boolean)ambient.orElseThrow() != false ? "true" : "false")), Styler::value, new Object[0]);
                    useAnd = true;
                }
                if ((visible = effectInstancePredicate.visible()).isPresent()) {
                    if (useAnd) {
                        conditionBuilder.literal(", ", Styler::condition);
                    }
                    conditionBuilder.translate(EntityPredicateTooltip.key("effects.visible.%s".formatted((Boolean)visible.orElseThrow() != false ? "true" : "false")), Styler::value, new Object[0]);
                    useAnd = true;
                }
                if (!(amplifier = effectInstancePredicate.amplifier()).isAny()) {
                    if (useAnd) {
                        conditionBuilder.literal(", ", Styler::condition);
                    }
                    PredicateTooltip.addMinMaxToBuilder(EntityPredicateTooltip.key("effects.amplifier"), false, amplifier, value -> Component.translatable((String)"enchantment.level.%s".formatted("%.0f".formatted(value + 1.0))), state, conditionBuilder);
                    useAnd = true;
                }
                if (!(duration = effectInstancePredicate.duration()).isAny()) {
                    if (useAnd) {
                        conditionBuilder.literal(", ", Styler::condition);
                    }
                    PredicateTooltip.addMinMaxToBuilder(EntityPredicateTooltip.key("effects.duration"), false, duration, i -> Formatter.decimal(i * 20.0), state, conditionBuilder);
                }
                if (!(effectConditions = conditionBuilder.build()).isEmpty()) {
                    ((CompositeContainerComponent.Builder)((CompositeContainerComponent.Builder)effectBuilder).literal(" (", Styler::condition)).component(effectConditions).literal(")", Styler::condition);
                }
                effectCycler.component(((CompositeContainerComponent.Builder)effectBuilder).build());
            }));
            builder.component(effectsBuilder.build());
        }
    }

    public static void addNbtPredicateToBuilder(ClientLevel level, String key, NbtPredicate predicate, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
        builder.component(((CompositeContainerComponent.Builder)CompositeContainerComponent.builder().space().translate(key, Styler::condition, new Object[]{Styler.value(Component.literal((String)predicate.tag().toString()))})).build());
    }

    public static void addEntityFlagsPredicateToBuilder(ClientLevel level, EntityFlagsPredicate predicate, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
        Map<String, Optional> flagMap = Map.of("on_ground", predicate.isOnGround(), "on_fire", predicate.isOnFire(), "crouching", predicate.isCrouching(), "sprinting", predicate.isSprinting(), "swimming", predicate.isSwimming(), "flying", predicate.isFlying(), "baby", predicate.isBaby());
        CompositeContainerComponent.Builder flagsBuilder = CompositeContainerComponent.builder().space();
        boolean useAnd = false;
        for (Map.Entry<String, Optional> entry : flagMap.entrySet()) {
            if (!entry.getValue().isPresent()) continue;
            if (useAnd) {
                flagsBuilder.literal(" & ", Styler::condition);
            }
            flagsBuilder.translate(EntityPredicateTooltip.key("flags.%s.%s".formatted(entry.getKey(), (Boolean)entry.getValue().orElseThrow() != false ? "true" : "false")), Styler::value, new Object[0]);
            useAnd = true;
        }
    }

    public static void addEntityEquipmentPredicateToBuilder(ClientLevel level, EntityEquipmentPredicate predicate, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
        Map<EquipmentSlot, Optional> equipmentMap = Map.of(EquipmentSlot.HEAD, predicate.head(), EquipmentSlot.CHEST, predicate.chest(), EquipmentSlot.LEGS, predicate.legs(), EquipmentSlot.FEET, predicate.feet(), EquipmentSlot.MAINHAND, predicate.mainhand(), EquipmentSlot.OFFHAND, predicate.offhand());
        List<CompositeContainerComponent> equipmentComponents = equipmentMap.entrySet().stream().map(entry -> {
            EquipmentSlot slot = (EquipmentSlot)entry.getKey();
            Optional itemPredicate = (Optional)entry.getValue();
            if (itemPredicate.isEmpty()) {
                return null;
            }
            CompositeBuilder itemBuilder = CompositeContainerComponent.builder().translate(EntityPredicateTooltip.key("equipment.item"), Styler::condition, new Object[0]);
            ItemPredicateTooltip.addToBuilder(level, (ItemPredicate)itemPredicate.orElseThrow(), new LootConditionTooltips.State().withUseWith(true), (CompositeContainerComponent.Builder)itemBuilder);
            MutableComponent slotName = Styler.name(Component.literal((String)StringUtils.capitalize((String)slot.getName())));
            ((CompositeContainerComponent.Builder)itemBuilder).space().translate(EntityPredicateTooltip.key("equipment.slot"), Styler::condition, new Object[]{slotName});
            return ((CompositeContainerComponent.Builder)itemBuilder).build();
        }).filter(Objects::nonNull).toList();
        CompositeContainerComponent.Builder equipmentComponentBuilder = CompositeContainerComponent.builder();
        if (equipmentComponents.size() == 1) {
            equipmentComponentBuilder.translate(EntityPredicateTooltip.key("equipment.single"), Styler::condition, new Object[0]);
            equipmentComponentBuilder.space().component(equipmentComponents.getFirst());
        } else if (equipmentComponents.size() > 1) {
            equipmentComponentBuilder.vertical().translate(EntityPredicateTooltip.key("equipment.all_of"), Styler::condition, new Object[0]);
            CompositeContainerComponent.Builder entryBuilder = CompositeContainerComponent.builder().vertical();
            equipmentComponents.forEach(entry -> entryBuilder.component(((CompositeContainerComponent.Builder)CompositeContainerComponent.builder().literal("\u2022 ", Styler::condition)).component((ClientTooltipComponent)entry).build()));
            equipmentComponentBuilder.component(entryBuilder.build());
        }
        CompositeContainerComponent.Builder equipmentBuilder = ((CompositeContainerComponent.Builder)CompositeContainerComponent.builder().space().translate(EntityPredicateTooltip.key("equipment.matches"), Styler::condition, new Object[0])).space().component(equipmentComponentBuilder.build());
        builder.component(equipmentBuilder.build());
    }

    public static void addEntitySubPredicateToBuilder(ClientLevel level, EntitySubPredicate predicate, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
        EntitySubPredicateTooltip.addToBuilder(level, predicate, state, builder);
    }

    public static void addPeriodicTickToBuilder(ClientLevel level, int tick, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
        builder.component(CompositeContainerComponent.builder().space().translate(EntityPredicateTooltip.key("periodic_tick"), Styler.number(tick)).build());
    }

    public static void addEntityPredicateToBuilder(ClientLevel level, String label, EntityPredicate predicate, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
        CompositeContainerComponent.Builder entityBuilder = ((CompositeContainerComponent.Builder)CompositeContainerComponent.builder().translate(EntityPredicateTooltip.key("%s.matches".formatted(label)), Styler::condition, new Object[0])).space();
        EntityPredicateTooltip.addToBuilder(level, predicate, state, entityBuilder);
        builder.component(entityBuilder.build());
    }

    public static void addTeamToBuilder(ClientLevel level, String team, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
        builder.component(CompositeContainerComponent.builder().space().translate(EntityPredicateTooltip.key("team"), Styler.name(Component.literal((String)team))).build());
    }

    public static void addSlotsPredicateToBuilder(ClientLevel level, SlotsPredicate predicate, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
        Map slots = predicate.slots();
        CompositeContainerComponent.Builder slotsBuilder = ((CompositeContainerComponent.Builder)CompositeContainerComponent.builder().space().translate(EntityPredicateTooltip.key("slots.matches"), Styler::condition, new Object[0])).space().cycle(slotCycler -> slots.forEach((slotRange, itemPredicate) -> {
            IntList slotsList = slotRange.slots();
            if (slotsList.isEmpty()) {
                return;
            }
            for (int i = 0; i < slotsList.size(); ++i) {
                int slot = slotsList.getInt(i);
                CompositeContainerComponent.Builder slotBuilder = ((CompositeContainerComponent.Builder)CompositeContainerComponent.builder().translate(EntityPredicateTooltip.key("slots.slot"), Styler::condition, new Object[]{Styler.number(slot)})).space();
                ItemPredicateTooltip.addToBuilder(level, itemPredicate, new LootConditionTooltips.State(), slotBuilder);
                slotCycler.component(slotBuilder.build());
            }
        }));
        builder.component(slotsBuilder.build());
    }

    public static void addDataComponentMatchersToBuilder(ClientLevel level, DataComponentMatchers components, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
        DataComponentMatchersTooltip.addToBuilder(level, components, state, builder);
    }
}

