/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.bettertrims.client.tooltip.condition.predicate.data.exact;

import com.bawnorton.bettertrims.client.tooltip.component.CompositeBuilder;
import com.bawnorton.bettertrims.client.tooltip.component.CompositeContainerComponent;
import com.bawnorton.bettertrims.client.tooltip.condition.LootConditionTooltips;
import com.bawnorton.bettertrims.client.tooltip.condition.predicate.data.exact.ExactAdder;
import com.bawnorton.bettertrims.client.tooltip.util.Styler;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.HolderSet;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.component.Tool;

public final class ToolExactAdder
implements ExactAdder<Tool> {
    @Override
    public void addToBuilder(ClientLevel level, Tool tool, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
        boolean canDestroyBlocksInCreative = tool.canDestroyBlocksInCreative();
        int damagePerBlock = tool.damagePerBlock();
        float defaultMiningSpeed = tool.defaultMiningSpeed();
        List rules = tool.rules();
        CompositeBuilder toolBuilder = ((CompositeContainerComponent.Builder)((CompositeContainerComponent.Builder)CompositeContainerComponent.builder().space().translate(this.key("tool"), Styler::condition, new Object[0])).space().translate(this.key("tool.damage_per_block"), Styler::condition, new Object[]{Styler.number(damagePerBlock)})).space().translate(this.key("tool.default_mining_speed"), Styler::condition, new Object[]{Styler.number(Float.valueOf(defaultMiningSpeed))});
        if (canDestroyBlocksInCreative) {
            ((CompositeContainerComponent.Builder)toolBuilder).space().translate(this.key("tool.can_destroy_blocks_in_creative"), Styler::condition, new Object[0]);
        }
        if (!rules.isEmpty()) {
            ((CompositeContainerComponent.Builder)((CompositeContainerComponent.Builder)toolBuilder).space().translate(this.key("tool.rules"), Styler::condition, new Object[0])).space().cycle(cycleBuilder -> {
                for (Tool.Rule rule : rules) {
                    HolderSet blocks = rule.blocks();
                    Optional blockTagKey = blocks.unwrapKey();
                    Optional speed = rule.speed();
                    Optional correctForDrops = rule.correctForDrops();
                    CompositeContainerComponent.Builder ruleBuilder = ((CompositeContainerComponent.Builder)CompositeContainerComponent.builder().translate(this.key("tool.rule"), Styler::condition, new Object[0])).spaced();
                    if (blockTagKey.isPresent()) {
                        ResourceLocation tag = ((TagKey)blockTagKey.orElseThrow()).location();
                        ruleBuilder.translate(this.key("tool.rule.tag"), Styler::condition, new Object[]{Styler.name(Component.literal((String)tag.toString()))});
                    }
                    if (speed.isPresent()) {
                        ruleBuilder.space().translate(this.key("tool.rule.speed"), Styler::condition, new Object[]{Styler.number((Number)speed.orElseThrow())});
                    }
                    if (correctForDrops.isPresent() && correctForDrops.orElse(false).booleanValue()) {
                        ruleBuilder.space().translate(this.key("tool.rule.correct_for_drops"), Styler::condition, new Object[0]);
                    }
                    if (ruleBuilder.build().isEmpty()) continue;
                    cycleBuilder.component(ruleBuilder.build());
                }
            });
        }
    }
}

