/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.bettertrims.client.tooltip.element;

import com.bawnorton.bettertrims.client.tooltip.element.TrimElementTooltipProvider;
import com.bawnorton.bettertrims.property.AllOf;
import com.bawnorton.bettertrims.property.ability.type.entity.ApplyMobEffectAbility;
import com.bawnorton.bettertrims.property.ability.type.entity.ChangeItemDamageAbility;
import com.bawnorton.bettertrims.property.ability.type.entity.DamageEntityAbility;
import com.bawnorton.bettertrims.property.ability.type.entity.ExplodeAbility;
import com.bawnorton.bettertrims.property.ability.type.entity.IgniteAbility;
import com.bawnorton.bettertrims.property.ability.type.entity.PlaySoundAbility;
import com.bawnorton.bettertrims.property.ability.type.entity.ReplaceBlockAbility;
import com.bawnorton.bettertrims.property.ability.type.entity.ReplaceDiskAbility;
import com.bawnorton.bettertrims.property.ability.type.entity.RunFunctionAbility;
import com.bawnorton.bettertrims.property.ability.type.entity.SetBlockPropertiesAbility;
import com.bawnorton.bettertrims.property.ability.type.entity.SpawnParticlesAbility;
import com.bawnorton.bettertrims.property.ability.type.entity.SummonEntityAbility;
import com.bawnorton.bettertrims.property.ability.type.toggle.AttributeAbility;
import com.bawnorton.bettertrims.property.ability.type.toggle.ToggleMobEffectAbility;
import com.bawnorton.bettertrims.property.ability.type.value.AddValue;
import com.bawnorton.bettertrims.property.ability.type.value.MultiplyValue;
import com.bawnorton.bettertrims.property.ability.type.value.RemoveBinomial;
import com.bawnorton.bettertrims.property.ability.type.value.SetValue;
import com.bawnorton.bettertrims.property.element.TrimElement;
import java.util.HashMap;
import java.util.Map;

public final class TrimElementTooltips {
    private static final Map<Class<? extends TrimElement>, TrimElementTooltipProvider<? extends TrimElement>> PROVIDERS = new HashMap<Class<? extends TrimElement>, TrimElementTooltipProvider<? extends TrimElement>>();

    public static <T extends TrimElement> void register(Class<T> clazz, TrimElementTooltipProvider<T> provider) {
        if (PROVIDERS.containsKey(clazz)) {
            throw new IllegalStateException("Provider for " + String.valueOf(clazz) + " is already registered");
        }
        PROVIDERS.put(clazz, provider);
    }

    public static TrimElementTooltipProvider<TrimElement> getProvider(Class<? extends TrimElement> clazz) {
        return PROVIDERS.getOrDefault(clazz, TrimElementTooltipProvider.EMPTY);
    }

    static {
        TrimElementTooltips.register(ApplyMobEffectAbility.class, new ApplyMobEffectAbility.TooltipProvider());
        TrimElementTooltips.register(ChangeItemDamageAbility.class, new ChangeItemDamageAbility.TooltipProvider());
        TrimElementTooltips.register(DamageEntityAbility.class, new DamageEntityAbility.TooltipProvider());
        TrimElementTooltips.register(ExplodeAbility.class, new ExplodeAbility.TooltipProvider());
        TrimElementTooltips.register(IgniteAbility.class, new IgniteAbility.TooltipProvider());
        TrimElementTooltips.register(PlaySoundAbility.class, new PlaySoundAbility.TooltipProvider());
        TrimElementTooltips.register(ReplaceBlockAbility.class, new ReplaceBlockAbility.TooltipProvider());
        TrimElementTooltips.register(ReplaceDiskAbility.class, new ReplaceDiskAbility.TooltipProvider());
        TrimElementTooltips.register(RunFunctionAbility.class, new RunFunctionAbility.TooltipProvider());
        TrimElementTooltips.register(SetBlockPropertiesAbility.class, new SetBlockPropertiesAbility.TooltipProvider());
        TrimElementTooltips.register(SpawnParticlesAbility.class, new SpawnParticlesAbility.TooltipProvider());
        TrimElementTooltips.register(SummonEntityAbility.class, new SummonEntityAbility.TooltipProvider());
        TrimElementTooltips.register(AttributeAbility.class, new AttributeAbility.TooltipProvider());
        TrimElementTooltips.register(ToggleMobEffectAbility.class, new ToggleMobEffectAbility.TooltipProvider());
        TrimElementTooltips.register(AddValue.class, new AddValue.TooltipProvider());
        TrimElementTooltips.register(MultiplyValue.class, new MultiplyValue.TooltipProvider());
        TrimElementTooltips.register(RemoveBinomial.class, new RemoveBinomial.TooltipProvider());
        TrimElementTooltips.register(SetValue.class, new SetValue.TooltipProvider());
        TrimElementTooltips.register(AllOf.ItemProperties.class, new AllOf.ItemProperties.TooltipProvider());
        TrimElementTooltips.register(AllOf.EntityAbilities.class, new AllOf.EntityAbilities.TooltipProvider());
        TrimElementTooltips.register(AllOf.ToggleAbilities.class, new AllOf.ToggleAbilities.TooltipProvider());
        TrimElementTooltips.register(AllOf.ValueAbilities.class, new AllOf.ValueAbilities.TooltipProvider());
    }
}

