/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.bettertrims.mixin.property.ability.experience_gain;

import com.bawnorton.bettertrims.property.TrimProperties;
import com.bawnorton.bettertrims.property.TrimProperty;
import com.bawnorton.bettertrims.property.ability.TrimAbilityComponents;
import com.bawnorton.bettertrims.property.ability.runner.TrimValueAbilityRunner;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

@Mixin(value={Player.class})
abstract class PlayerMixin
extends LivingEntity {
    PlayerMixin(EntityType<? extends LivingEntity> entityType, Level level) {
        super(entityType, level);
    }

    @ModifyVariable(method={"giveExperiencePoints"}, at=@At(value="HEAD"), argsOnly=true)
    private int applyTrimToXp(int original) {
        Level level = this.level();
        if (!(level instanceof ServerLevel)) {
            return original;
        }
        ServerLevel level2 = (ServerLevel)level;
        for (TrimProperty property : TrimProperties.getProperties((Level)level2)) {
            for (TrimValueAbilityRunner<?> ability : property.getValueAbilityRunners(TrimAbilityComponents.EXPERIENCE_GAINED)) {
                original = (int)ability.runEquipment(level2, this, original);
            }
        }
        return original;
    }
}

