/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.bettertrims.property.ability.type.entity;

import com.bawnorton.bettertrims.client.tooltip.component.CompositeContainerComponent;
import com.bawnorton.bettertrims.client.tooltip.element.TrimElementTooltipProvider;
import com.bawnorton.bettertrims.client.tooltip.util.Styler;
import com.bawnorton.bettertrims.property.ability.type.TrimEntityAbility;
import com.bawnorton.bettertrims.property.context.TrimmedItems;
import com.bawnorton.bettertrims.version.VRegistry;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.sounds.WeighedSoundEvents;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public record PlaySoundAbility(Holder<SoundEvent> soundEvent, FloatProvider volume, FloatProvider pitch) implements TrimEntityAbility
{
    public static final MapCodec<PlaySoundAbility> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)SoundEvent.CODEC.fieldOf("sound").forGetter(PlaySoundAbility::soundEvent), (App)FloatProvider.codec((float)1.0E-5f, (float)10.0f).fieldOf("volume").forGetter(PlaySoundAbility::volume), (App)FloatProvider.codec((float)1.0E-5f, (float)2.0f).fieldOf("pitch").forGetter(PlaySoundAbility::pitch)).apply((Applicative)instance, PlaySoundAbility::new));

    public static Component getSoundName(Registry<SoundEvent> registry, Holder<SoundEvent> soundHolder) {
        ResourceLocation sound = (ResourceLocation)soundHolder.unwrap().map(ResourceKey::location, arg_0 -> registry.getKey(arg_0));
        if (sound == null) {
            SoundEvent soundEvent = (SoundEvent)soundHolder.unwrap().map(arg_0 -> registry.getValueOrThrow(arg_0), Function.identity());
            sound = soundEvent.location();
        }
        MutableComponent soundName = Component.literal((String)sound.toString());
        WeighedSoundEvents soundEvents = Minecraft.getInstance().getSoundManager().getSoundEvent(sound);
        if (soundEvents != null && soundEvents.getSubtitle() != null) {
            soundName = soundEvents.getSubtitle();
        }
        return soundName;
    }

    @Override
    public void apply(ServerLevel level, LivingEntity wearer, Entity target, TrimmedItems items, @Nullable EquipmentSlot targetSlot, Vec3 origin) {
        RandomSource random = target.getRandom();
        if (target.isSilent()) {
            return;
        }
        level.playSound(null, origin.x(), origin.y(), origin.z(), this.soundEvent, target.getSoundSource(), this.volume.sample(random), this.pitch.sample(random));
    }

    @Override
    public MapCodec<? extends TrimEntityAbility> codec() {
        return CODEC;
    }

    public static class TooltipProvider
    implements TrimElementTooltipProvider<PlaySoundAbility> {
        @Override
        @Nullable
        public ClientTooltipComponent getTooltip(ClientLevel level, PlaySoundAbility element, boolean includeCount) {
            Registry registry = VRegistry.get(level, Registries.SOUND_EVENT);
            Component soundName = PlaySoundAbility.getSoundName(registry, element.soundEvent());
            return ((CompositeContainerComponent.Builder)CompositeContainerComponent.builder().translate("bettertrims.tooltip.ability.play_sound.play", Styler::positive, new Object[0])).textComponent((Component)Styler.name(soundName.copy())).spaced().build();
        }
    }
}

