/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.bettertrims.property.count;

import com.bawnorton.bettertrims.client.tooltip.util.Formatter;
import com.bawnorton.bettertrims.client.tooltip.util.Styler;
import com.bawnorton.bettertrims.property.count.CountBasedValueType;
import com.bawnorton.bettertrims.property.count.CountBasedValueTypes;
import com.google.common.base.Predicates;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;

public interface CountBasedValue {
    public static final Codec<CountBasedValue> DISPATCH_CODEC = CountBasedValueType.REGISTRY.byNameCodec().dispatch(CountBasedValue::getType, CountBasedValueType::codec);
    public static final Codec<CountBasedValue> CODEC = Codec.either(Constant.LITERAL_CODEC, DISPATCH_CODEC).xmap(either -> (CountBasedValue)either.map(Function.identity(), Function.identity()), levelBasedValue -> {
        Either either;
        if (levelBasedValue instanceof Constant) {
            Constant constant = (Constant)levelBasedValue;
            either = Either.left((Object)constant);
        } else {
            either = Either.right((Object)levelBasedValue);
        }
        return either;
    });

    public static Clamped clamped(CountBasedValue value, float min, float max) {
        return new Clamped(value, min, max);
    }

    public static Constant constant(float value) {
        return new Constant(value);
    }

    public static Fraction fraction(CountBasedValue numerator, CountBasedValue denominator) {
        return new Fraction(numerator, denominator);
    }

    public static CountSquared countSquared(float constant) {
        return new CountSquared(constant);
    }

    public static Linear linear(float base, float perCountAboveFirst) {
        return new Linear(base, perCountAboveFirst);
    }

    public static Linear linear(float value) {
        return new Linear(value, value);
    }

    public static Lookup lookup(List<Float> values, CountBasedValue fallback) {
        return new Lookup(values, fallback);
    }

    public float calculate(int var1);

    default public List<Float> getValues(int upToCount) {
        return this.getValues(upToCount, (Predicate<Float>)Predicates.alwaysTrue());
    }

    default public List<Float> getValues(int upToCount, Predicate<Float> filter) {
        ArrayList<Float> values = new ArrayList<Float>();
        for (int i = 1; i <= upToCount; ++i) {
            float value = this.calculate(i);
            if (!filter.test(Float.valueOf(value))) continue;
            values.add(Float.valueOf(value));
        }
        return values;
    }

    default public List<Component> getValueComponents(int upToCount, boolean includeCount) {
        return this.getValueComponents(upToCount, includeCount, Formatter::decimal);
    }

    default public List<Component> getValueComponents(int upToCount, boolean includeCount, Function<Float, Component> formatter) {
        return this.getValueComponents(upToCount, includeCount, formatter, (Predicate<Float>)Predicates.alwaysTrue());
    }

    default public List<Component> getValueComponents(int upToCount, boolean includeCount, Function<Float, Component> formatter, Predicate<Float> filter) {
        List<Float> values = this.getValues(upToCount).stream().map(f -> filter.test((Float)f) ? f : null).toList();
        if (values.stream().distinct().count() == 1L) {
            return List.of(Styler.number(formatter.apply(values.getFirst()).copy()));
        }
        return this.getValueComponentsInternal(values, includeCount, formatter);
    }

    private List<Component> getValueComponentsInternal(List<Float> values, boolean includeCount, Function<Float, Component> formatter) {
        ArrayList<Component> components = new ArrayList<Component>();
        for (int i = 1; i <= values.size(); ++i) {
            Float value = values.get(i - 1);
            if (value == null) continue;
            MutableComponent valueComponent = Styler.number(formatter.apply(value).copy());
            if (includeCount) {
                MutableComponent countComponent = Styler.trim(Component.literal((String)"[%d]".formatted(i))).append(": ");
                components.add((Component)countComponent.append((Component)valueComponent));
                continue;
            }
            components.add((Component)valueComponent);
        }
        return components;
    }

    public CountBasedValueType<? extends CountBasedValue> getType();

    public record Clamped(CountBasedValue value, float min, float max) implements CountBasedValue
    {
        public static final MapCodec<Clamped> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)CODEC.fieldOf("value").forGetter(Clamped::value), (App)Codec.FLOAT.fieldOf("min").forGetter(Clamped::min), (App)Codec.FLOAT.fieldOf("max").forGetter(Clamped::max)).apply((Applicative)instance, Clamped::new));

        @Override
        public float calculate(int count) {
            return Mth.clamp((float)this.value.calculate(count), (float)this.min, (float)this.max);
        }

        @Override
        public CountBasedValueType<? extends CountBasedValue> getType() {
            return CountBasedValueTypes.CLAMPED;
        }
    }

    public record Constant(float value) implements CountBasedValue
    {
        public static final Codec<Constant> LITERAL_CODEC = Codec.FLOAT.xmap(Constant::new, Constant::value);
        public static final MapCodec<Constant> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.FLOAT.fieldOf("value").forGetter(Constant::value)).apply((Applicative)instance, Constant::new));

        @Override
        public float calculate(int count) {
            return this.value;
        }

        @Override
        public List<Component> getValueComponents(int upToCount, boolean includeCount, Function<Float, Component> formatter) {
            return List.of(Styler.number(formatter.apply(Float.valueOf(this.value)).copy()));
        }

        @Override
        public CountBasedValueType<? extends CountBasedValue> getType() {
            return CountBasedValueTypes.CONSTANT;
        }
    }

    public record Fraction(CountBasedValue numerator, CountBasedValue denominator) implements CountBasedValue
    {
        public static final MapCodec<Fraction> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)CODEC.fieldOf("numerator").forGetter(Fraction::numerator), (App)CODEC.fieldOf("denominator").forGetter(Fraction::denominator)).apply((Applicative)instance, Fraction::new));

        @Override
        public float calculate(int count) {
            float denominator = this.denominator.calculate(count);
            return denominator == 0.0f ? 0.0f : this.numerator.calculate(count) / denominator;
        }

        @Override
        public CountBasedValueType<? extends CountBasedValue> getType() {
            return CountBasedValueTypes.FRACTION;
        }
    }

    public record CountSquared(float constant) implements CountBasedValue
    {
        public static final MapCodec<CountSquared> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.FLOAT.fieldOf("constant").forGetter(CountSquared::constant)).apply((Applicative)instance, CountSquared::new));

        @Override
        public float calculate(int count) {
            return (float)Mth.square((int)count) + this.constant;
        }

        @Override
        public CountBasedValueType<? extends CountBasedValue> getType() {
            return CountBasedValueTypes.COUNT_SQUARED;
        }
    }

    public record Linear(float base, float perCountAboveFirst) implements CountBasedValue
    {
        public static final MapCodec<Linear> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.FLOAT.fieldOf("base").forGetter(Linear::base), (App)Codec.FLOAT.fieldOf("per_count_above_first").forGetter(Linear::perCountAboveFirst)).apply((Applicative)instance, Linear::new));

        @Override
        public float calculate(int count) {
            return this.base + this.perCountAboveFirst * (float)(count - 1);
        }

        @Override
        public CountBasedValueType<? extends CountBasedValue> getType() {
            return CountBasedValueTypes.LINEAR;
        }
    }

    public record Lookup(List<Float> values, CountBasedValue fallback) implements CountBasedValue
    {
        public static final MapCodec<Lookup> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.FLOAT.listOf().fieldOf("values").forGetter(Lookup::values), (App)CODEC.fieldOf("fallback").forGetter(Lookup::fallback)).apply((Applicative)instance, Lookup::new));

        @Override
        public float calculate(int count) {
            return count <= this.values.size() ? this.values.get(count - 1).floatValue() : this.fallback.calculate(count);
        }

        @Override
        public CountBasedValueType<? extends CountBasedValue> getType() {
            return CountBasedValueTypes.LOOKUP;
        }
    }
}

