/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.bettertrims.client.tooltip.condition;

import com.bawnorton.bettertrims.BetterTrims;
import com.bawnorton.bettertrims.client.mixin.accessor.CompositeLootItemConditionAccessor;
import com.bawnorton.bettertrims.client.mixin.accessor.IntRangeAccessor;
import com.bawnorton.bettertrims.client.tooltip.component.CompositeBuilder;
import com.bawnorton.bettertrims.client.tooltip.component.CompositeContainerComponent;
import com.bawnorton.bettertrims.client.tooltip.component.ConditionalComponent;
import com.bawnorton.bettertrims.client.tooltip.component.CyclingComponent;
import com.bawnorton.bettertrims.client.tooltip.condition.predicate.BlockPredicateTooltip;
import com.bawnorton.bettertrims.client.tooltip.condition.predicate.DamageSourcePredicateTooltip;
import com.bawnorton.bettertrims.client.tooltip.condition.predicate.EntityPredicateTooltip;
import com.bawnorton.bettertrims.client.tooltip.condition.predicate.ItemPredicateTooltip;
import com.bawnorton.bettertrims.client.tooltip.condition.predicate.LocationPredicateTooltip;
import com.bawnorton.bettertrims.client.tooltip.condition.predicate.PredicateTooltip;
import com.bawnorton.bettertrims.client.tooltip.util.Formatter;
import com.bawnorton.bettertrims.client.tooltip.util.Styler;
import com.bawnorton.bettertrims.property.condition.DimensionCheck;
import com.bawnorton.bettertrims.util.TriState;
import com.bawnorton.bettertrims.version.VRegistry;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import net.minecraft.Util;
import net.minecraft.advancements.critereon.DamageSourcePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTextTooltip;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.storage.loot.IntRange;
import net.minecraft.world.level.storage.loot.predicates.AllOfCondition;
import net.minecraft.world.level.storage.loot.predicates.CompositeLootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditions;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.EnchantmentLevelProvider;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.ScoreboardValue;
import net.minecraft.world.level.storage.loot.providers.number.StorageValue;
import net.minecraft.world.level.storage.loot.providers.score.ContextScoreboardNameProvider;
import net.minecraft.world.level.storage.loot.providers.score.FixedScoreboardNameProvider;
import net.minecraft.world.level.storage.loot.providers.score.ScoreboardNameProvider;
import org.jetbrains.annotations.NotNull;

public interface LootConditionTooltips {
    public static final Map<LootItemConditionType, LootTooltipAdder<?>> TOOLTIPS = (Map)Util.make(new HashMap(), map -> {
        map.put(LootItemConditions.INVERTED, (level, condition, parentBuilder, state) -> {
            LootItemCondition term = condition.term();
            CompositeContainerComponent.Builder builder = CompositeContainerComponent.builder();
            LootConditionTooltips.addConditionToTooltip(level, term, builder, state.withInverted(!state.doInvert()));
            parentBuilder.component(builder.build());
        });
        LootTooltipAdder<CompositeLootItemCondition> compositeFactory = (level, condition, parentBuilder, state) -> {
            CompositeLootItemConditionAccessor composite = (CompositeLootItemConditionAccessor)condition;
            CompositeContainerComponent.Builder builder = ((CompositeContainerComponent.Builder)CompositeContainerComponent.builder().translate("bettertrims.tooltip.condition.%s.%s".formatted(condition instanceof AllOfCondition ? "all_of" : "any_of", state.key()), Styler::condition, new Object[0])).vertical();
            for (LootItemCondition term : composite.bettertrims$terms()) {
                CompositeBuilder termBuilder = CompositeContainerComponent.builder().literal("\u2022 ", Styler::condition);
                LootConditionTooltips.addConditionToTooltip(level, term, (CompositeContainerComponent.Builder)termBuilder, state.withInverted(false));
                builder.component(((CompositeContainerComponent.Builder)termBuilder).build());
            }
            parentBuilder.component(builder.build());
        };
        map.put(LootItemConditions.ANY_OF, compositeFactory);
        map.put(LootItemConditions.ALL_OF, compositeFactory);
        map.put(LootItemConditions.RANDOM_CHANCE, (level, condition, parentBuilder, state) -> {
            LootItemRandomChanceCondition chanceCondition = (LootItemRandomChanceCondition)condition;
            parentBuilder.cycle(chanceCycler -> LootConditionTooltips.numberCompFromNumberProvider(chanceCondition.chance(), value -> {
                if (state.doInvert()) {
                    value = Float.valueOf(1.0f - value.floatValue());
                }
                return Formatter.percentage(value);
            }, comp -> comp.copy().append("%")).forEach(numberComp -> {
                MutableComponent tooltip = Styler.condition(Component.translatable((String)"bettertrims.tooltip.condition.random_chance", (Object[])new Object[]{numberComp}));
                chanceCycler.textComponent((Component)tooltip);
            }));
            state.withUseIf(false);
        });
        map.put(LootItemConditions.RANDOM_CHANCE_WITH_ENCHANTED_BONUS, (level, condition, parentBuilder, state) -> {
            Registry registry = VRegistry.get(level, Registries.ENCHANTMENT);
            Enchantment enchantment = (Enchantment)condition.enchantment().unwrap().map(arg_0 -> registry.getOrThrow(arg_0), Function.identity());
            HashMap<Integer, Float> chanceMap = new HashMap<Integer, Float>();
            for (int i = 1; i <= enchantment.getMaxLevel(); ++i) {
                chanceMap.put(i, Float.valueOf(condition.enchantedChance().calculate(i)));
            }
            MutableComponent enchantmentName = Styler.name(enchantment.description().copy());
            parentBuilder.component(((CompositeContainerComponent.Builder)((CompositeContainerComponent.Builder)CompositeContainerComponent.builder().translate("bettertrims.tooltip.condition.random_chance_with_enchanted_bonus.enchanted.%s".formatted(state.key()), Styler::condition, new Object[]{enchantmentName})).space().cycle(levelCycler -> chanceMap.forEach((enchantLevel, chance) -> {
                MutableComponent levelComp = Styler.value(Component.translatable((String)("enchantment.level." + enchantLevel))).append(": ");
                MutableComponent chanceComp = Styler.number(Formatter.percentage(chance));
                levelCycler.textComponent((Component)levelComp.append((Component)chanceComp));
            })).literal(",").space().translate("bettertrims.tooltip.condition.random_chance_with_enchanted_bonus.else", Styler::condition, new Object[]{Styler.number(Formatter.percentage(Float.valueOf(condition.unenchantedChance())))})).build());
        });
        map.put(LootItemConditions.ENTITY_PROPERTIES, (level, condition, parentBuilder, state) -> {
            Optional predicate = condition.predicate();
            if (predicate.isEmpty()) {
                return;
            }
            MutableComponent target = Styler.target(Component.translatable((String)"bettertrims.tooltip.condition.entity_properties.%s.%s".formatted(state.key(), condition.entityTarget().getSerializedName())));
            CompositeContainerComponent.Builder builder = CompositeContainerComponent.builder().vertical();
            EntityPredicateTooltip.addToBuilder(level, (EntityPredicate)predicate.orElseThrow(), state, builder);
            parentBuilder.textComponent((Component)target).component(builder.build());
        });
        map.put(LootItemConditions.KILLED_BY_PLAYER, (level, condition, parentBuilder, state) -> parentBuilder.textComponent((Component)Styler.condition(Component.translatable((String)"bettertrims.tooltip.condition.killed_by_player.%s".formatted(state.key())))));
        map.put(LootItemConditions.ENTITY_SCORES, (level, condition, parentBuilder, state) -> {
            MutableComponent target = Styler.target(Component.translatable((String)"bettertrims.tooltip.condition.entity_properties.%s.%s".formatted(state.key(), condition.entityTarget().getSerializedName())));
            Map scores = condition.scores();
            CompositeContainerComponent.Builder builder = CompositeContainerComponent.builder();
            builder.cycle(arg_0 -> LootConditionTooltips.lambda$static$14(scores, state, (Component)target, arg_0));
        });
        map.put(LootItemConditions.BLOCK_STATE_PROPERTY, (level, condition, parentBuilder, state) -> {
            Registry registry = VRegistry.get(level, Registries.BLOCK);
            Holder block = condition.block();
            MutableComponent blockName = Styler.name(((Block)block.unwrap().map(arg_0 -> registry.getOrThrow(arg_0), Function.identity())).getName());
            Optional properties = condition.properties();
            CompositeContainerComponent.Builder builder = CompositeContainerComponent.builder();
            if (properties.isPresent()) {
                MutableComponent target = Styler.condition(Component.translatable((String)"bettertrims.tooltip.condition.block_state_property.with_properties.%s".formatted(state.key()), (Object[])new Object[]{blockName}));
                builder.textComponent((Component)target);
                BlockPredicateTooltip.addStatePropertiesPredicateToBuilder(level, (StatePropertiesPredicate)properties.orElseThrow(), state, builder);
            } else {
                MutableComponent target = Styler.condition(Component.translatable((String)"bettertrims.tooltip.condition.block_state_property.%s".formatted(state.key()), (Object[])new Object[]{blockName}));
                builder.textComponent((Component)target);
            }
            parentBuilder.component(builder.build());
        });
        map.put(LootItemConditions.MATCH_TOOL, (level, matchTool, parentBuilder, state) -> {
            Optional predicate = matchTool.predicate();
            if (predicate.isEmpty()) {
                return;
            }
            CompositeContainerComponent.Builder builder = CompositeContainerComponent.builder();
            builder.translate("bettertrims.tooltip.condition.match_tool", Styler::target, new Object[0]);
            ItemPredicateTooltip.addToBuilder(level, (ItemPredicate)predicate.orElseThrow(), state, builder);
            parentBuilder.component(builder.build());
        });
        map.put(LootItemConditions.TABLE_BONUS, (level, condition, parentBuilder, state) -> {
            Holder enchantment = condition.enchantment();
            List values = condition.values();
            Registry registry = VRegistry.get(level, Registries.ENCHANTMENT);
            MutableComponent enchantmentName = Styler.name(((Enchantment)enchantment.unwrap().map(arg_0 -> registry.getOrThrow(arg_0), Function.identity())).description().copy());
            CompositeContainerComponent.Builder builder = CompositeContainerComponent.builder();
            ((CompositeContainerComponent.Builder)builder.translate("bettertrims.tooltip.condition.table_bonus.%s".formatted(state.key()), Styler::condition, new Object[]{enchantmentName})).space().cycle(cycler -> {
                for (int i = 0; i < values.size(); ++i) {
                    float value = ((Float)values.get(i)).floatValue();
                    MutableComponent levelComp = Styler.value(Component.translatable((String)("enchantment.level." + (i + 1)))).append(": ");
                    MutableComponent valueComp = Styler.number(Formatter.decimal(Float.valueOf(value)));
                    cycler.textComponent((Component)levelComp.append((Component)valueComp));
                }
            });
            parentBuilder.component(builder.build());
        });
        map.put(LootItemConditions.SURVIVES_EXPLOSION, (level, condition, parentBuilder, state) -> parentBuilder.textComponent((Component)Styler.condition(Component.translatable((String)"bettertrims.tooltip.condition.survives_explosion.%s".formatted(state.key())))));
        map.put(LootItemConditions.DAMAGE_SOURCE_PROPERTIES, (level, condition, parentBuilder, state) -> {
            Optional predicate = condition.predicate();
            if (predicate.isEmpty()) {
                return;
            }
            CompositeContainerComponent.Builder builder = CompositeContainerComponent.builder();
            builder.translate("bettertrims.tooltip.condition.damage_source_properties.%s".formatted(state.key()), Styler::condition, new Object[0]);
            DamageSourcePredicateTooltip.addToBuilder(level, (DamageSourcePredicate)predicate.orElseThrow(), state, builder);
            parentBuilder.component(builder.build());
        });
        map.put(LootItemConditions.LOCATION_CHECK, (level, locationCheck, parentBuilder, state) -> {
            Optional predicate = locationCheck.predicate();
            if (predicate.isEmpty()) {
                return;
            }
            BlockPos offset = locationCheck.offset();
            CompositeContainerComponent.Builder builder = CompositeContainerComponent.builder();
            LocationPredicateTooltip.addToBuilder(level, (LocationPredicate)predicate.orElseThrow(), state, builder);
            if (!offset.equals((Object)BlockPos.ZERO)) {
                MutableComponent offsetComp = Styler.value(Component.literal((String)"(%d, %d, %d)".formatted(offset.getX(), offset.getY(), offset.getZ())));
                builder.space().translate("bettertrims.tooltip.condition.location_check.offset", Styler::condition, new Object[]{offsetComp});
            }
            parentBuilder.component(builder.build());
        });
        map.put(LootItemConditions.WEATHER_CHECK, (level, weatherCheck, parentBuilder, state) -> {
            Optional raining = weatherCheck.isRaining();
            Optional thundering = weatherCheck.isThundering();
            if (raining.isEmpty() && thundering.isEmpty()) {
                return;
            }
            CompositeContainerComponent.Builder builder = CompositeContainerComponent.builder();
            if (raining.isPresent() && thundering.isPresent()) {
                builder.translate("bettertrims.tooltip.condition.weather_check.both.%s".formatted(state.key()), Styler::condition, new Object[]{Styler.value(Component.translatable((String)"bettertrims.tooltip.condition.weather_check.raining.%s".formatted((Boolean)raining.get() != false ? "true" : "false"))), Styler.value(Component.translatable((String)"bettertrims.tooltip.condition.weather_check.thundering.%s".formatted((Boolean)thundering.get() != false ? "true" : "false")))});
            } else if (raining.isPresent()) {
                builder.translate("bettertrims.tooltip.condition.weather_check.raining.%s".formatted(state.key()), Styler::condition, new Object[]{Styler.value(Component.translatable((String)"bettertrims.tooltip.condition.weather_check.raining.%s".formatted((Boolean)raining.get() != false ? "true" : "false")))});
            } else {
                builder.translate("bettertrims.tooltip.condition.weather_check.thundering.%s".formatted(state.key()), Styler::condition, new Object[]{Styler.value(Component.translatable((String)"bettertrims.tooltip.condition.weather_check.thundering.%s".formatted((Boolean)thundering.get() != false ? "true" : "false")))});
            }
            parentBuilder.component(builder.build());
        });
        map.put(LootItemConditions.REFERENCE, (level, conditionReference, parentBuilder, state) -> {
            ResourceKey name = conditionReference.name();
            ResourceLocation id = name.location();
            parentBuilder.textComponent((Component)Styler.condition(Component.translatable((String)"bettertrims.tooltip.condition.reference.%s".formatted(state.key()), (Object[])new Object[]{Styler.name(Component.literal((String)id.toString()))})));
        });
        map.put(LootItemConditions.TIME_CHECK, (level, timeCheck, parentBuilder, state) -> {
            IntRange value = timeCheck.value();
            Optional period = timeCheck.period();
            IntRangeAccessor accessor = (IntRangeAccessor)value;
            NumberProvider min = accessor.bettertrims$min();
            NumberProvider max = accessor.bettertrims$max();
            Function<Float, MutableComponent> formatter = ticks -> {
                String ampm;
                long totalSeconds = (long)Math.round(ticks.floatValue() / 20.0f) * 72L;
                long totalMinutes = TimeUnit.SECONDS.toMinutes(totalSeconds);
                long totalHours = TimeUnit.MINUTES.toHours(totalMinutes);
                long days = TimeUnit.HOURS.toDays(totalHours);
                long minutes = totalMinutes % 60L;
                long hours = (totalHours + 6L) % 24L;
                String string = ampm = hours >= 12L ? "pm" : "am";
                if ((hours %= 12L) == 0L) {
                    hours = 12L;
                }
                if (days > 0L) {
                    return Component.literal((String)"%d:%02d%s + %d Days".formatted(hours, minutes, ampm, days));
                }
                return Component.literal((String)"%d:%02d%s".formatted(hours, minutes, ampm));
            };
            List<Component> minComps = min == null ? LootConditionTooltips.numberCompFromNumberProvider((NumberProvider)new ConstantValue(0.0f), formatter, UnaryOperator.identity()) : LootConditionTooltips.numberCompFromNumberProvider(min, formatter, UnaryOperator.identity());
            List<Component> maxComps = max == null ? LootConditionTooltips.numberCompFromNumberProvider((NumberProvider)new ConstantValue(24000.0f), formatter, UnaryOperator.identity()) : LootConditionTooltips.numberCompFromNumberProvider(max, formatter, UnaryOperator.identity());
            CompositeContainerComponent.Builder builder = CompositeContainerComponent.builder();
            ((CompositeContainerComponent.Builder)((CompositeContainerComponent.Builder)((CompositeContainerComponent.Builder)builder.translate("bettertrims.tooltip.condition.time_check.%s".formatted(state.key()), Styler::condition, new Object[0])).space().translate("bettertrims.tooltip.condition.time_check.between", Styler::condition, new Object[0])).space().cycle(cycleBuilder -> minComps.forEach(cycleBuilder::textComponent)).literal(" & ", Styler::condition)).cycle(cycleBuilder -> maxComps.forEach(cycleBuilder::textComponent));
            if (period.isPresent()) {
                float periodTicks = ((Long)period.orElseThrow()).longValue();
                long totalSeconds = (long)Math.round(periodTicks / 20.0f) * 72L;
                long totalMinutes = TimeUnit.SECONDS.toMinutes(totalSeconds);
                long totalHours = TimeUnit.MINUTES.toHours(totalMinutes);
                long days = TimeUnit.HOURS.toDays(totalHours);
                long minutes = totalMinutes % 60L;
                long hours = totalHours % 24L;
                StringBuilder formattedPeriod = new StringBuilder();
                if (days > 0L) {
                    if (days == 1L) {
                        formattedPeriod.append("Day");
                    } else {
                        formattedPeriod.append("%d Days".formatted(days));
                    }
                }
                if (hours > 0L) {
                    if (!formattedPeriod.isEmpty()) {
                        formattedPeriod.append(", %d Hours".formatted(hours));
                    } else if (hours == 1L) {
                        formattedPeriod.append("Hour");
                    } else {
                        formattedPeriod.append("%d Hours".formatted(hours));
                    }
                }
                if (minutes > 0L) {
                    if (!formattedPeriod.isEmpty()) {
                        formattedPeriod.append(", %d Minutes".formatted(minutes));
                    } else if (minutes == 1L) {
                        formattedPeriod.append("Minute");
                    } else {
                        formattedPeriod.append("%d Minutes".formatted(minutes));
                    }
                }
                if (formattedPeriod.isEmpty()) {
                    formattedPeriod.append("%d Seconds".formatted(totalSeconds));
                }
                builder.space().translate("bettertrims.tooltip.condition.time_check.period", Styler::condition, new Object[]{Styler.value(Component.literal((String)formattedPeriod.toString()))});
            }
            parentBuilder.component(builder.build());
        });
        map.put(LootItemConditions.VALUE_CHECK, (level, condition, parentBuilder, state) -> {
            NumberProvider provider = condition.provider();
            IntRange range = condition.range();
            IntRangeAccessor accessor = (IntRangeAccessor)range;
            NumberProvider min = accessor.bettertrims$min();
            NumberProvider max = accessor.bettertrims$max();
            List<Component> providerComps = LootConditionTooltips.numberCompFromNumberProvider(provider, Formatter::decimal, UnaryOperator.identity());
            List<Component> minComps = min == null ? null : LootConditionTooltips.numberCompFromNumberProvider(min, Formatter::decimal, UnaryOperator.identity());
            List<Component> maxComps = max == null ? null : LootConditionTooltips.numberCompFromNumberProvider(max, Formatter::decimal, UnaryOperator.identity());
            CompositeContainerComponent.Builder builder = CompositeContainerComponent.builder();
            ((CompositeContainerComponent.Builder)builder.translate("bettertrims.tooltip.condition.value_check.%s".formatted(state.key()), Styler::condition, new Object[]{providerComps})).space();
            if (minComps != null && maxComps != null) {
                builder.translate("bettertrims.tooltip.condition.value_check.between", Styler::condition, new Object[]{minComps, maxComps});
            } else if (minComps != null) {
                builder.translate("bettertrims.tooltip.condition.value_check.at_least", Styler::condition, new Object[]{minComps});
            } else if (maxComps != null) {
                builder.translate("bettertrims.tooltip.condition.value_check.at_most", Styler::condition, new Object[]{maxComps});
            } else {
                builder.translate("bettertrims.tooltip.condition.value_check.any_value", Styler::condition, new Object[0]);
            }
            parentBuilder.component(builder.build());
        });
        map.put(LootItemConditions.ENCHANTMENT_ACTIVE_CHECK, (level, condition, parentBuilder, state) -> parentBuilder.translate("bettertrims.tooltip.condition.enchantment_active_check.%s.%S".formatted(state.key(), condition.active()), Styler::condition, new Object[0]));
        map.put(DimensionCheck.TYPE, (level, condition, parentBuilder, state) -> {
            HolderSet<DimensionType> dimensions = condition.dimensions();
            PredicateTooltip.addRegisteredElementsToBuilder(level, "bettertrims.tooltip.condition.dimension_check.%s".formatted(state.key()), Registries.DIMENSION_TYPE, dimensions, state.withPrefixSpace(false), parentBuilder);
        });
    });

    public static CompositeContainerComponent getTooltip(ClientLevel level, Font font, LootItemCondition condition) {
        State state = new State();
        CompositeContainerComponent.Builder conditionBuilder = CompositeContainerComponent.builder();
        LootConditionTooltips.addConditionToTooltip(level, condition, conditionBuilder, state);
        CompositeContainerComponent conditionComponent = conditionBuilder.build();
        CompositeContainerComponent.Builder root = CompositeContainerComponent.builder();
        if (state.doUseIf()) {
            ((CompositeContainerComponent.Builder)root.translate("bettertrims.tooltip.condition.if", Styler::condition, new Object[0])).space();
        }
        if (conditionComponent.isOneLine()) {
            return root.component(conditionComponent).build();
        }
        return root.component(CompositeContainerComponent.builder().component(new ConditionalComponent((ClientTooltipComponent)new ClientTextTooltip(Styler.condition(Component.translatable((String)"bettertrims.tooltip.condition.hold_shift", (Object[])new Object[]{Styler.trim(Component.literal((String)"[LSHFT]"))})).getVisualOrderText()), conditionComponent, () -> !Screen.hasShiftDown() && !BetterTrims.debug)).build()).build();
    }

    private static void addConditionToTooltip(ClientLevel level, LootItemCondition condition, CompositeContainerComponent.Builder builder, State state) {
        LootTooltipAdder<?> factory = TOOLTIPS.getOrDefault(condition.getType(), LootTooltipAdder.EMPTY);
        factory.addToBuilder(level, condition, builder, state);
    }

    @NotNull
    private static List<Component> numberCompFromNumberProvider(NumberProvider numberProvider, Function<Float, MutableComponent> valueFormatter, UnaryOperator<Component> literalFormatter) {
        NumberProvider numberProvider2 = numberProvider;
        Objects.requireNonNull(numberProvider2);
        NumberProvider numberProvider3 = numberProvider2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ConstantValue.class, ScoreboardValue.class, EnchantmentLevelProvider.class, StorageValue.class}, (Object)numberProvider3, n)) {
            case 0 -> {
                ConstantValue constant = (ConstantValue)numberProvider3;
                yield List.of(Styler.number(valueFormatter.apply(Float.valueOf(constant.value()))));
            }
            case 1 -> {
                ScoreboardValue scoreboardValue = (ScoreboardValue)numberProvider3;
                MutableComponent score = Styler.property(Component.literal((String)scoreboardValue.score()));
                ScoreboardNameProvider v2 = scoreboardValue.target();
                Objects.requireNonNull(v2);
                ScoreboardNameProvider var9_9 = v2;
                int var10_12 = 0;
                MutableComponent v3 = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{FixedScoreboardNameProvider.class, ContextScoreboardNameProvider.class}, (Object)var9_9, var10_12)) {
                    case 0 -> {
                        FixedScoreboardNameProvider fixed = (FixedScoreboardNameProvider)var9_9;
                        yield Component.literal((String)fixed.name());
                    }
                    case 1 -> {
                        ContextScoreboardNameProvider context = (ContextScoreboardNameProvider)var9_9;
                        yield Component.translatable((String)"bettertrims.tooltip.condition.context_scoreboard_name.%s".formatted(context.target().getSerializedName()));
                    }
                    default -> Component.literal((String)"[?]");
                };
                MutableComponent targetComp = Styler.name(v3);
                yield List.of(Styler.condition(((Component)literalFormatter.apply((Component)Component.translatable((String)"bettertrims.tooltip.condition.number_provider.scoreboard", (Object[])new Object[]{targetComp, score}))).copy()));
            }
            case 2 -> {
                EnchantmentLevelProvider levelProvider = (EnchantmentLevelProvider)numberProvider3;
                ArrayList<MutableComponent> components = new ArrayList<MutableComponent>();
                for (int i = 1; i <= 5; ++i) {
                    float value = levelProvider.amount().calculate(i);
                    MutableComponent formattedValue = valueFormatter.apply(Float.valueOf(value));
                    MutableComponent enchantmentLevelComp = Styler.value(Component.translatable((String)("enchantment.level." + i)));
                    components.add(enchantmentLevelComp.append(": ").append((Component)Styler.number(formattedValue)));
                }
                yield components;
            }
            case 3 -> {
                StorageValue storageValue = (StorageValue)numberProvider3;
                MutableComponent pathComp = Styler.value(Component.literal((String)storageValue.path().asString()));
                MutableComponent storageComp = Styler.name(Component.literal((String)storageValue.storage().toString()));
                yield List.of((Component)literalFormatter.apply((Component)Component.translatable((String)"bettertrims.tooltip.condition.number_provider.storage", (Object[])new Object[]{pathComp, storageComp})));
            }
            default -> List.of(Component.translatable((String)"bettertrims.tooltip.condition.number_provider.complex"));
        };
    }

    private static /* synthetic */ void lambda$static$14(Map scores, State state, Component target, CyclingComponent.Builder scoreCycler) {
        scores.forEach((score, range) -> {
            IntRangeAccessor accessor = (IntRangeAccessor)range;
            NumberProvider min = accessor.bettertrims$min();
            NumberProvider max = accessor.bettertrims$max();
            List<Component> minComps = min == null ? null : LootConditionTooltips.numberCompFromNumberProvider(min, Formatter::decimal, UnaryOperator.identity());
            List<Component> maxComps = max == null ? null : LootConditionTooltips.numberCompFromNumberProvider(max, Formatter::decimal, UnaryOperator.identity());
            MutableComponent scoreComp = Styler.property(Component.literal((String)score));
            if (minComps != null && maxComps != null) {
                scoreCycler.textComponent((Component)Styler.condition(Component.translatable((String)"bettertrims.tooltip.condition.entity_scores.between.%s".formatted(state.key()), (Object[])new Object[]{target, scoreComp, minComps, maxComps})));
            } else if (minComps != null) {
                scoreCycler.textComponent((Component)Styler.condition(Component.translatable((String)"bettertrims.tooltip.condition.entity_scores.at_least.%s".formatted(state.key()), (Object[])new Object[]{target, scoreComp, minComps})));
            } else if (maxComps != null) {
                scoreCycler.textComponent((Component)Styler.condition(Component.translatable((String)"bettertrims.tooltip.condition.entity_scores.at_most.%s".formatted(state.key()), (Object[])new Object[]{target, scoreComp, maxComps})));
            } else {
                scoreCycler.textComponent((Component)Styler.condition(Component.translatable((String)"bettertrims.tooltip.condition.entity_scores.any_value.%s".formatted(state.key()), (Object[])new Object[]{target, scoreComp})));
            }
        });
    }

    public static class State {
        private final Set<StateEntry> entries = new HashSet<StateEntry>();
        private final StateEntry inverted = this.entry("inverted", false, true);
        private final StateEntry useWith = this.entry("with", false, true);
        private final StateEntry prefixSpace = this.entry("space", true, false);
        private final StateEntry useIf = this.entry("if", true, false);

        public static String normalKey() {
            return "normal";
        }

        private StateEntry entry(String key, boolean defaultValue, boolean includedInKey) {
            StateEntry stateEntry = new StateEntry(key, defaultValue, includedInKey);
            this.entries.add(stateEntry);
            return stateEntry;
        }

        public State withInverted(boolean inverted) {
            this.inverted.switchTo(inverted);
            return this;
        }

        public State withPrefixSpace(boolean prefixSpace) {
            this.prefixSpace.switchTo(prefixSpace);
            return this;
        }

        public State withUseWith(boolean useWith) {
            this.useWith.switchTo(useWith);
            return this;
        }

        public State withUseIf(boolean useIf) {
            this.useIf.switchTo(useIf);
            return this;
        }

        public boolean doInvert() {
            return this.inverted.value();
        }

        public boolean doPrefixSpace() {
            return this.prefixSpace.value();
        }

        public boolean doUseWith() {
            return this.useWith.value();
        }

        public boolean doUseIf() {
            return this.useIf.value();
        }

        public String key() {
            StringBuilder keyBuilder = new StringBuilder();
            for (StateEntry entry : this.entries) {
                if (!entry.includedInKey() || !entry.value()) continue;
                if (!keyBuilder.isEmpty()) {
                    keyBuilder.append(".");
                }
                keyBuilder.append(entry.key());
            }
            if (keyBuilder.isEmpty()) {
                return State.normalKey();
            }
            return keyBuilder.toString();
        }

        private static final class StateEntry {
            private final String key;
            private final boolean defaultValue;
            private final boolean includedInKey;
            private TriState state;

            private StateEntry(String key, boolean defaultValue, boolean includedInKey) {
                this.key = key;
                this.state = TriState.DEFAULT;
                this.defaultValue = defaultValue;
                this.includedInKey = includedInKey;
            }

            public void switchTo(boolean value) {
                this.state = value ? TriState.TRUE : TriState.FALSE;
            }

            public boolean value() {
                return this.state == TriState.DEFAULT ? this.defaultValue : this.state == TriState.TRUE;
            }

            public boolean includedInKey() {
                return this.includedInKey;
            }

            public String key() {
                return this.key;
            }
        }
    }

    public static interface LootTooltipAdder<T extends LootItemCondition> {
        public static final LootTooltipAdder<?> EMPTY = (level, condition, builder, state) -> builder.translate("bettertrims.tooltip.condition.unknown", Styler::condition, new Object[]{((Comparable)((Object)Objects.requireNonNullElse(BuiltInRegistries.LOOT_CONDITION_TYPE.getKey((Object)condition.getType()), "[unregistered]"))).toString()});

        public void addToBuilder(ClientLevel var1, T var2, CompositeContainerComponent.Builder var3, State var4);
    }
}

