/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.bettertrims.client.tooltip.condition.predicate;

import com.bawnorton.bettertrims.client.tooltip.component.CompositeBuilder;
import com.bawnorton.bettertrims.client.tooltip.component.CompositeContainerComponent;
import com.bawnorton.bettertrims.client.tooltip.condition.LootConditionTooltips;
import com.bawnorton.bettertrims.client.tooltip.util.Formatter;
import com.bawnorton.bettertrims.client.tooltip.util.Styler;
import com.bawnorton.bettertrims.version.VRegistry;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.advancements.critereon.TagPredicate;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;

public interface PredicateTooltip {
    public static String key(String key) {
        return "bettertrims.tooltip.condition.predicate.%s".formatted(key);
    }

    public static void addMinMaxToBuilder(String key, boolean useAnd, MinMaxBounds<?> minMaxBounds, LootConditionTooltips.State state, CompositeBuilder<?> builder) {
        PredicateTooltip.addMinMaxToBuilder(key, useAnd, minMaxBounds.min().orElse(null), minMaxBounds.max().orElse(null), state, builder);
    }

    public static void addMinMaxToBuilder(String key, boolean useAnd, Number min, Number max, LootConditionTooltips.State state, CompositeBuilder<?> builder) {
        PredicateTooltip.addMinMaxToBuilder(key, useAnd, min, max, Formatter::decimal, state, builder);
    }

    public static void addMinMaxToBuilder(String key, boolean useAnd, MinMaxBounds<?> minMaxBounds, Function<Double, MutableComponent> formatter, LootConditionTooltips.State state, CompositeBuilder<?> builder) {
        PredicateTooltip.addMinMaxToBuilder(key, useAnd, minMaxBounds.min().orElse(null), minMaxBounds.max().orElse(null), formatter, state, builder);
    }

    public static void addMinMaxToBuilder(String key, boolean useAnd, Number min, Number max, Function<Double, MutableComponent> formatter, LootConditionTooltips.State state, CompositeBuilder<?> builder) {
        if (state.doPrefixSpace()) {
            builder.space();
        }
        if (useAnd) {
            builder.translate("bettertrims.tooltip.and", Styler::condition, new Object[0]).space();
        }
        if (min != null && max != null) {
            if (min.equals(max)) {
                builder.translate("%s.is".formatted(key), Styler::condition, Styler.number(formatter.apply(min.doubleValue())));
            } else {
                builder.translate("%s.between".formatted(key), Styler::condition, Styler.number(formatter.apply(min.doubleValue())), Styler.number(formatter.apply(max.doubleValue())));
            }
        } else if (min != null) {
            builder.translate("%s.at_least".formatted(key), Styler::condition, Styler.number(formatter.apply(min.doubleValue())));
        } else if (max != null) {
            builder.translate("%s.at_most".formatted(key), Styler::condition, Styler.number(formatter.apply(max.doubleValue())));
        }
    }

    public static <T> void addRegisteredElementsToBuilder(ClientLevel level, String key, ResourceKey<Registry<T>> registryKey, HolderSet<T> elements, LootConditionTooltips.State state, CompositeBuilder<?> builder) {
        PredicateTooltip.addRegisteredElementsToBuilder(level, key, registryKey, elements, (Function)null, state, builder);
    }

    public static <T> void addRegisteredElementsToBuilder(ClientLevel level, String key, ResourceKey<Registry<T>> registryKey, HolderSet<T> elements, Function<T, Component> nameMapper, LootConditionTooltips.State state, CompositeBuilder<?> builder) {
        PredicateTooltip.addRegisteredElementsToBuilder(level, key, registryKey, elements, nameMapper == null ? null : (element, composite) -> (Component)nameMapper.apply(element), state, builder);
    }

    public static <T> void addRegisteredElementsToBuilder(ClientLevel level, String key, ResourceKey<Registry<T>> registryKey, HolderSet<T> elements, BiFunction<T, CompositeBuilder<?>, Component> nameMapper, LootConditionTooltips.State state, CompositeBuilder<?> builder) {
        Registry registry = VRegistry.get(level, registryKey);
        CompositeContainerComponent.Builder registeredElementBuilder = CompositeContainerComponent.builder();
        if (state.doPrefixSpace()) {
            registeredElementBuilder.space();
        }
        ((CompositeContainerComponent.Builder)registeredElementBuilder.translate((String)(elements.size() == 1 ? key : key + ".multiple"), Styler::condition, new Object[0])).space().cycle(cycler -> elements.stream().forEach(holder -> {
            if (nameMapper != null) {
                CompositeContainerComponent.Builder elementBuilder = CompositeContainerComponent.builder();
                MutableComponent name = Styler.name(((Component)nameMapper.apply(holder.unwrap().map(arg_0 -> ((Registry)registry).getOrThrow(arg_0), Function.identity()), elementBuilder)).copy());
                cycler.component(CompositeContainerComponent.builder().textComponent((Component)name).component(elementBuilder.build()).build());
            } else {
                cycler.textComponent((Component)Styler.name(Component.literal((String)((ResourceLocation)holder.unwrap().map(ResourceKey::location, arg_0 -> ((Registry)registry).getKey(arg_0))).toString())));
            }
        })).build();
        builder.component(registeredElementBuilder.build());
    }

    public static <T extends Enum<T>> void addEnumListToBuilder(String key, List<T> enums, Function<T, Component> nameMapper, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
        CompositeContainerComponent.Builder enumListBuilder = CompositeContainerComponent.builder();
        if (state.doPrefixSpace()) {
            enumListBuilder.space();
        }
        builder.component(((CompositeContainerComponent.Builder)enumListBuilder.translate(key, Styler::condition, new Object[0])).space().cycle(cycler -> enums.stream().map(nameMapper).map(component -> Styler.name(component.copy())).forEach(cycler::textComponent)).build());
    }

    public static <T> void addTagsToBuilder(String key, List<TagPredicate<T>> tags, LootConditionTooltips.State state, CompositeContainerComponent.Builder builder) {
        CompositeContainerComponent.Builder tagBuilder = CompositeContainerComponent.builder();
        if (state.doPrefixSpace()) {
            tagBuilder.space();
        }
        ((CompositeContainerComponent.Builder)tagBuilder.translate((String)(tags.size() == 1 ? key : key + ".multiple"), Styler::condition, new Object[0])).space().cycle(cycler -> tags.forEach(tag -> {
            TagKey tagKey = tag.tag();
            String prefix = tag.expected() ? "" : "!";
            cycler.textComponent((Component)Styler.name(Component.literal((String)"%s#%s".formatted(prefix, tagKey.location().toString()))));
        })).build();
        builder.component(tagBuilder.build());
    }
}

