/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.bettertrims.mixin.property.ability.equipment;

import com.bawnorton.bettertrims.property.TrimProperties;
import com.bawnorton.bettertrims.property.TrimProperty;
import com.bawnorton.bettertrims.property.ability.TrimAbilityComponents;
import com.bawnorton.bettertrims.property.ability.runner.TrimEntityAbilityRunner;
import com.bawnorton.bettertrims.property.ability.runner.TrimToggleAbilityRunner;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import java.util.function.BiConsumer;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={LivingEntity.class})
abstract class LivingEntityMixin
extends Entity {
    LivingEntityMixin(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    @WrapOperation(method={"collectEquipmentChanges"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;forEachModifier(Lnet/minecraft/world/entity/EquipmentSlot;Ljava/util/function/BiConsumer;)V")})
    private void stopTrimEquipmentBasedEffects(ItemStack stack, EquipmentSlot slot, BiConsumer<Holder<Attribute>, AttributeModifier> action, Operation<Void> original) {
        original.call(new Object[]{stack, slot, action});
        Level level = this.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        LivingEntity self = (LivingEntity)this;
        for (TrimProperty property : TrimProperties.getProperties((Level)level2)) {
            for (TrimToggleAbilityRunner<?> ability : property.getToggleAbilityRunners(TrimAbilityComponents.EQUIPPED)) {
                ability.runStop(level2, self, stack, slot);
            }
        }
    }

    @WrapOperation(method={"collectEquipmentChanges"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;forEachModifier(Lnet/minecraft/world/entity/EquipmentSlot;Ljava/util/function/BiConsumer;)V")})
    private void startTrimLocationBasedEffects(ItemStack stack, EquipmentSlot slot, BiConsumer<Holder<Attribute>, AttributeModifier> action, Operation<Void> original) {
        original.call(new Object[]{stack, slot, action});
        Level level = this.level();
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel level2 = (ServerLevel)level;
        LivingEntity self = (LivingEntity)this;
        for (TrimProperty property : TrimProperties.getProperties((Level)level2)) {
            for (TrimToggleAbilityRunner<?> ability : property.getToggleAbilityRunners(TrimAbilityComponents.EQUIPPED)) {
                ability.runStart(level2, self);
            }
        }
    }

    @WrapOperation(method={"baseTick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/enchantment/EnchantmentHelper;tickEffects(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/entity/LivingEntity;)V")})
    private void tickTrimEffects(ServerLevel level, LivingEntity entity, Operation<Void> original) {
        original.call(new Object[]{level, entity});
        for (TrimProperty property : TrimProperties.getProperties((Level)level)) {
            for (TrimEntityAbilityRunner<?> trimEntityAbilityRunner : property.getEntityAbilityRunners(TrimAbilityComponents.TICK)) {
                trimEntityAbilityRunner.runTick(level, entity, (Entity)entity, this.position());
            }
            for (TrimToggleAbilityRunner trimToggleAbilityRunner : property.getToggleAbilityRunners(TrimAbilityComponents.EQUIPPED)) {
                trimToggleAbilityRunner.update(level, entity);
            }
            if (this.tickCount % (int)level.tickRateManager().tickrate() != 0) continue;
            for (TrimEntityAbilityRunner trimEntityAbilityRunner : property.getEntityAbilityRunners(TrimAbilityComponents.SECOND)) {
                trimEntityAbilityRunner.runTick(level, entity, (Entity)entity, this.position());
            }
        }
    }
}

