/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.bettertrims.mixin.property.item_property.damage_immunity;

import com.bawnorton.bettertrims.property.TrimProperties;
import com.bawnorton.bettertrims.property.TrimProperty;
import com.bawnorton.bettertrims.property.context.TrimContexts;
import com.bawnorton.bettertrims.property.element.ElementMatcher;
import com.bawnorton.bettertrims.property.item.TrimItemPropertyComponents;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={Entity.class})
abstract class EntityMixin {
    @Shadow
    private Level level;

    EntityMixin() {
    }

    @ModifyReturnValue(method={"isInvulnerableTo"}, at={@At(value="RETURN")})
    private boolean isTrimInvulnerableTo(boolean original, DamageSource damageSource) {
        if (original) {
            return true;
        }
        EntityMixin entityMixin = this;
        if (!(entityMixin instanceof ItemEntity)) {
            return false;
        }
        ItemEntity itemEntity = (ItemEntity)entityMixin;
        Level level = this.level;
        if (!(level instanceof ServerLevel)) {
            return false;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        ItemStack stack = itemEntity.getItem();
        for (TrimProperty property : TrimProperties.getProperties((Level)serverLevel)) {
            for (ElementMatcher elementMatcher : property.getItemPropertyElements(TrimItemPropertyComponents.DAMAGE_IMMUNITY)) {
                if (!elementMatcher.matches(stack, TrimContexts.damageItem(serverLevel, stack, itemEntity, damageSource))) continue;
                return true;
            }
        }
        return false;
    }
}

