/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.bettertrims.property;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.HolderSetCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.armortrim.ArmorTrim;
import net.minecraft.world.item.armortrim.TrimMaterial;
import net.minecraft.world.item.armortrim.TrimPattern;

public record Matcher(HolderSet<TrimMaterial> material, HolderSet<TrimPattern> pattern, int minCount) {
    public static final Codec<Matcher> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)HolderSetCodec.create((ResourceKey)Registries.TRIM_MATERIAL, (Codec)TrimMaterial.CODEC, (boolean)false).optionalFieldOf("material", (Object)HolderSet.empty()).forGetter(Matcher::material), (App)HolderSetCodec.create((ResourceKey)Registries.TRIM_PATTERN, (Codec)TrimPattern.CODEC, (boolean)false).optionalFieldOf("pattern", (Object)HolderSet.empty()).forGetter(Matcher::pattern), (App)ExtraCodecs.intRange((int)1, (int)255).optionalFieldOf("min_count", (Object)1).forGetter(Matcher::minCount)).apply((Applicative)instance, Matcher::new));

    public static Matcher forMaterial(HolderSet<TrimMaterial> material, int minCount) {
        return new Matcher(material, (HolderSet<TrimPattern>)HolderSet.empty(), minCount);
    }

    public static Matcher forPattern(HolderSet<TrimPattern> pattern, int minCount) {
        return new Matcher((HolderSet<TrimMaterial>)HolderSet.empty(), pattern, minCount);
    }

    public Map<EquipmentSlot, ItemStack> getMatchingStacks(LivingEntity wearer) {
        HashMap<EquipmentSlot, ItemStack> stacks = new HashMap<EquipmentSlot, ItemStack>();
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            ItemStack stack = wearer.getItemBySlot(slot);
            EquipmentSlot shouldBeInSlot = wearer.getEquipmentSlotForItem(stack);
            if (slot != shouldBeInSlot || !this.matches(stack)) continue;
            stacks.put(slot, stack);
        }
        return stacks;
    }

    public boolean matches(LivingEntity wearer, ItemStack stack, EquipmentSlot slot) {
        EquipmentSlot shouldBeInSlot = wearer.getEquipmentSlotForItem(stack);
        return shouldBeInSlot == slot && this.matches(stack);
    }

    public boolean matches(ItemStack stack) {
        ArmorTrim trim = (ArmorTrim)stack.get(DataComponents.TRIM);
        if (trim == null) {
            return false;
        }
        return this.matches(trim);
    }

    public boolean matches(ArmorTrim trim) {
        Holder material = trim.material();
        Holder pattern = trim.pattern();
        boolean matchesMaterial = this.material.contains(material) || !(this.material instanceof HolderSet.Named) && this.material.size() == 0;
        boolean matchesPattern = this.pattern.contains(pattern) || !(this.pattern instanceof HolderSet.Named) && this.pattern.size() == 0;
        return matchesMaterial && matchesPattern;
    }
}

