/*
 * Decompiled with CFR 0.152.
 */
package com.bawnorton.bettertrims.client.tooltip.component;

import com.bawnorton.bettertrims.client.tooltip.component.CompositeBuilder;
import com.bawnorton.bettertrims.client.tooltip.component.CompositeComponent;
import com.bawnorton.bettertrims.client.tooltip.component.ConditionalComponent;
import com.bawnorton.bettertrims.client.tooltip.component.CyclingComponent;
import com.bawnorton.bettertrims.client.tooltip.component.DynamicWidthComponent;
import com.bawnorton.bettertrims.client.tooltip.component.StackedComponent;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTextTooltip;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;

public abstract class CompositeContainerComponent
implements CompositeComponent {
    protected final List<ClientTooltipComponent> components;
    protected final boolean centred;

    protected CompositeContainerComponent(List<ClientTooltipComponent> components, boolean centred) {
        this.components = components;
        this.centred = centred;
    }

    @Override
    public List<ClientTooltipComponent> getComponents() {
        return this.components;
    }

    public boolean isEmpty() {
        if (this.components.isEmpty()) {
            return true;
        }
        for (ClientTooltipComponent component : this.components) {
            if (!(component instanceof CompositeContainerComponent)) {
                return false;
            }
            CompositeContainerComponent composite = (CompositeContainerComponent)component;
            if (composite.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public boolean isCentred() {
        return this.centred;
    }

    public boolean showTooltipWithItemInHand() {
        for (ClientTooltipComponent component : this.components) {
            if (!component.showTooltipWithItemInHand()) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return "Composite{%s, centred=%s}".formatted(this.components, this.centred);
    }

    public int hashCode() {
        int result = this.components != null ? this.components.hashCode() : 0;
        result = 31 * result + (this.centred ? 1 : 0);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CompositeContainerComponent that = (CompositeContainerComponent)obj;
        if (this.centred != that.centred) {
            return false;
        }
        return Objects.equals(this.components, that.components);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends CompositeBuilder<CompositeContainerComponent> {
        private boolean spaced = false;
        private boolean vertical = false;
        private boolean centred = false;

        public Builder component(ClientTooltipComponent component) {
            if (component instanceof CompositeContainerComponent) {
                CompositeContainerComponent composite = (CompositeContainerComponent)component;
                if (composite.centred) {
                    this.centred = true;
                }
            } else if (component instanceof ConditionalComponent) {
                ConditionalComponent conditional = (ConditionalComponent)component;
                ClientTooltipComponent clientTooltipComponent = conditional.ifTrue();
                if (clientTooltipComponent instanceof CompositeContainerComponent) {
                    CompositeContainerComponent composite = (CompositeContainerComponent)clientTooltipComponent;
                    if (composite.centred) {
                        this.centred = true;
                    }
                } else {
                    clientTooltipComponent = conditional.ifFalse();
                    if (clientTooltipComponent instanceof CompositeContainerComponent) {
                        CompositeContainerComponent composite = (CompositeContainerComponent)clientTooltipComponent;
                        if (composite.centred) {
                            this.centred = true;
                        }
                    }
                }
            }
            return (Builder)super.component(component);
        }

        public Builder textComponent(Component component) {
            return (Builder)super.textComponent(component);
        }

        public Builder translate(String key, Object ... args) {
            return (Builder)super.translate(key, args);
        }

        public Builder translate(String key, UnaryOperator<Style> styler, Object ... args) {
            return (Builder)super.translate(key, styler, args);
        }

        public Builder literal(String text) {
            return (Builder)super.literal(text);
        }

        public Builder literal(String text, UnaryOperator<Style> styler) {
            return (Builder)super.literal(text, styler);
        }

        public Builder space() {
            return (Builder)super.space();
        }

        public Builder cycle(Consumer<CyclingComponent.Builder> consumer) {
            CyclingComponent.Builder builder = CyclingComponent.builder();
            consumer.accept(builder);
            CyclingComponent cycling = builder.build();
            return switch (cycling.size()) {
                case 0 -> this;
                case 1 -> this.component(cycling.get(0));
                default -> this.component(cycling);
            };
        }

        public Builder stack(List<? extends ClientTooltipComponent> components, int offset) {
            return this.component(new StackedComponent(components, offset));
        }

        public Builder spaced() {
            if (this.spaced) {
                return this;
            }
            this.spaced = true;
            return this;
        }

        public Builder vertical() {
            if (this.vertical) {
                return this;
            }
            this.vertical = true;
            return this;
        }

        public Builder horizontal() {
            if (!this.vertical) {
                return this;
            }
            this.vertical = false;
            return this;
        }

        public Builder centred(boolean centred) {
            this.centred = centred;
            return this;
        }

        @Override
        public CompositeContainerComponent build() {
            if (!this.spaced) {
                if (this.vertical) {
                    return new Vertical(this.components);
                }
                return new Horizontal(this.components, this.centred);
            }
            ArrayList<ClientTooltipComponent> spacedComponents = new ArrayList<ClientTooltipComponent>();
            for (int i = 0; i < this.components.size(); ++i) {
                spacedComponents.add((ClientTooltipComponent)this.components.get(i));
                if (i >= this.components.size() - 1) continue;
                spacedComponents.add((ClientTooltipComponent)new ClientTextTooltip(Component.literal((String)" ").getVisualOrderText()));
            }
            if (this.vertical) {
                return new Vertical(spacedComponents);
            }
            return new Horizontal(spacedComponents, this.centred);
        }
    }

    public static final class Vertical
    extends CompositeContainerComponent {
        private int horizontalOffset = 0;

        private Vertical(List<ClientTooltipComponent> components) {
            super(components, false);
        }

        public void setHorizontalOffset(int offset) {
            this.horizontalOffset = offset;
        }

        public int getHorizontalOffset() {
            return this.horizontalOffset;
        }

        public int getHeight(Font font) {
            int totalHeight = 0;
            for (ClientTooltipComponent component : this.components) {
                totalHeight += component.getHeight(font);
            }
            return totalHeight;
        }

        public int getWidth(Font font) {
            int maxWidth = 0;
            for (ClientTooltipComponent component : this.components) {
                if (component.getWidth(font) <= maxWidth) continue;
                maxWidth = component.getWidth(font);
            }
            return maxWidth - this.horizontalOffset;
        }

        public void renderImage(Font font, int x, int y, int width, int height, GuiGraphics graphics) {
            int currentY = y;
            int offsetX = x - this.horizontalOffset;
            for (int i = 0; i < this.components.size(); ++i) {
                ClientTooltipComponent component = (ClientTooltipComponent)this.components.get(i);
                int componentHeight = component.getHeight(font);
                component.renderImage(font, i == 0 ? x : offsetX, currentY, width, componentHeight, graphics);
                currentY += componentHeight;
            }
        }

        public void renderText(GuiGraphics graphics, Font font, int x, int y) {
            int currentY = y;
            int offsetX = x - this.horizontalOffset;
            for (int i = 0; i < this.components.size(); ++i) {
                ClientTooltipComponent component = (ClientTooltipComponent)this.components.get(i);
                int componentHeight = component.getHeight(font);
                component.renderText(graphics, font, i == 0 ? x : offsetX, currentY);
                currentY += componentHeight;
            }
        }

        @Override
        public boolean isOneLine() {
            if (this.components.size() > 1) {
                return false;
            }
            if (this.components.isEmpty()) {
                return true;
            }
            ClientTooltipComponent component = (ClientTooltipComponent)this.components.getFirst();
            if (component instanceof CompositeComponent) {
                CompositeComponent composite = (CompositeComponent)component;
                return composite.isOneLine();
            }
            return true;
        }
    }

    public static final class Horizontal
    extends CompositeContainerComponent {
        private Horizontal(List<ClientTooltipComponent> components, boolean centred) {
            super(components, centred);
        }

        public int getHeight(Font font) {
            int maxHeight = 0;
            for (ClientTooltipComponent component : this.components) {
                if (component.getHeight(font) <= maxHeight) continue;
                maxHeight = component.getHeight(font);
            }
            return maxHeight;
        }

        public int getWidth(Font font) {
            int totalWidth = 0;
            for (ClientTooltipComponent component : this.components) {
                totalWidth += component.getWidth(font);
            }
            return totalWidth;
        }

        @Override
        public int getMaxWidth(Font font) {
            int totalWidth = 0;
            for (ClientTooltipComponent component : this.components) {
                if (component instanceof DynamicWidthComponent) {
                    DynamicWidthComponent dynamic = (DynamicWidthComponent)component;
                    totalWidth += dynamic.getMaxWidth(font);
                    continue;
                }
                totalWidth += component.getWidth(font);
            }
            return totalWidth;
        }

        public void renderImage(Font font, int x, int y, int width, int height, GuiGraphics graphics) {
            int currentX = x;
            for (ClientTooltipComponent component : this.components) {
                int componentWidth = component.getWidth(font);
                component.renderImage(font, currentX, y, componentWidth, height, graphics);
                currentX += componentWidth;
            }
        }

        public void renderText(GuiGraphics graphics, Font font, int x, int y) {
            int currentX = x;
            int height = this.getHeight(font);
            for (ClientTooltipComponent component : this.components) {
                int componentWidth = component.getWidth(font);
                if (this.centred) {
                    int componentHeight = component.getHeight(font);
                    component.renderText(graphics, font, currentX, y + (height - componentHeight) / 2);
                } else {
                    component.renderText(graphics, font, currentX, y);
                }
                currentX += componentWidth;
            }
        }
    }
}

