package com.bawnorton.bettertrims.client.tooltip.component;

import java.util.ArrayList;
import java.util.List;
import java.util.function.UnaryOperator;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_5244;
import net.minecraft.class_5683;
import net.minecraft.class_5684;

public abstract class CompositeBuilder<T> {
	private static final class_5684 SPACE = new class_5683(class_5244.field_41874.method_30937());

	protected final List<class_5684> components = new ArrayList<>();

	public List<class_5684> peek() {
		return components.stream().toList();
	}

	public CompositeBuilder<T> component(class_5684 component) {
		components.add(component);
		return this;
	}

	public CompositeBuilder<T> textComponent(class_2561 component) {
		return component(new class_5683(component.method_30937()));
	}

	public CompositeBuilder<T> translate(String key, Object... args) {
		return textComponent(class_2561.method_43469(key, args));
	}

	public CompositeBuilder<T> translate(String key, UnaryOperator<class_2583> styler, Object... args) {
		return textComponent(class_2561.method_43469(key, args).method_27694(styler));
	}

	public CompositeBuilder<T> literal(String text) {
		return textComponent(class_2561.method_43470(text));
	}

	public CompositeBuilder<T> literal(String text, UnaryOperator<class_2583> styler) {
		return textComponent(class_2561.method_43470(text).method_27694(styler));
	}

	public CompositeBuilder<T> space() {
		return component(SPACE);
	}

	public abstract T build();
}
