package com.bawnorton.bettertrims.client.tooltip.component;

import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;

import java.util.List;
import java.util.function.UnaryOperator;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4597;
import net.minecraft.class_5684;

public final class CyclingComponent implements CompositeComponent {
	private final List<class_5684> components;

	private int index = 0;
	private int frameCounter = 0;

	public CyclingComponent(List<class_5684> components) {
		this.components = components;
	}

	@Override
	public List<class_5684> getComponents() {
		return components;
	}

	@Override
	//? if >=1.21.8 {
	/*public int getHeight(Font font) {
		return components.get(index).getHeight(font);
	}
	*///?} else {
	public int method_32661() {
		return components.get(index).method_32661();
	}
	//?}

	@Override
	public int method_32664(@NotNull class_327 font) {
		return components.get(index).method_32664(font);
	}

	//? if >=1.21.8 {
	/*@Override
	public void renderText(GuiGraphics graphics, Font font, int x, int y) {
		if (components.isEmpty()) return;

		if (frameCounter++ >= Minecraft.getInstance().getFps()) {
			frameCounter = 0;
			index = (index + 1) % components.size();
		}

		components.get(index).renderText(graphics, font, x, y);
	}

	@Override
	public void renderImage(@NotNull Font font, int x, int y, int width, int height, @NotNull GuiGraphics graphics) {
		if (components.isEmpty()) return;

		components.get(index).renderImage(font, x, y, width, height, graphics);
	}
	*///?} else {
	@Override
	public void method_32665(class_327 font, int mouseX, int mouseY, Matrix4f matrix, class_4597.class_4598 bufferSource) {
		if (components.isEmpty()) return;

		if (frameCounter++ >= class_310.method_1551().method_47599()) {
			frameCounter = 0;
			index = (index + 1) % components.size();
		}

		components.get(index).method_32665(font, mouseX, mouseY, matrix, bufferSource);
	}

	@Override
	public void method_32666(class_327 font, int x, int y, class_332 guiGraphics) {
		if (components.isEmpty()) return;

		components.get(index).method_32666(font, x, y, guiGraphics);
	}
	//?}

	public int size() {
		return components.size();
	}

	public class_5684 get(int index) {
		return components.get(index);
	}

	@Override
	public String toString() {
		return "Cycling{%s}".formatted(components);
	}

	public static Builder builder() {
		return new Builder();
	}

	public static class Builder extends CompositeBuilder<CyclingComponent> {
		public Builder component(class_5684 component) {
			return (Builder) super.component(component);
		}

		public Builder textComponent(class_2561 component) {
			return (Builder) super.textComponent(component);
		}

		public Builder translate(String key, Object... args) {
			return (Builder) super.translate(key, args);
		}

		public Builder translate(String key, UnaryOperator<class_2583> styler, Object... args) {
			return (Builder) super.translate(key, styler, args);
		}

		public Builder literal(String text) {
			return (Builder) super.literal(text);
		}

		public Builder literal(String text, UnaryOperator<class_2583> styler) {
			return (Builder) super.literal(text, styler);
		}

		public Builder space() {
			return (Builder) super.space();
		}

		public CyclingComponent build() {
			return new CyclingComponent(components);
		}
	}
}
